%PARAMTYPE_INDIR   Called by PARAMTYPE.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, 16, 18 September 2007.
% Built with code extracted from DIPIMAGE.M and GETPARAMS.M

function varargout = paramtype_indir(command,param,varargin)

switch command
   case 'control_create'
      fig = varargin{1};   % figure handle
      index = varargin{2}; % item number in the dialog box (1 is topmost control, 0 is topmost label)
      bh = uicontrol(fig,...
                     'Style','pushbutton',...
                     'String','Browse...',...
                     'Visible','off',...
                     'Tag',['control',num2str(index),'bis'],...
                     'HorizontalAlignment','center',...
                     'BusyAction','cancel',...
                     'Interruptible','off');
      eh = uicontrol(fig,...
                     'Style','edit',...
                     'String',param.default,...
                     'Visible','off',...
                     'Tag',['control',num2str(index)],...
                     'HorizontalAlignment','left',...
                     'BackgroundColor',[1,1,1]);
      set(bh,'Callback',['dipimage(''do_browse'',struct(',...
                         '''default'',''',param.default,''',',...
                         '''mask'',''',param.range_check,''',',...
                         '''title'',''',param.description,''',',...
                         '''editbox'',',handle2str(eh),',',...
                         '''direction'',''dir''))']);
      varargout{1} = [eh,bh];
   case 'control_value'
      varargout{2} = get(varargin{1},'String');
      varargout{1} = varargout{2};
      varargout{2} = ['''',varargout{2},''''];
   case 'default_value'
      varargout{1} = param.default;
   case 'definition_test'
      varargout{1} = '';
      if ~ischar(param.range_check)
         varargout{1} = 'RANGE_CHECK must be a string for indir';
      elseif ~param.required
         if ~ischar(param.default)
            varargout{1} = 'DEFAULT must be a string for indir';
         end
      end
   case 'value_test'
      varargout{1} = '';
      if ~ischar(varargin{1})
         varargout{1} = 'string expected';
      end
      varargout{2} = varargin{1};
end
