%SUBSASGN   Overloaded operator for a.name=b.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, November 2000.
% 5 February 2002: Measurement names are not case-sensitive any more.
% February 2008:   Added possibilty to change the structure, addition of 
%                  of non-diplib measurements (BR)
% 6 March 2008:    Allowing addition of arbitrary measurements. Not allowing
%                  changing of measurement values. See new method RMFIELD.

function a = subsasgn(a,s,b)
if length(s)==1 & strcmp(s.type,'.')
   name = s.subs;
   if strcmpi(name,'ID')
      % Change Label IDs for the measured objects.
      % All must change at the same time:
      if ~isnumeric(b) | length(size(b))~=2 | prod(size(b))~=length(a.id) | any(mod(b,1))
         error('Invalid label ID array.')
      end
      a.id = reshape(b,1,prod(size(b)));
      return
   elseif strcmpi(name,'prefix')
      % Prefix names with b.
      if ~ischar(b) | size(b,1)~=1
         error('Invalid prefix.')
      end
      for ii=1:length(a.names)
         a.names{ii} = [b,a.names{ii}];
      end
      return
   elseif ~any(strcmpi(name,a.names))
      % Add field 'name' with value b.
      if ~isnumeric(b) | length(size(b))~=2 | size(b,2)~=length(a.id)
         error('Invalid data array.')
      end
         n = length(a.names);
         a.names{n+1} = name;
         a.data{n+1} = b;
      return
   end
end
error('Do not mess with the dip_measurement object!')
