%SVD Singular value decomposition.
%  [U,S,V] = SVD(X) 
%
%  S = SVD(X) returns a dip_image_vector containing the singular values.
%
%  Computes the "economy size" decomposition.
%  If X is m-by-n with m >= n, then only the
%  first n columns of U are computed and S is n-by-n.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger, Nov 2005.
% 26 July 2007: Removed use of NEWIMAR (CL).

function varargout = svd(in)
if ~istensor(in)
   error('SVD only for tensor images.');
end
sz = imarsize(in);
if length(sz)~=2
   error('SVD oly for 2D matrices.');
end
[u,s,v]= dip_svd(in);
sz1 = imarsize(s);

if nargout <2
   tmp = dip_image('array',sz1(1));
   for ii=1:sz1(1)
      tmp(ii) = s(ii,ii);
   end
   varargout{1} = tmp;
elseif nargout ==3
   varargout{1}=u;
   varargout{2}=s;
   varargout{3}=v;
else
   error('Wrong number of output arguments.');
end
