%[IN,ARRAYOP] = DO1ARRAYINPUT(IN)
%    Checks the input image. If it is an image array, ARRAYOP is
%    non-zero. IN is converted to dip_image object iff ARRAYOP
%    is non-zero. If ARRAYOP is zero, IN is returned without
%    change. Furthermore, if IN is of type DIP_IMAGE_ARRAY, an
%    error is produced if not all the images are of the same size.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, November 2000.
% 15 November 2002: Fixed binary images to work in MATLAB 6.5 (R13)

function [in,arrayop] = do1arrayinput(in)
if nargin ~= 1, error('Erroneus input.'); end
if nargout ~= 2, error('Erroneus output.'); end
arrayop = 0;
if di_isdipimobj(in)
   if ~isscalar(in)
      arrayop = 1;
   end
end
if arrayop
   if ~istensor(in)
      error('Parameter is an array of images, but not a tensor.')
   end
end
