%PHASE  Phase angle.
%   PHASE(B) returns the phase angles, in radians, of a complex
%   image. This is the same as the MATLAB command ANGLE.
%
%   See also ANGLE, ABS, UNWRAP.

%   Copyright (c) 1984-98 by The MathWorks, Inc.
%   $Revision: 19 $  $Date: 2001-07-18 16:42:50 +0200 (Wed, 18 Jul 2001) $

function out = phase(in)

% Clever way:
% out = imag(log(in));

% Way we'll do it:
out = atan2(imag(in), real(in));
