%INNER   Euclidean inner product of two tensor images.
%   INNER(A,B) returns the Euclidean inner product of the tensors
%   in the dip_image_arrays A and B.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger and Cris Luengo, July 2000.

function out = inner(in1,in2)
try
   [in1,in2,arrayop] = doarrayinputs(in1,in2);
catch
   error(di_firsterr)
end
if arrayop
   s1 = imarsize(in1);
   s2 = imarsize(in2);
   if length(s1) ~= length(s2) | s1 ~= s2
      error('Tensor sizes do not match.')
   end
   out = in1(1).*in2(1);
   for ii=2:prod(s1)
      out = out+in1(ii)*in2(ii);
   end
else
   error('Operation only defined for tensor images.')
end
