%DET   Determinant of a tensor image.
%   DET(A) returns the determinant of the square tensors in the
%   dip_image_array A.
%
%   DET is only implemented for square tensors with sizes up to 4x4.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger and Cris Luengo, July 2000.
% Nov, 2002 4x4 deteriments added (BR)

function out = det(in)
if ~istensor(in)
   error('Image is not a tensor image.');
end
s = imarsize(in);
if length(s) ~= 2 | s(1) ~= s(2)
   error('Tensor must be square.')
end
switch s(1)
case 1
   out = in;
case 2
   out = in(1,1)*in(2,2) - in(2,1)*in(1,2);
case 3
   out = in(1,1)*in(2,2)*in(3,3) + in(1,2)*in(2,3)*in(3,1) + in(1,3)*in(2,1)*in(3,2) - ...
         in(3,1)*in(2,2)*in(1,3) - in(3,2)*in(2,3)*in(1,1) - in(3,3)*in(2,1)*in(1,2);
case 4
   out = ...
      in(1,1)*in(2,2)*in(3,3)*in(4,4) - in(1,1)*in(2,2)*in(3,4)*in(4,3) -...
      in(1,1)*in(3,2)*in(2,3)*in(4,4) + in(1,1)*in(3,2)*in(2,4)*in(4,3) +...
      in(1,1)*in(4,2)*in(2,3)*in(3,4) - in(1,1)*in(4,2)*in(2,4)*in(3,3) -...
      in(2,1)*in(1,2)*in(3,3)*in(4,4) + in(2,1)*in(1,2)*in(3,4)*in(4,3) +...
      in(2,1)*in(3,2)*in(1,3)*in(4,4) - in(2,1)*in(3,2)*in(1,4)*in(4,3) -...
      in(2,1)*in(4,2)*in(1,3)*in(3,4) + in(2,1)*in(4,2)*in(1,4)*in(3,3) +...
      in(3,1)*in(1,2)*in(2,3)*in(4,4) - in(3,1)*in(1,2)*in(2,4)*in(4,3) -...
      in(3,1)*in(2,2)*in(1,3)*in(4,4) + in(3,1)*in(2,2)*in(1,4)*in(4,3) +...
      in(3,1)*in(4,2)*in(1,3)*in(2,4) - in(3,1)*in(4,2)*in(1,4)*in(2,3) -...
      in(4,1)*in(1,2)*in(2,3)*in(3,4) + in(4,1)*in(1,2)*in(2,4)*in(3,3) +...
      in(4,1)*in(2,2)*in(1,3)*in(3,4) - in(4,1)*in(2,2)*in(1,4)*in(3,3) -...
      in(4,1)*in(3,2)*in(1,3)*in(2,4) + in(4,1)*in(3,2)*in(1,4)*in(2,3);
otherwise
   error('Determinat only implemented for tensors with sizes up to 4x4.')
end
