%COMPLEX   Construct complex image from real and imaginary parts.
%   COMPLEX(A,B) returns the complex result A + Bi, where A and B
%   are identically sized images of the same data type.
%
%   COMPLEX(A) returns the complex result A + 0i, where A must
%   be real.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, May 2000.
% February 2008: Adding pixel dimensions and units to dip_image. (BR)

function out = complex(in1,in2)
if nargin == 1
   out = in1; % backup in case it already is complex
   try
      [in1,dims,out_type,out_phys] = do1input(in1);
   catch
      error(di_firsterr)
   end
   dt1 = di_diptype(in1);
   if any(strcmp(dt1,{'dfloat','sfloat'}))
      dt1 = di_mattype(dt1);
   elseif any(strcmp(dt1,{'dcomplex','scomplex'}))
      return
   else
      in1 = single(in1);
      dt1 = 'single';
   end
   in2 = di_create(size(in1),dt1);
else % nargin == 2
   try
      [in1,in2,dims,out_type,out_phys] = do2inputs(in1,in2);
   catch
      error(di_firsterr)
   end
   dt1 = di_diptype(in1);
   if any(strcmp(dt1,{'dfloat','sfloat'}))
      % OK
   elseif any(strcmp(dt1,{'dcomplex','scomplex'}))
      error('Input argument # 1 is already complex.')
   else
      dt1 = 'sfloat';
   end
   dt2 = di_diptype(in2);
   if any(strcmp(dt2,{'dfloat','sfloat'}))
      % OK
   elseif any(strcmp(dt2,{'dcomplex','scomplex'}))
      error('Input argument # 2 is already complex.')
   else
      dt1 = 'sfloat';
   end
   if any(strcmp({dt1,dt2},'dfloat'))
      in1 = double(in1);
      in2 = double(in2);
   else
      in1 = single(in1);
      in2 = single(in2);
   end
end
try
   out = dip_image(complex(in1,in2));
   out.dims = dims;
   out.physDims = out_phys;
catch
   error(di_firsterr)
end
