/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.util.Vector;

public class View5D
extends Applet {
    public int SizeX = 0;
    public int SizeY = 0;
    public int SizeZ = 0;
    int Elements = 1;
    int Times = 1;
    int defaultColor0 = -1;
    int redEl = -1;
    int greenEl = -1;
    int blueEl = -1;
    My3DData data3d;
    TextArea myLabel;
    ImgPanel mypan = null;
    Vector panels = new Vector();
    public String filename = null;

    public void UpdatePanels() {
        for (int i = 0; i < this.panels.size(); ++i) {
            ((ImgPanel)this.panels.elementAt((int)i)).c1.UpdateAllNoCoord();
        }
    }

    public static View5D Start5DViewer(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = AnElement.ByteType;
        int n7 = 1;
        int n8 = 8;
        View5D view5D = View5D.Prepare5DViewer(n, n2, n3, n4, n5, n6, n7, n8);
        ((ByteElement)view5D.data3d.ActElement()).myData = byArray;
        AlternateViewer alternateViewer = new AlternateViewer(view5D, 600, 500);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (j == 0 && i == 0) {
                    alternateViewer.Assign3DData(view5D, view5D.mypan, view5D.data3d);
                    continue;
                }
                System.arraycopy(byArray, (j + n4 * i) * n * n2 * n3, ((ByteElement)view5D.data3d.ElementAt((int)j, (int)i)).myData, 0, n * n2 * n3);
            }
        }
        view5D.start();
        return view5D;
    }

    public static View5D Start5DViewer(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = AnElement.FloatType;
        int n7 = 4;
        int n8 = 32;
        View5D view5D = View5D.Prepare5DViewer(n, n2, n3, n4, n5, n6, n7, n8);
        ((FloatElement)view5D.data3d.ActElement()).myData = fArray;
        AlternateViewer alternateViewer = new AlternateViewer(view5D, 600, 500);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (j == 0 && i == 0) {
                    alternateViewer.Assign3DData(view5D, view5D.mypan, view5D.data3d);
                    continue;
                }
                System.arraycopy(fArray, (j + n4 * i) * n * n2 * n3, ((FloatElement)view5D.data3d.ElementAt((int)j, (int)i)).myData, 0, n * n2 * n3);
            }
        }
        view5D.start();
        return view5D;
    }

    public static View5D Start5DViewerC(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = AnElement.ComplexType;
        int n7 = 8;
        int n8 = 64;
        View5D view5D = View5D.Prepare5DViewer(n, n2, n3, n4, n5, n6, n7, n8);
        ((ComplexElement)view5D.data3d.ActElement()).myData = fArray;
        AlternateViewer alternateViewer = new AlternateViewer(view5D, 600, 500);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (j == 0 && i == 0) {
                    alternateViewer.Assign3DData(view5D, view5D.mypan, view5D.data3d);
                    continue;
                }
                System.arraycopy(fArray, 2 * (j + n4 * i) * n * n2 * n3, ((ComplexElement)view5D.data3d.ElementAt((int)j, (int)i)).myData, 0, 2 * n * n2 * n3);
            }
        }
        view5D.start();
        return view5D;
    }

    public static View5D Start5DViewer(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = AnElement.DoubleType;
        int n7 = 8;
        int n8 = 64;
        View5D view5D = View5D.Prepare5DViewer(n, n2, n3, n4, n5, n6, n7, n8);
        ((DoubleElement)view5D.data3d.ActElement()).myData = dArray;
        AlternateViewer alternateViewer = new AlternateViewer(view5D, 600, 500);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (j == 0 && i == 0) {
                    alternateViewer.Assign3DData(view5D, view5D.mypan, view5D.data3d);
                    continue;
                }
                System.arraycopy(dArray, (j + n4 * i) * n * n2 * n3, ((DoubleElement)view5D.data3d.ElementAt((int)j, (int)i)).myData, 0, n * n2 * n3);
            }
        }
        view5D.start();
        return view5D;
    }

    public static View5D Start5DViewer(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = AnElement.IntegerType;
        int n7 = 4;
        int n8 = 32;
        View5D view5D = View5D.Prepare5DViewer(n, n2, n3, n4, n5, n6, n7, n8);
        ((IntegerElement)view5D.data3d.ActElement()).myData = nArray;
        AlternateViewer alternateViewer = new AlternateViewer(view5D, 600, 500);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (j == 0 && i == 0) {
                    alternateViewer.Assign3DData(view5D, view5D.mypan, view5D.data3d);
                    continue;
                }
                System.arraycopy(nArray, (j + n4 * i) * n * n2 * n3, ((IntegerElement)view5D.data3d.ElementAt((int)j, (int)i)).myData, 0, n * n2 * n3);
            }
        }
        view5D.start();
        return view5D;
    }

    public static View5D Start5DViewer(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n * n2 * n3 * n5 * n4];
        for (int i = 0; i < n * n2 * n3 * n5 * n4; ++i) {
            nArray[i] = sArray[i];
        }
        return View5D.Start5DViewer(nArray, n, n2, n3, n4, n5);
    }

    public String ExportMarkers() {
        return this.data3d.MyMarkers.PrintList(this.data3d);
    }

    public double[][] ExportMarkers(int n) {
        return this.data3d.MyMarkers.ExportMarkers(n);
    }

    public void ImportMarkers(float[][] fArray, int n) {
        this.data3d.NewMarkerList();
        this.data3d.MyMarkers.ImportPositions(fArray, n);
        this.data3d.InvalidateSlices();
        this.mypan.c1.UpdateAllNoCoord();
    }

    public static View5D Prepare5DViewer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        double[] dArray = new double[5];
        for (int i = 0; i < 5; ++i) {
            dArray[i] = 1.0;
        }
        double[] dArray2 = new double[5];
        for (int i = 0; i < 5; ++i) {
            dArray2[i] = 0.0;
        }
        double d = 1.0;
        double d2 = 0.0;
        int n12 = 0;
        int n13 = -1;
        int n14 = -1;
        if (n4 > 1) {
            n13 = 1;
        }
        if (n4 > 1) {
            n9 = 0;
            n10 = 1;
        }
        if (n4 > 2) {
            n11 = 2;
        }
        if (n4 >= 5) {
            n9 = -1;
            n10 = -1;
            n11 = -1;
        }
        String[] stringArray = new String[5];
        String[] stringArray2 = new String[5];
        stringArray[0] = "X";
        stringArray[1] = "Y";
        stringArray[2] = "Z";
        stringArray[3] = "Elements";
        stringArray[4] = "Time";
        stringArray2[0] = "pixels";
        stringArray2[1] = "ypixels";
        stringArray2[2] = "zpixels";
        stringArray2[3] = "elements";
        stringArray2[4] = "time";
        String string = "intensity";
        String string2 = "a.u.";
        View5D view5D = new View5D();
        My3DData my3DData = new My3DData(view5D, n, n2, n3, n4, n5, n9, n10, n11, n12, n13, n14, n6, n7, n8, dArray, dArray2, d, d2, stringArray, stringArray2);
        System.out.println("created data " + n4);
        for (int i = 0; i < n4; ++i) {
            my3DData.SetValueScale(i, d, d2, string, string2);
        }
        view5D.data3d = my3DData;
        view5D.Elements = n4;
        view5D.Times = n5;
        view5D.SizeX = n;
        view5D.SizeY = n2;
        view5D.SizeZ = n3;
        view5D.redEl = n9;
        view5D.greenEl = n10;
        view5D.blueEl = n11;
        view5D.initLayout(n5);
        if (n4 > 1 && n4 < 5 || n9 >= 0) {
            my3DData.ToggleColor(true);
        } else {
            my3DData.ToggleColor(false);
        }
        return view5D;
    }

    int ParseInt(String string, boolean bl, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(this.getParameter(string));
        }
        catch (Exception exception) {
            if (bl) {
                System.out.println("ParseInt: Caught Exceptionlooking for Parameter " + string + ":" + exception.getMessage());
                exception.printStackTrace();
            }
            n2 = n;
        }
        return n2;
    }

    double ParseDouble(String string, boolean bl, double d) {
        double d2;
        try {
            d2 = Double.valueOf(this.getParameter(string));
        }
        catch (Exception exception) {
            if (bl) {
                System.out.println("ParseDouble: Caught Exception looking for Parameter " + string + ":" + exception.getMessage());
                exception.printStackTrace();
            }
            d2 = d;
        }
        return d2;
    }

    String ParseString(String string, boolean bl, String string2) {
        String string3 = null;
        try {
            string3 = this.getParameter(string);
        }
        catch (Exception exception) {
            if (bl) {
                System.out.println("ParseString: Caught Exception looking for Parameter " + string + ":" + exception.getMessage());
                exception.printStackTrace();
            }
            string3 = string2;
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public String StringFromType(int n) {
        if (n >= 0 && n < AnElement.NumTypes) {
            return AnElement.TypeNames[n];
        }
        System.out.println("Error in StringFromType: Unknown datatype: " + n + "\n");
        return "";
    }

    public int TypeFromString(String string) {
        for (int i = 0; i < AnElement.NumTypes; ++i) {
            if (!string.equals(AnElement.TypeNames[i]) && !string.equals(AnElement.UTypeNames[i])) continue;
            return i;
        }
        System.out.println("Error: Unknown datatype: " + string + "\n");
        return -1;
    }

    public void initLayout(int n) {
        this.setLayout(new BorderLayout());
        this.mypan = new ImgPanel(this, this.data3d);
        this.panels.addElement(this.mypan);
        this.add("Center", this.mypan);
        this.myLabel = new TextArea("5D-viewer Java Applet by Rainer Heintzmann, [press '?' for help]", 1, 76, 3);
        this.add("North", this.myLabel);
        this.mypan.CheckScrollBar();
        this.setVisible(true);
    }

    public void init() {
        if (System.getProperty("java.version").compareTo("1.1") < 0) {
            this.setLayout(new BorderLayout());
            this.add("North", new ImageErr());
            this.setVisible(true);
        } else {
            String string;
            int n;
            this.filename = this.getParameter("file");
            if (this.filename == null) {
                this.filename = "xxx.raw";
            }
            this.SizeX = Integer.parseInt(this.getParameter("sizex"));
            this.SizeY = Integer.parseInt(this.getParameter("sizey"));
            this.SizeZ = this.ParseInt("sizez", true, 1);
            this.Times = this.ParseInt("times", false, 1);
            this.defaultColor0 = this.ParseInt("defcol0", false, -1);
            this.Elements = this.ParseInt("elements", true, 1);
            if (this.Elements > 1) {
                this.redEl = 0;
                this.greenEl = 1;
            }
            if (this.Elements > 2) {
                this.blueEl = 2;
            }
            if (this.Elements >= 5) {
                this.redEl = -1;
                this.greenEl = -1;
                this.blueEl = -1;
            }
            this.redEl = this.ParseInt("red", false, this.redEl);
            this.greenEl = this.ParseInt("green", false, this.greenEl);
            this.blueEl = this.ParseInt("blue", false, this.blueEl);
            int n2 = AnElement.ByteType;
            int n3 = 1;
            int n4 = 8;
            n3 = this.ParseInt("bytes", false, n3);
            n4 = this.ParseInt("bits", false, n4);
            if (n3 > 1) {
                n2 = AnElement.IntegerType;
            } else if (n3 == -1) {
                n2 = AnElement.FloatType;
                n3 = 4;
                n4 = 32;
            }
            if (n3 * 8 < n4) {
                n4 = n3 * 8;
            }
            if ((n = this.TypeFromString(string = this.ParseString("dtype", false, this.StringFromType(n2)))) != n2) {
                n2 = n;
                if (n2 == AnElement.IntegerType && n3 < 1) {
                    n3 = 2;
                }
                if (n2 == AnElement.ByteType) {
                    n3 = 1;
                }
                if (n2 == AnElement.FloatType) {
                    n3 = 4;
                }
                if (n2 == AnElement.DoubleType) {
                    n3 = 8;
                }
                if (n2 == AnElement.ComplexType) {
                    n3 = 8;
                }
                if (n2 == AnElement.ShortType) {
                    n2 = AnElement.IntegerType;
                    n3 = 2;
                }
                if (n2 == AnElement.LongType) {
                    n2 = AnElement.IntegerType;
                    n3 = 4;
                }
            }
            double[] dArray = new double[5];
            for (int i = 0; i < 5; ++i) {
                dArray[i] = 1.0;
            }
            double[] dArray2 = new double[5];
            for (int i = 0; i < 5; ++i) {
                dArray2[i] = 0.0;
            }
            double d = 1.0;
            double d2 = 0.0;
            dArray[0] = this.ParseDouble("scalex", false, 1.0);
            dArray[1] = this.ParseDouble("scaley", false, 1.0);
            dArray[2] = this.ParseDouble("scalez", false, 1.0);
            dArray[3] = this.ParseDouble("scalee", false, 1.0);
            dArray[4] = this.ParseDouble("scalet", false, 1.0);
            dArray2[0] = this.ParseDouble("offsetx", false, 0.0);
            dArray2[1] = this.ParseDouble("offsety", false, 0.0);
            dArray2[2] = this.ParseDouble("offsetz", false, 0.0);
            dArray2[3] = this.ParseDouble("offsete", false, 0.0);
            dArray2[4] = this.ParseDouble("offsett", false, 0.0);
            String[] stringArray = new String[5];
            String[] stringArray2 = new String[5];
            String string2 = "intensity";
            String string3 = "a.u.";
            stringArray[0] = this.ParseString("namex", false, "X");
            stringArray[1] = this.ParseString("namey", false, "Y");
            stringArray[2] = this.ParseString("namez", false, "Z");
            stringArray[3] = this.ParseString("namee", false, "Elements");
            stringArray[4] = this.ParseString("namet", false, "Time");
            stringArray2[0] = this.ParseString("unitsx", false, "pixels");
            stringArray2[1] = this.ParseString("unitsy", false, "ypixels");
            stringArray2[2] = this.ParseString("unitsz", false, "zpixels");
            stringArray2[3] = this.ParseString("unitse", false, "elements");
            stringArray2[4] = this.ParseString("unitst", false, "time");
            if (this.SizeX <= 0) {
                this.SizeX = 256;
            }
            if (this.SizeY <= 0) {
                this.SizeY = 256;
            }
            if (this.SizeZ <= 0) {
                this.SizeZ = 10;
            }
            int n5 = 0;
            int n6 = -1;
            int n7 = -1;
            if (this.Elements > 1) {
                n6 = 1;
            }
            n5 = this.ParseInt("histox", false, n5);
            n6 = this.ParseInt("histoy", false, n6);
            n7 = this.ParseInt("histoz", false, n7);
            this.data3d = new My3DData(this, this.SizeX, this.SizeY, this.SizeZ, this.Elements, this.Times, this.redEl, this.greenEl, this.blueEl, n5, n6, n7, n2, n3, n4, dArray, dArray2, d, d2, stringArray, stringArray2);
            if (this.defaultColor0 > 0) {
                this.data3d.ToggleModel(0, this.defaultColor0);
            }
            for (int i = 0; i < this.Elements; ++i) {
                d = this.ParseDouble("scalev" + (i + 1), false, 1.0);
                d2 = this.ParseDouble("offsetv" + (i + 1), false, 0.0);
                string2 = this.ParseString("namev" + (i + 1), false, "intensity");
                string3 = this.ParseString("unitsv" + (i + 1), false, "a.u.");
                this.data3d.SetValueScale(i, d, d2, string2, string3);
            }
            this.data3d.Load(n2, n3, n4, this.filename, this);
            this.data3d.markerInfilename = this.getParameter("markerInFile");
            if (this.data3d.markerInfilename != null) {
                System.out.println("... loading marker file " + this.data3d.markerInfilename);
                this.data3d.LoadMarkers();
            }
            this.data3d.markerOutfilename = this.getParameter("markerOutFile");
            this.initLayout(this.Times);
            if (this.Elements > 1 && this.Elements < 5 || this.redEl >= 0) {
                this.data3d.ToggleColor(true);
            } else {
                this.data3d.ToggleColor(false);
            }
        }
    }

    public void start() {
        this.data3d.AdjustThresh(true);
        this.mypan.InitScaling();
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "A 5Dimage viewing tool.";
    }
}

