/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.Locale;

class PositionLabel
extends Panel
implements MouseListener {
    ImageCanvas c1;
    ImageCanvas c2;
    ImageCanvas c3;
    My3DData data3d;
    Label l1;
    Label l2;
    Label l3;
    Label l4;
    Label l5;
    Label l6;
    PixelDisplay PixDisplay;
    TextArea MyText;
    NumberFormat nf;
    NumberFormat nf2;
    Scrollbar TimeScrollbar = null;
    int px = 0;
    int py = 0;
    int pz = 0;
    int pt = 0;
    int lnr = -1;
    int lpos = -1;
    PopupMenu MyPopupMenu;
    CheckboxMenuItem DispIntScaleOffset;
    CheckboxMenuItem DispPosSizePix;
    CheckboxMenuItem DispPosWorld;
    CheckboxMenuItem DispROIInfo;
    CheckboxMenuItem DispCoordScales;
    CheckboxMenuItem DispThreshColor;
    CheckboxMenuItem DispListNrPos;
    CheckboxMenuItem DispMarkerInfo;

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.MyPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            this.CoordsChanged();
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.MyPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            this.CoordsChanged();
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public PositionLabel(String string, ImageCanvas imageCanvas, ImageCanvas imageCanvas2, ImageCanvas imageCanvas3, My3DData my3DData) {
        this.c1 = imageCanvas;
        this.c2 = imageCanvas2;
        this.c3 = imageCanvas3;
        this.data3d = my3DData;
        this.MyText = new TextArea(string, 15, 30);
        this.MyText.setEditable(false);
        this.PixDisplay = new PixelDisplay(my3DData, this.c1, this.c2, this.c3);
        this.nf = NumberFormat.getNumberInstance(Locale.US);
        this.nf.setMaximumFractionDigits(2);
        this.nf.setGroupingUsed(false);
        this.nf2 = NumberFormat.getNumberInstance(Locale.US);
        this.nf2.setMaximumFractionDigits(4);
        this.nf2.setGroupingUsed(false);
        GridLayout gridLayout = new GridLayout(2, 2);
        this.setLayout(gridLayout);
        this.add(this.MyText);
        this.add(this.PixDisplay);
        this.MyText.addMouseListener(this);
        this.MyPopupMenu = new PopupMenu("Text Menu");
        PopupMenu popupMenu = new PopupMenu("Text to Display");
        this.add(this.MyPopupMenu);
        this.MyPopupMenu.add(popupMenu);
        this.DispIntScaleOffset = new CheckboxMenuItem("Intensity, Scale, Offset: ", true);
        popupMenu.add(this.DispIntScaleOffset);
        this.DispPosSizePix = new CheckboxMenuItem("Position, Size (Pixel coordinates): ", true);
        popupMenu.add(this.DispPosSizePix);
        this.DispPosWorld = new CheckboxMenuItem("Position, (world coordinates): ", true);
        popupMenu.add(this.DispPosWorld);
        this.DispROIInfo = new CheckboxMenuItem("ROI Information: ", true);
        popupMenu.add(this.DispROIInfo);
        this.DispCoordScales = new CheckboxMenuItem("Coordinate Scales: ", true);
        popupMenu.add(this.DispCoordScales);
        this.DispThreshColor = new CheckboxMenuItem("Thresholds, Color: ", true);
        popupMenu.add(this.DispThreshColor);
        this.DispListNrPos = new CheckboxMenuItem("List Nr., Position: ", true);
        popupMenu.add(this.DispListNrPos);
        this.DispMarkerInfo = new CheckboxMenuItem("Marker and List Information: ", true);
        popupMenu.add(this.DispMarkerInfo);
    }

    void Help() {
        String string = "Java 5D image viewer, Version V1.0.17 beta by Rainer Heintzmann,\nKCL, London (rainer.heintzmann@kcl.ac.uk)\n\nRight-click for menu\nUse mouse click for changing slices, \nShift and mouse-drag for square ROIs, Ctrl and mouse-drag for multiple line ROIs\ndrag images, zoom by typing 'A' and 'a' or into ROI by 'Z'\nArrow keys for fine control of slicing\n'next page' and 'prev. page'  for changing perpendicular slice ,\n'<' and '>' for perpendicular magnificaltion\n'i' for init view, 'c' for change ColorMap, \n1,2,5,6' for lower and '3,4,7,8' for upper Threshold, 't' and 'T' for automatic contrast adjustment using one or all elements\n'e' : toggle elements (if present), 'C' : toggle multicolor display, 'r','g','b' : select element for respective display\n'R','G','B' : clear respective channel, 'p','P': Toggle Projections (MIP, Avg)\n For Documentation see http://www.gwdg.de/~rheintz/View5D/";
        this.MyText.setText(string);
        this.MyText.setCaretPosition(0);
    }

    void PrintPointList() {
        this.MyText.setText(this.data3d.GetMarkerPrintout(this.data3d));
        this.MyText.setCaretPosition(0);
    }

    String GetPositionString() {
        String string = "";
        string = string + "Pos: (" + this.nf.format((double)((int)this.c2.PositionValue) * this.data3d.GetScale(0, 0) + this.data3d.GetOffset(0, 0)) + ", " + this.nf.format((double)((int)this.c3.PositionValue) * this.data3d.GetScale(0, 1) + this.data3d.GetOffset(0, 1)) + ", " + this.nf.format((double)((int)this.c1.PositionValue) * this.data3d.GetScale(0, 2) + this.data3d.GetOffset(0, 2)) + ", " + this.nf.format((double)this.data3d.GetActiveElement() * this.data3d.GetScale(0, 3) + this.data3d.GetOffset(0, 3)) + ", " + this.nf.format((double)this.data3d.GetActiveTime() * this.data3d.GetScale(0, 4) + this.data3d.GetOffset(0, 4)) + ") [" + this.data3d.GetAxisUnits()[0] + ", " + this.data3d.GetAxisUnits()[1] + ", " + this.data3d.GetAxisUnits()[2] + ", " + this.data3d.GetAxisUnits()[3] + ", " + this.data3d.GetAxisUnits()[4] + "]";
        return string;
    }

    String CreateValueString(String string) {
        String string2 = this.data3d.GetValueName(this.data3d.GetActiveElement()) + " [" + this.data3d.GetValueUnit(this.data3d.GetActiveElement()) + "]: " + string;
        return string2;
    }

    String CreateValueString(double d) {
        return this.CreateValueString(this.nf.format(d));
    }

    String GetValueString() {
        return this.CreateValueString(this.data3d.ActElement().GetValueStringAt((int)this.c2.PositionValue, (int)this.c3.PositionValue, (int)this.c1.PositionValue));
    }

    void CoordsChanged() {
        this.px = (int)this.c2.PositionValue;
        this.py = (int)this.c3.PositionValue;
        this.pz = (int)this.c1.PositionValue;
        this.pt = this.data3d.ActiveTime;
        this.lnr = this.data3d.MyMarkers.ActiveList;
        this.lpos = this.data3d.MyMarkers.ActivePoint;
        int n = this.data3d.GetActiveElement();
        int n2 = this.data3d.GetChannel(0);
        int n3 = this.data3d.GetChannel(1);
        int n4 = this.data3d.GetChannel(2);
        boolean bl = this.data3d.GetColorMode();
        boolean bl2 = this.data3d.GetProjectionMode(2);
        boolean bl3 = this.data3d.DataToHistogram != null;
        Rectangle rectangle = this.PixDisplay.getBounds();
        this.PixDisplay.CoordinatesChanged();
        double d = this.data3d.GetROISize(-1, 0);
        double d2 = this.data3d.GetROISize(-1, 1);
        double d3 = this.data3d.GetROISize(-1, 2);
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        String string = this.data3d.GetAxisUnits()[0];
        String string2 = this.data3d.GetAxisUnits()[1];
        String string3 = this.data3d.GetAxisUnits()[2];
        String string4 = this.data3d.GetAxisUnits()[3];
        String string5 = this.data3d.GetAxisUnits()[4];
        String string6 = this.data3d.GetAxisNames()[0];
        String string7 = this.data3d.GetAxisNames()[1];
        String string8 = this.data3d.GetAxisNames()[2];
        double d5 = this.data3d.GetScale(0, 0);
        double d6 = this.data3d.GetScale(0, 1);
        double d7 = this.data3d.GetScale(0, 2);
        double d8 = this.data3d.GetScale(0, 3);
        double d9 = this.data3d.GetScale(0, 4);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        for (int i = 1; i < this.data3d.NumMarkers(-1); ++i) {
            if (i == this.data3d.ActiveMarkerPos()) {
                d10 = this.data3d.GetPoint((int)i).coord[0];
                d11 = this.data3d.GetPoint((int)i).coord[1];
                d12 = this.data3d.GetPoint((int)i).coord[2];
                d13 = this.data3d.GetPoint((int)(i - 1)).coord[0];
                d14 = this.data3d.GetPoint((int)(i - 1)).coord[1];
                d15 = this.data3d.GetPoint((int)(i - 1)).coord[2];
                d21 = (this.data3d.GetPoint((int)i).coord[4] - this.data3d.GetPoint((int)(i - 1)).coord[4]) * d9;
                d16 = (d10 - d13) * (d10 - d13) * d5 * d5 + (d11 - d14) * (d11 - d14) * d6 * d6;
                d18 = Math.sqrt(d16 + (d12 - d15) * (d12 - d15) * d7 * d7);
                d17 = Math.sqrt(d16);
                d19 = d18;
                d22 = d12 - d15 != 0.0 && d7 != 0.0 ? d17 / (d12 - d15) / d7 : 0.0;
                d23 = d21 != 0.0 ? d19 / d21 : 0.0;
                d24 = this.data3d.GetPoint((int)i).integral;
                d25 = this.data3d.GetPoint((int)i).max;
            }
            d20 += d18;
        }
        String string9 = "";
        if (this.data3d.GateActive) {
            string9 = "(gated) ";
        }
        String string10 = "";
        if (this.DispIntScaleOffset.getState()) {
            string10 = string10 + this.GetValueString() + ", scale :" + this.nf.format(this.data3d.GetValueScale(n)) + ", offset: " + this.data3d.GetValueOffset(n) + "\n";
        }
        if (this.DispPosSizePix.getState()) {
            string10 = string10 + "at (" + this.nf.format(this.px) + ", " + this.nf.format(this.py) + ", " + this.nf.format(this.pz) + ", " + this.nf.format(n) + ", " + this.nf.format(this.pt) + ") of (" + this.data3d.SizeX + ", " + this.data3d.SizeY + ", " + this.data3d.SizeZ + ", " + this.data3d.Elements + ", " + this.data3d.Times + ")\n";
        }
        if (this.DispPosWorld.getState()) {
            string10 = string10 + this.GetPositionString() + "\n" + "Coordinate scales: (" + this.nf.format(d5) + ", " + this.nf.format(d6) + ", " + this.nf.format(d7);
        }
        if (this.DispMarkerInfo.getState()) {
            string10 = string10 + ")  , ListNr+Pos: (" + this.nf.format(this.lnr) + ", " + this.nf.format(this.lpos) + ")\n";
        }
        if (this.DispROIInfo.getState()) {
            string10 = string10 + "ROI Sizes [" + string + "]: (" + (d + "     ").substring(0, 6) + ", " + this.nf.format(d2) + ", " + this.nf.format(d3) + ")\n -> 3D-Diagonal[" + string + "]: " + this.nf.format(d4) + "\n" + "ROI Volume " + string9 + this.nf.format(this.data3d.GetROIVoxels(n)) + " voxels, " + this.nf.format(this.data3d.GetROIVoxels(n) * d5 * d6 * d7) + " [" + string + "*" + string2 + "*" + string3 + "]\n" + "Sum:" + this.nf.format(this.data3d.GetROISum(n)) + ", Average:" + this.nf.format(this.data3d.GetROIAvg(n)) + ", Max:" + this.nf.format(this.data3d.GetROIMax(n)) + ", Min:" + this.nf.format(this.data3d.GetROIMin(n)) + "\n";
        }
        if (this.DispCoordScales.getState()) {
            string10 = string10 + "Magnifications (x,y,z) = " + this.nf.format(this.c2.scale) + ", " + this.nf.format(this.c3.scale) + "," + this.nf.format(this.c1.scale) + "\n";
        }
        if (this.DispThreshColor.getState()) {
            string10 = string10 + "Thresholds : min=" + this.nf.format(this.data3d.GetScaledMincs(n)) + " max=" + this.nf.format(this.data3d.GetScaledMaxcs(n)) + "\n" + "Color: " + bl + ", " + "Projection Mode: " + bl2 + ", Data connected: " + bl3 + "\n";
        }
        if (this.DispMarkerInfo.getState()) {
            string10 = string10 + "Current Marker: " + this.nf.format(d10) + ", " + this.nf.format(d11) + ", " + this.nf.format(d12) + ", Integral: " + this.nf.format(d24) + ", Max= " + this.nf.format(d25) + "\n" + "Last Distance " + string6 + string7 + "=" + this.nf2.format(d17) + ", " + string6 + string7 + string8 + "=" + this.nf2.format(d19) + "\n" + "Slope " + string6 + "/" + string8 + "=" + this.nf2.format(d22) + " [" + string + "/" + string3 + "]" + ", TimeSlope=" + this.nf2.format(d23) + " [" + string + "/" + string5 + "]" + "  Sum Distances " + string6 + string7 + string8 + "=" + this.nf2.format(d20);
        }
        this.MyText.setText(string10);
        this.MyText.setCaretPosition(0);
        if (this.TimeScrollbar != null) {
            this.TimeScrollbar.setValue(this.pt);
        }
    }
}

