/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.StreamTokenizer;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

class MarkerLists {
    int NumPoints = 0;
    int ActivePoint = -1;
    int NumLists = 0;
    int ActiveList = -1;
    Vector ListOfLists = new Vector();
    public Vector MyPoints = null;
    static int dx = 3;
    static int dy = 3;

    public MarkerLists() {
        this.NewList();
    }

    int NumMarkers(int n) {
        if (n < 0) {
            n = this.ActiveList;
        }
        return ((Vector)this.ListOfLists.elementAt(n)).size();
    }

    int NumMarkerLists() {
        return this.NumLists;
    }

    int ActiveMarkerPos() {
        return this.ActivePoint;
    }

    int ActiveMarkerListPos() {
        return this.ActiveList;
    }

    void AddPoint(APoint aPoint) {
        if (this.NumPoints > 0) {
            aPoint.mycolor = this.GetPoint((int)0, (int)-1).mycolor;
        }
        if (this.ActivePoint < 0) {
            this.ActivePoint = 0;
            this.MyPoints.addElement(aPoint);
        } else {
            ++this.ActivePoint;
            this.MyPoints.insertElementAt(aPoint, this.ActivePoint);
        }
        ++this.NumPoints;
    }

    boolean RemovePoint() {
        if (this.NumPoints <= 0) {
            return false;
        }
        this.MyPoints.removeElementAt(this.ActivePoint);
        --this.NumPoints;
        if (this.ActivePoint >= this.NumPoints) {
            this.ActivePoint = this.NumPoints - 1;
            return false;
        }
        return this.NumPoints > 0;
    }

    void RemoveTrailingPoints() {
        while (this.RemovePoint()) {
        }
    }

    void AdvancePoint(int n) {
        if (this.NumPoints <= 0) {
            return;
        }
        this.ActivePoint += n;
        if (this.ActivePoint < 0) {
            this.ActivePoint += this.NumPoints;
        }
        if (this.ActivePoint >= this.NumPoints) {
            this.ActivePoint %= this.NumPoints;
        }
    }

    void SetActiveMarker(int n) {
        if (this.NumPoints <= 0) {
            return;
        }
        this.ActivePoint = n;
    }

    APoint GetPoint(int n, int n2) {
        Vector vector = n2 < 0 ? this.MyPoints : (Vector)this.ListOfLists.elementAt(n2);
        if (vector == null) {
            return null;
        }
        int n3 = vector.size();
        if (n3 <= 0) {
            return null;
        }
        if (n < 0) {
            n = this.ActivePoint;
        }
        if (n >= n3) {
            n %= n3;
        }
        if (n < 0) {
            n = 0;
        }
        return (APoint)vector.elementAt(n);
    }

    void ImportPositions(float[][] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.AddPoint(new APoint(fArray[i][0], fArray[i][1], fArray[i][2], fArray[i][3], fArray[i][4]));
        }
    }

    boolean readline(StreamTokenizer streamTokenizer, My3DData my3DData) throws IOException {
        int n;
        if (streamTokenizer.ttype == -1) {
            return false;
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        int n2 = (int)streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        int n3 = (int)streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        double d = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        double d2 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        double d3 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        double d4 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        double d5 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        double d6 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        for (n = 0; n < 7; ++n) {
            streamTokenizer.nextToken();
        }
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            return false;
        }
        n = (int)streamTokenizer.nval;
        double d7 = streamTokenizer.nval;
        if (n2 > this.NumLists) {
            return false;
        }
        if (n2 == this.NumLists) {
            this.NewList();
        }
        this.ActiveList = n2;
        this.MyPoints = (Vector)this.ListOfLists.elementAt(this.ActiveList);
        this.NumPoints = this.MyPoints.size();
        APoint aPoint = new APoint(d, d2, d3, d4, d5);
        if (this.NumPoints > 0) {
            aPoint.mycolor = this.GetPoint((int)0, (int)-1).mycolor;
        }
        aPoint.tagged = n != 0;
        aPoint.integral = d6;
        aPoint.max = d7;
        if (n3 > this.NumPoints) {
            return false;
        }
        if (n3 == this.NumPoints) {
            this.AddPoint(aPoint);
        } else {
            aPoint = this.GetPoint(n3, n2);
            aPoint.coord[0] = d;
            aPoint.coord[1] = d2;
            aPoint.coord[2] = d3;
            aPoint.coord[3] = d4;
            aPoint.coord[4] = d5;
            aPoint.integral = d6;
            aPoint.max = d7;
            aPoint.tagged = n != 0;
        }
        my3DData.ConstrainPoint(aPoint);
        my3DData.ClippedCOI(aPoint, my3DData.COMX, my3DData.COMY, my3DData.COMZ, false);
        return true;
    }

    double[][] ExportMarkers(int n) {
        if (n >= this.NumLists) {
            return new double[0][0];
        }
        int n2 = this.NumMarkers(n);
        double[][] dArray = new double[n2][6];
        for (int i = 0; i < n2; ++i) {
            APoint aPoint = this.GetPoint(i, n);
            dArray[i][0] = aPoint.coord[0];
            dArray[i][1] = aPoint.coord[1];
            dArray[i][2] = aPoint.coord[2];
            dArray[i][3] = aPoint.coord[3];
            dArray[i][4] = aPoint.coord[4];
            dArray[i][5] = aPoint.integral;
        }
        return dArray;
    }

    double[] MSD(int n, My3DData my3DData) {
        int n2 = my3DData.sizes[my3DData.TrackDirection];
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        this.MSDSum(n, my3DData, dArray, dArray2);
        this.MSDFinal(dArray, dArray2, n2);
        return dArray;
    }

    double[] AllMSD(My3DData my3DData) {
        int n = my3DData.sizes[my3DData.TrackDirection];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < this.NumLists; ++i) {
            this.MSDSum(i, my3DData, dArray, dArray2);
        }
        this.MSDFinal(dArray, dArray2, n);
        return dArray;
    }

    static final double ClipAt(double d, double d2, double d3) {
        return d > d3 ? d3 : (d < d2 ? d2 : d);
    }

    boolean MSDSum(int n, My3DData my3DData, double[] dArray, double[] dArray2) {
        int n2 = my3DData.sizes[my3DData.TrackDirection];
        int n3 = this.NumMarkers(n);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3 - i; ++j) {
                APoint aPoint = this.GetPoint(j, n);
                APoint aPoint2 = this.GetPoint(j + i, n);
                int n4 = (int)(aPoint2.coord[my3DData.TrackDirection] - aPoint.coord[my3DData.TrackDirection]);
                n4 = (int)MarkerLists.ClipAt(n4, 0.0, n2 - 1);
                if (my3DData.TrackDirection == 2) {
                    int n5 = n4;
                    dArray[n5] = dArray[n5] + aPoint.SqrXYDistTo(aPoint2, 1.0, 1.0);
                } else {
                    int n6 = n4;
                    dArray[n6] = dArray[n6] + aPoint.SqrDistTo(aPoint2, 1.0, 1.0, 1.0);
                }
                int n7 = n4;
                dArray2[n7] = dArray2[n7] + 1.0;
            }
        }
        return true;
    }

    boolean MSDFinal(double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] / dArray2[i];
        }
        return true;
    }

    void Penalize(APoint aPoint, double d, int n) {
        double d2 = d / 2.0 * (d / 2.0) / Math.log(2.0);
        for (int i = 0; i < this.NumLists; ++i) {
            if (i == this.ActiveList) continue;
            int n2 = this.NumMarkers(i);
            for (int j = 0; j < n2; ++j) {
                int n3;
                APoint aPoint2 = this.GetPoint(j, i);
                if (aPoint == aPoint2 || aPoint2.coord[n] != aPoint.coord[n]) continue;
                double d3 = 0.0;
                for (n3 = 0; n3 < 5; ++n3) {
                    if (n == n3) continue;
                    d3 += (aPoint2.coord[n3] - aPoint.coord[n3]) * (aPoint2.coord[n3] - aPoint.coord[n3]);
                }
                System.out.println("penalizing point " + aPoint.toString() + " by " + d3);
                if (d3 <= 0.0) {
                    return;
                }
                double d4 = d * Math.exp(-d3 / d2);
                System.out.println(" weight" + d4);
                for (n3 = 0; n3 < 5; ++n3) {
                    if (n == n3) continue;
                    int n4 = n3;
                    aPoint.coord[n4] = aPoint.coord[n4] - (aPoint2.coord[n3] - aPoint.coord[n3]) / Math.sqrt(d3) * d4;
                }
                System.out.println("penalized point" + aPoint.toString() + " by " + d3);
            }
        }
    }

    double Penalty(APoint aPoint, double d, int n, double d2) {
        double d3 = 0.0;
        double d4 = d / 2.0 * (d / 2.0) / Math.log(2.0);
        for (int i = 0; i < this.NumLists; ++i) {
            if (i == this.ActiveList) continue;
            int n2 = this.NumMarkers(i);
            for (int j = 0; j < n2; ++j) {
                double d5 = 0.0;
                APoint aPoint2 = this.GetPoint(j, i);
                if (aPoint != aPoint2 && aPoint2.coord[n] == aPoint.coord[n]) {
                    for (int k = 0; k < 5; ++k) {
                        if (n == k) continue;
                        d5 += (aPoint2.coord[k] - aPoint.coord[k]) * (aPoint2.coord[k] - aPoint.coord[k]);
                    }
                }
                d3 += d2 * aPoint2.integralAboveMin * Math.exp(-d5 / d4);
            }
        }
        return d3;
    }

    String PrintList(My3DData my3DData) {
        String string = "#List Nr.,\tMarker Nr,\tPosX [pixels],\tY [pixels],\tZ [pixels],\tElements [element],\tTime [time],\tIntegral (no BG sub) [Units],\tMax (no BG sub) [Units],\t" + my3DData.GetAxisNames()[0] + " [" + my3DData.GetAxisUnits()[0] + "],\t" + my3DData.GetAxisNames()[1] + " [" + my3DData.GetAxisUnits()[1] + "],\t" + my3DData.GetAxisNames()[2] + " [" + my3DData.GetAxisUnits()[2] + "],\t" + my3DData.GetAxisNames()[3] + " [" + my3DData.GetAxisUnits()[3] + "],\t" + my3DData.GetAxisNames()[4] + " [" + my3DData.GetAxisUnits()[4] + "],\tIntegral " + my3DData.GetValueName(my3DData.ActiveElement) + " (no BG sub)[" + my3DData.GetValueUnit(my3DData.ActiveElement) + "],\tMax " + my3DData.GetValueName(my3DData.ActiveElement) + " (no BG sub)[" + my3DData.GetValueUnit(my3DData.ActiveElement) + "], TagText, TagInteger\n";
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setGroupingUsed(false);
        for (int i = 0; i < this.NumLists; ++i) {
            string = string + "\n";
            for (int j = 0; j < this.NumMarkers(i); ++j) {
                APoint aPoint = this.GetPoint(j, i);
                int n = (int)aPoint.coord[3];
                string = string + i + "\t" + j + "\t" + numberFormat.format(aPoint.coord[0]) + "\t" + numberFormat.format(aPoint.coord[1]) + "\t" + numberFormat.format(aPoint.coord[2]) + "\t" + numberFormat.format(aPoint.coord[3]) + "\t" + numberFormat.format(aPoint.coord[4]) + "\t" + numberFormat.format(aPoint.integral) + "\t" + numberFormat.format(aPoint.max) + "\t" + numberFormat.format(aPoint.coord[0] * my3DData.GetScale(n, 0) + my3DData.GetOffset(n, 0)) + "\t" + numberFormat.format(aPoint.coord[1] * my3DData.GetScale(n, 1) + my3DData.GetOffset(n, 1)) + "\t" + numberFormat.format(aPoint.coord[2] * my3DData.GetScale(n, 2) + my3DData.GetOffset(n, 2)) + "\t" + numberFormat.format(aPoint.coord[3] * my3DData.GetScale(n, 3) + my3DData.GetOffset(n, 3)) + "\t" + numberFormat.format(aPoint.coord[4] * my3DData.GetScale(n, 4) + my3DData.GetOffset(n, 4)) + "\t" + numberFormat.format(aPoint.integral * my3DData.GetValueScale((int)(aPoint.coord[3] + 0.5)) + my3DData.GetValueOffset((int)(aPoint.coord[3] + 0.5))) + "\t" + numberFormat.format(aPoint.max * my3DData.GetValueScale((int)(aPoint.coord[3] + 0.5)) + my3DData.GetValueOffset((int)(aPoint.coord[3] + 0.5))) + '\t' + aPoint.tagged + "\t";
                string = aPoint.tagged ? string + "1\n" : string + "0\n";
            }
        }
        return string;
    }

    String PrintSummary(My3DData my3DData) {
        String string = "# Statistics Summary\n";
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setGroupingUsed(false);
        for (int i = 0; i < this.NumLists; ++i) {
            int n;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            APoint aPoint = this.GetPoint(0, i);
            for (n = 1; n < this.NumMarkers(i); ++n) {
                APoint aPoint2 = this.GetPoint(n, i);
                int n2 = (int)aPoint2.coord[3];
                double d4 = (aPoint2.coord[my3DData.TrackDirection] - aPoint.coord[my3DData.TrackDirection]) * my3DData.GetScale(n2, my3DData.TrackDirection);
                double d5 = Math.sqrt(aPoint2.SqrXYDistTo(aPoint, my3DData.GetScale(n2, 0), my3DData.GetScale(n2, 1)));
                double d6 = Math.sqrt(aPoint2.SqrDistTo(aPoint, my3DData.GetScale(n2, 0), my3DData.GetScale(n2, 1), my3DData.GetScale(n2, 2)));
                d += d5 / d4;
                d2 += d6 / d4;
                aPoint = aPoint2;
                d3 += 1.0;
            }
            string = string + "\n# Summary for List \t" + i + "\n";
            n = (int)this.GetPoint((int)0, (int)i).coord[3];
            double d7 = Math.sqrt(this.GetPoint(0, i).SqrXYDistTo(this.GetPoint(this.NumMarkers(i) - 1, i), my3DData.GetScale(n, 0), my3DData.GetScale(n, 1)));
            double d8 = Math.sqrt(this.GetPoint(0, i).SqrDistTo(this.GetPoint(this.NumMarkers(i) - 1, i), my3DData.GetScale(n, 0), my3DData.GetScale(n, 1), my3DData.GetScale(n, 2)));
            double d9 = (this.GetPoint((int)(this.NumMarkers((int)i) - 1), (int)i).coord[my3DData.TrackDirection] - this.GetPoint((int)n, (int)i).coord[my3DData.TrackDirection]) * my3DData.GetScale(n, my3DData.TrackDirection);
            String string2 = my3DData.GetAxisNames()[0] + my3DData.GetAxisNames()[1];
            String string3 = my3DData.GetAxisNames()[0] + my3DData.GetAxisNames()[1] + my3DData.GetAxisNames()[2];
            if (my3DData.TrackDirection == 2) {
                string = string + "\n# Total " + string2 + " Distance traveled: \t" + numberFormat.format(d7) + " [" + my3DData.GetAxisUnits()[0] + "]\n";
                string = string + "# Length of Trace: \t" + numberFormat.format(d9) + " [" + my3DData.GetAxisUnits()[my3DData.TrackDirection] + "]\n";
                string = string + "# Segments in Trace: \t" + numberFormat.format(d3) + "\n";
                string = string + "# Total " + string2 + " speed: \t" + numberFormat.format(d7 / d9) + " [" + my3DData.GetAxisUnits()[0] + "/" + my3DData.GetAxisUnits()[my3DData.TrackDirection] + "]\n";
                string = string + "# Average " + string2 + " speed: \t" + numberFormat.format(d / d3) + " [" + my3DData.GetAxisUnits()[0] + "/" + my3DData.GetAxisUnits()[my3DData.TrackDirection] + "]\n";
                string = string + "# Directionality Index: \t" + numberFormat.format(d7 / d9 / (d / d3)) + "\n";
                continue;
            }
            if (my3DData.TrackDirection != 4) continue;
            string = string + "\n# Total XYZ Distance traveled: \t" + numberFormat.format(d8) + " [" + my3DData.GetAxisUnits()[0] + "]\n";
            string = string + "# Length of Trace: \t" + numberFormat.format(d9) + " [" + my3DData.GetAxisUnits()[my3DData.TrackDirection] + "]\n";
            string = string + "# Segments in Trace: \t" + numberFormat.format(d3) + "\n";
            string = string + "# Total " + string2 + " speed: \t" + numberFormat.format(d7 / d9) + " [" + my3DData.GetAxisUnits()[0] + "/" + my3DData.GetAxisUnits()[my3DData.TrackDirection] + "]\n";
            string = string + "# Total " + string3 + " speed: \t" + numberFormat.format(d8 / d9) + " [" + my3DData.GetAxisUnits()[0] + "/" + my3DData.GetAxisUnits()[my3DData.TrackDirection] + "]\n";
            string = string + "# Average " + string2 + " speed: \t" + numberFormat.format(d / d3) + " [" + my3DData.GetAxisUnits()[0] + "/" + my3DData.GetAxisUnits()[my3DData.TrackDirection] + "]\n";
            string = string + "# Average " + string3 + " speed: \t" + numberFormat.format(d2 / d3) + " [" + my3DData.GetAxisUnits()[0] + "/" + my3DData.GetAxisUnits()[my3DData.TrackDirection] + "]\n";
            string = string + "# Directionality " + string2 + " Index: \t" + numberFormat.format(d7 / d9 / (d / d3)) + "\n";
            string = string + "# Directionality " + string3 + " Index: \t" + numberFormat.format(d8 / d9 / (d2 / d3)) + "\n";
        }
        return string;
    }

    void ToggleColor() {
        int n = APoint.NewColor();
        for (int i = 0; i < this.NumPoints; ++i) {
            this.GetPoint((int)i, (int)-1).mycolor = n;
        }
    }

    void NewList() {
        if (this.MyPoints != null && this.NumPoints == 0) {
            return;
        }
        this.MyPoints = new Vector();
        if (this.ActiveList < 0) {
            this.ActiveList = 0;
            this.ListOfLists.addElement(this.MyPoints);
        } else {
            ++this.ActiveList;
            this.ListOfLists.insertElementAt(this.MyPoints, this.ActiveList);
        }
        ++this.NumLists;
        this.NumPoints = 0;
        this.ActivePoint = -1;
    }

    void RemoveList() {
        if (this.NumLists < 1) {
            return;
        }
        this.ListOfLists.removeElementAt(this.ActiveList);
        this.MyPoints = null;
        --this.NumLists;
        if (this.NumLists <= 0) {
            this.ActiveList = -1;
            this.NewList();
            this.NumLists = 1;
        }
        if (this.ActiveList >= this.NumLists) {
            this.ActiveList = this.NumLists - 1;
        }
        this.MyPoints = (Vector)this.ListOfLists.elementAt(this.ActiveList);
        this.NumPoints = this.MyPoints.size();
        if (this.ActivePoint >= this.NumPoints) {
            this.ActivePoint %= this.NumPoints;
        }
    }

    void AdvanceList(int n) {
        if (this.NumLists <= 1) {
            return;
        }
        if (this.NumPoints <= 0 && this.NumLists > 1) {
            this.RemoveList();
            --n;
        }
        this.ActiveList += n;
        if (this.ActiveList < 0) {
            this.ActiveList += this.NumLists;
        }
        if (this.ActiveList >= this.NumLists) {
            this.ActiveList %= this.NumLists;
        }
        this.MyPoints = (Vector)this.ListOfLists.elementAt(this.ActiveList);
        this.NumPoints = this.MyPoints.size();
        if (this.ActivePoint >= this.NumPoints) {
            this.ActivePoint %= this.NumPoints;
        }
        if (this.ActivePoint < 0) {
            this.ActivePoint = 0;
        }
    }

    APoint MarkerFromPosition(double d, double d2, int n, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        for (int i = 0; i < this.NumLists; ++i) {
            if (!bl && i != this.ActiveList) continue;
            for (int j = 0; j < this.NumMarkers(i); ++j) {
                APoint aPoint = this.GetPoint(j, i);
                if (!aPoint.InRange(d, d2, n, d3, d4) || !bl2 && aPoint != this.GetPoint(-1, -1) || !bl3 && aPoint != this.GetPoint(-1, -1)) continue;
                return aPoint;
            }
        }
        return null;
    }
}

