%STRUCTURETENSOR   Computes Structure Tensor on 2D images
%
% SYNOPSIS:
%  [orientation,energy,anisotropy,l1,l2] =
%       structuretensor(image_in,dsigma,tsigma,outputs)
%
% PARAMETERS:
%  outputs: which outputs to produce. Cell array containing one or more
%           of these values:
%           'orientation','energy','anisotropy','l1','l2'.
%
% DEFAULTS:
%  dsigma = 1
%  tsigma = 5

% (C) Copyright 1999-2001               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Michael van Ginkel, October 2000.
% 2 May 2001, Cris Luengo: Improved output argument handling
% 2/5 Sep 2005, MvG, an ugly hack to get some flexibility in the parameter
%    handling needed for the new "curvature" feature. If requested,
%    an extra sigma parameter is needed. I've tackled this by testing
%    for the number of arguments supplied and passing the appropriate
%    "menu" structure to getparams...

function varargout = structuretensor(varargin)

outputs={'orientation','energy','anisotropy','l1','l2'};
d=struct('name',       {'image_in','dsigma','tsigma'},...
         'description',{'Input image','Gradient sigma','Tensor sigma'},...
         'type',       {'image','array','array'},...
         'dim_check',  {0,1,1},...
         'range_check',{[],[],[]},...
         'required',   {1,0,0},...
         'default',    {'a',1,5}...
          );
o=struct('name',       outputs,...
         'description',{'Orientation','Energy','Anisotropy',...
                        'Largest eigenvalue','Smallest eigenvalue'},...
         'type',       {'image','image','image','image','image'}...
        );
s=struct('menu','Analysis',...
         'display','Structure tensor 2D',...
         'inparams',d,...
         'outparams',o,...
         'output_select',1 ...
         );

outputs_alt={'orientation','energy','anisotropy','l1','l2','curvature'};
d_alt=struct('name',       {'image_in','dsigma','tsigma','csigma'},...
             'description',{'Input image','Gradient sigma','Tensor sigma','Curvature Sigma'},...
             'type',       {'image','array','array','array'},...
             'dim_check',  {0,1,1,1},...
             'range_check',{[],[],[],[]},...
             'required',   {1,0,0,0},...
             'default',    {'a',1,5,1}...
              );
o_alt=struct('name',       outputs_alt,...
             'description',{'Orientation','Energy','Anisotropy',...
                            'Largest eigenvalue','Smallest eigenvalue','Curvature'},...
             'type',       {'image','image','image','image','image','image'}...
            );
s_alt=struct('menu','Analysis',...
         'display','Structure tensor 2D',...
         'inparams',d_alt,...
         'outparams',o_alt,...
         'output_select',1 ...
         );


if nargin == 1
   if ischar(varargin{1}) & strcmp(varargin{1},'DIP_GetParamList')
      varargout{1} = s;
      return
   end
end

csigma=1;
if nargin==5
   try
      [image_in,dsigma,tsigma,csigma,outputs] = getparams(s_alt,varargin{:});
   catch
      if ~isempty(paramerror)
         error(paramerror)
      else
         error(firsterr)
      end
   end
else
   try
      [image_in,dsigma,tsigma,outputs] = getparams(s,varargin{:});
   catch
      if ~isempty(paramerror)
         error(paramerror)
      else
         error(firsterr)
      end
   end
end
N = nargout; if N<1, N=1; end
varargout = cell(N,1);
if length(outputs) > N
   warning(['Too few output arguments: Only generating the first ',num2str(N),' images.'])
   outputs = outputs(1:N);
end
[varargout{:}] = dip_structuretensor2d(image_in,'firgauss',dsigma,...
                                       'iirgauss',tsigma,'firgauss',csigma,...
                                       outputs);
