%FILLHOLES   Fill holes in a binary image
%
% SYNOPSIS:
%  out = fillholes(image)
%

% (C) Copyright 1999-2009               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger, March 2004
% 11 March 2009: Not using the default values when calling BPROPAGATION. (CL)

function out = fillholes(varargin)
d = struct('menu','Binary Filters',...
  'display','Fill Holes',...
  'inparams',struct('name',       {'in'},...
                    'description',{'Input image'},...
                    'type',       {'image'},...
                    'dim_check',  {0},...
                    'range_check',{[]},...
                    'required',   {1,},...
                    'default',    {'a'}...
                   ),...
  'outparams',struct('name',{'out'},...
                     'description',{'Output image'},...
                     'type',{'image'}...
                     )...
 );
if nargin == 1
   s = varargin{1};
   if ischar(s) & strcmp(s,'DIP_GetParamList')
      out = d;
      return
   end
end
try
   [in] = getparams(d,varargin{:});
catch
   if ~isempty(paramerror)
      error(paramerror)
   else
      error(firsterr)
   end
end
if ~strcmp(datatype(in),'bin')
   error('Input must be binary.');
end
out = ~bpropagation(newim(in,'bin'),~in,0,1,1);
