%DIPROI   Interactive ROI selection
%   Returns the mask image it allows the user to create over an existing
%   image display. It is formed by a single polygon or spline, created by
%   clicking on the image.
%
% SYNOPSIS:
%   [roi, v] = diproi(figure_handle, interpolation)
%   [roi, v] = diproi(interpolation)
%
% PARAMETERS:
%   figure_handle: 
%   interpolation: 'polygon','spline'
%
% RETURNS
%   v: vertices of polygon or spline
%
% DEFAULTS:
%   figure_handle: current window (GCF).
%   interpolation: 'polygon'
%
%   DIPROI is only available for 2D figure windows.
%
%   To create the polygon, use the left mouse button to add vertices.
%   A double-click adds a last vertex and closes the shape. 'Enter'
%   closes the shape without adding a vertex. To remove vertices, use
%   the 'Backspace' or 'Delete' keys, or the right mouse button. 'Esc'
%   aborts the operation. Shift-click will add a vertex constrained to
%   a horizontal or vertical location with respect to the previous vertex.
%
%   Note that you need to select at least three vertices. If you
%   don't, an error will be generated.
%
%   It is still possible to use all the menus in the victim figure
%   window, but you won't be able to access any of the tools (like
%   zooming and testing). The regular key-binding is also disabled.
%
%   Note: If you feel the need to interrupt this function with Ctrl-C,
%   you will need to refresh the display (by re-displaying the image
%   or changing the 'Actions' state).
%
%   See also DIPSHOW, DIPGETCOORDS, DIPCROP, DIPPROFILE.

% (C) Copyright 1999-2004               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, August 2001
% Adapted from DIPGETCOORDS
% 18 September 2001: Fixed bug for MATLAB 6: 'CurrentCharacter' is []
%                    after pressing shift key.
% 29 April 2002: Added right-click = delete feature.
% 3 April 2004: Added spline inter polation and changed vertices to 
%               second output(BR)

