%LOG10   Common (base 10) logarithm.
%  LOG10(B) is the base 10 logarithm of the pixels of B.
%  Complex results are produced if B is not positive.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, May 2000.
% February 2008: Adding pixel dimensions and units to dip_image. (BR)

function out = log10(in)
try
   [in,dims,dip_type,out_phys] = do1input(in);
   if isreal(in) & any(in(:)<0)
      if strcmp(dip_type,'sfloat')
         dip_type = 'scomplex';
      else
         dip_type = 'dcomplex';
      end
   end
   out = compute1('log10',in,dims,dip_type,out_phys);
catch
   error(di_firsterr)
end
