%ISINTEGER   True for integer-typed image.
%   ISINTEGER(B) returns true if B is uint8, uint16, uint32, sint8, sint16 or sint32.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, March 2006.

function out = isinteger(in)
if ~isscalar(in)
   error('Parameter "in" is an array of images.')
else
   out = length(in.dip_type)>=4 & strcmp(in.dip_type(2:4),'int');
end
