%EYE   Identity tensor
%   EYE(A) creates a identity tensor with the specification of A.
%   Same dimensionality and sizes of images. The diagonal images
%   contain only 1's and the off-diagonal only 0's.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger, November 2000.
% Nov 2002, change creation of null and eins image to be faster.
% 26 July 2007: Output is sfloat; reduced loop (CL).

function out = eye(a)

if ~istensor(a)
   error('Image is not a tensor image');
end
s = imarsize(a);
if length(s)>2
   error('only implemented for 2D tensors.');
end

out = dip_image('array',size(a));
null = dip_image('zeros',size(a(1)),'single');
eins = null;
eins.data(:) = 1;

out(:) = null;
for ii=1:min(s)
   out(ii,ii) = eins;
end
