%ACOS   Inverse cosine.
%  ACOS(B) is the arccosine of the pixels of B.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger, Nov 2000.
% Oct 2005, added different outtype if arccos returns complex values (BR)
% July 2006, bug fix (BR,FF)
% 10 March 2008: Fixed bug. COMPUTE1 has a new PHYSDIMS input parameter.

function out = acos(in)
try
   [in,dims,out_type,out_phys]=do1input(in);
   if any(in(:)>1) | any(in(:)<-1)
      out_type = 'dcomplex';
   end
   out = compute1('acos',in,dims,out_type,out_phys);
catch
   error(di_firsterr)
end
