/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.measure.CurveFitter;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.PlugInFrame;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.StringTokenizer;

public class Recorder
extends PlugInFrame
implements PlugIn,
ActionListener,
ItemListener {
    public static boolean record;
    private Button makeMacro;
    private Button makePlugin;
    private Checkbox recordCB;
    private String fitTypeStr = CurveFitter.fitList[0];
    private static TextArea textArea;
    private static Frame instance;
    private static String commandName;
    private static String commandOptions;
    static /* synthetic */ Class class$ij$plugin$frame$Recorder;

    public Recorder() {
        super("Recorder");
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        Panel panel = new Panel();
        record = true;
        this.recordCB = new Checkbox("Record", record);
        this.recordCB.addItemListener(this);
        panel.add(this.recordCB);
        this.makeMacro = new Button("Create Macro");
        this.makeMacro.addActionListener(this);
        panel.add(this.makeMacro);
        this.makePlugin = new Button("Create Plugin");
        this.makePlugin.addActionListener(this);
        panel.add(this.makePlugin);
        this.add("North", panel);
        textArea = new TextArea("", 15, 60, 1);
        textArea.setFont(new Font("Monospaced", 0, 12));
        this.add("Center", textArea);
        this.pack();
        GUI.center(this);
        this.show();
        IJ.register(class$ij$plugin$frame$Recorder == null ? (class$ij$plugin$frame$Recorder = Recorder.class$("ij.plugin.frame.Recorder")) : class$ij$plugin$frame$Recorder);
    }

    public static void record(String string) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "();\n");
    }

    public static void setCommand(String string) {
        if (textArea == null) {
            return;
        }
        commandName = string;
        commandOptions = null;
    }

    static String fixPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuffer.append(c);
            if (c == '\\') {
                stringBuffer.append("\\");
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public static void record(String string, String string2) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(\"" + string2 + "\");\n");
    }

    public static void record(String string, int n) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(" + n + ");\n");
    }

    public static void record(String string, int n, int n2) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(" + n + ", " + n2 + ");\n");
    }

    public static void record(String string, double d, double d2) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(" + d + ", " + d2 + ");\n");
    }

    public static void record(String string, int n, int n2, int n3) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(" + n + ", " + n2 + ", " + n3 + ");\n");
    }

    public static void record(String string, String string2, int n, int n2) {
        if (textArea == null) {
            return;
        }
        string = "//" + string;
        textArea.append(string + "(\"" + string2 + "\", " + n + ", " + n2 + ");\n");
    }

    public static void record(String string, int n, int n2, int n3, int n4) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ");\n");
    }

    public static void record(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5) {
        if (textArea == null) {
            return;
        }
        string2 = Recorder.fixPath(string2);
        string = "//" + string;
        textArea.append(string + "(\"" + string2 + "\", " + "\"" + string3 + "\", " + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ");\n");
    }

    public static void recordOption(String string, String string2) {
        string = Recorder.trimKey(string);
        string2 = Recorder.addQuotes(string2);
        commandOptions = commandOptions == null ? string + "=" + string2 : commandOptions + " " + string + "=" + string2;
    }

    public static void recordPath(String string, String string2) {
        if (string == null) {
            return;
        }
        string = Recorder.trimKey(string);
        string2 = Recorder.fixPath(string2);
        string2 = Recorder.addQuotes(string2);
        commandOptions = commandOptions == null ? string + "=" + string2 : commandOptions + " " + string + "=" + string2;
    }

    public static void recordOption(String string) {
        string = Recorder.trimKey(string);
        commandOptions = commandOptions == null ? string : commandOptions + " " + string;
    }

    static String trimKey(String string) {
        int n = string.indexOf(" ");
        if (n > -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(":")) > -1) {
            string = string.substring(0, n);
        }
        string = string.toLowerCase(Locale.US);
        return string;
    }

    public static void saveCommand() {
        if (commandName != null) {
            if (commandOptions != null) {
                textArea.append("run(\"" + commandName + "\", \"" + commandOptions + "\");\n");
            } else {
                textArea.append("run(\"" + commandName + "\");\n");
            }
        }
        commandName = null;
        commandOptions = null;
    }

    static String addQuotes(String string) {
        int n = string.indexOf(32);
        if (n > -1) {
            string = "'" + string + "'";
        }
        return string;
    }

    void createPlugin() {
        String string = textArea.getText();
        if (string == null || string.equals("")) {
            IJ.runPlugIn("ij.plugin.NewPlugin", " ");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = stringTokenizer.countTokens();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringTokenizer.nextToken();
            if (string2 != null && string2.length() > 3) {
                stringBuffer.append("\t\tIJ.");
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            ++n2;
        }
        IJ.runPlugIn("ij.plugin.NewPlugin", new String(stringBuffer));
    }

    void createMacro() {
        String string = textArea.getText();
        if (string == null || string.equals("")) {
            return;
        }
        Editor editor = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (editor == null) {
            return;
        }
        editor.create("macro.txt", string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        record = this.recordCB.getState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.makeMacro) {
            this.createMacro();
        } else if (actionEvent.getSource() == this.makePlugin) {
            this.createPlugin();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void close() {
        super.close();
        record = false;
        textArea = null;
        commandName = null;
        instance = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

