/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Prefs;
import ij.gui.ProgressBar;
import ij.io.FileInfo;
import ij.io.ImageReader;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class FileOpener {
    private FileInfo fi;
    private int width;
    private int height;

    public FileOpener(FileInfo fileInfo) {
        this.fi = fileInfo;
        if (fileInfo != null) {
            this.width = fileInfo.width;
            this.height = fileInfo.height;
        }
        if (IJ.debugMode) {
            IJ.log("FileOpener: " + fileInfo);
        }
    }

    public void open() {
        this.open(true);
    }

    public ImagePlus open(boolean bl) {
        ImagePlus imagePlus = null;
        Object var4_3 = null;
        ColorModel colorModel = this.createColorModel(this.fi);
        if (this.fi.nImages > 1) {
            return this.openStack(colorModel, bl);
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, (byte[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, byteProcessor);
                break;
            }
            case 1: 
            case 2: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                ShortProcessor shortProcessor = new ShortProcessor(this.width, this.height, (short[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, shortProcessor);
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                FloatProcessor floatProcessor = new FloatProcessor(this.width, this.height, (float[])object, colorModel);
                imagePlus = new ImagePlus(this.fi.fileName, floatProcessor);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Object object = this.readPixels(this.fi);
                if (object == null) {
                    return null;
                }
                ColorProcessor colorProcessor = new ColorProcessor(this.width, this.height, (int[])object);
                imagePlus = new ImagePlus(this.fi.fileName, colorProcessor);
            }
        }
        imagePlus.setFileInfo(this.fi);
        this.setCalibration(imagePlus);
        if (bl) {
            imagePlus.show();
        }
        IJ.showProgress(1.0);
        return imagePlus;
    }

    ImagePlus openStack(ColorModel colorModel, boolean bl) {
        Object object;
        Object object2;
        ImageStack imageStack = new ImageStack(this.fi.width, this.fi.height, colorModel);
        long l = this.fi.longOffset > 0L ? this.fi.longOffset : (long)this.fi.offset;
        try {
            object2 = new ImageReader(this.fi);
            object = this.createInputStream(this.fi);
            if (object == null) {
                return null;
            }
            int n = 1;
            while (n <= this.fi.nImages) {
                IJ.showStatus("Reading: " + n + "/" + this.fi.nImages);
                Object object3 = ((ImageReader)object2).readPixels((InputStream)object, l);
                if (object3 == null) break;
                imageStack.addSlice(null, object3);
                l = this.fi.gapBetweenImages;
                IJ.showProgress((double)n / (double)this.fi.nImages);
                ++n;
            }
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            IJ.write("" + exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory(this.fi.fileName);
            imageStack.trim();
        }
        IJ.showProgress(1.0);
        if (imageStack.getSize() == 0) {
            return null;
        }
        object2 = new ImagePlus(this.fi.fileName, imageStack);
        if (bl) {
            ((ImagePlus)object2).show();
        }
        ((ImagePlus)object2).setFileInfo(this.fi);
        this.setCalibration((ImagePlus)object2);
        object = ((ImagePlus)object2).getProcessor();
        if (((ImageProcessor)object).getMin() == ((ImageProcessor)object).getMax()) {
            this.setStackDisplayRange((ImagePlus)object2);
        }
        IJ.showProgress(1.0);
        return object2;
    }

    void setStackDisplayRange(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n = imageStack.getSize();
        int n2 = 1;
        while (n2 <= n) {
            IJ.showStatus("Calculating stack min and max: " + n2 + "/" + n);
            ImageProcessor imageProcessor = imageStack.getProcessor(n2);
            imageProcessor.resetMinAndMax();
            if (imageProcessor.getMin() < d) {
                d = imageProcessor.getMin();
            }
            if (imageProcessor.getMax() > d2) {
                d2 = imageProcessor.getMax();
            }
            ++n2;
        }
        imagePlus.getProcessor().setMinAndMax(d, d2);
        imagePlus.updateAndDraw();
    }

    public void revertToSaved(ImagePlus imagePlus) {
        ProgressBar progressBar = IJ.getInstance().getProgressBar();
        if (this.fi.fileFormat == 3) {
            Image image = Toolkit.getDefaultToolkit().getImage(this.fi.directory + this.fi.fileName);
            imagePlus.setImage(image);
            if (imagePlus.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imagePlus);
            }
            return;
        }
        if (this.fi.fileFormat == 6) {
            ImagePlus imagePlus2 = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", this.fi.directory + this.fi.fileName);
            if (imagePlus2 != null) {
                imagePlus.setProcessor(null, imagePlus2.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 5) {
            ImagePlus imagePlus3 = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP_Reader", this.fi.directory + this.fi.fileName);
            if (imagePlus3 != null) {
                imagePlus.setProcessor(null, imagePlus3.getProcessor());
            }
            return;
        }
        if (this.fi.nImages > 1) {
            return;
        }
        if (this.fi.url == null || this.fi.url.equals("")) {
            IJ.showStatus("Loading: " + this.fi.directory + this.fi.fileName);
        } else {
            IJ.showStatus("Loading: " + this.fi.url + this.fi.fileName);
        }
        Object object = this.readPixels(this.fi);
        if (object == null) {
            return;
        }
        ColorModel colorModel = this.createColorModel(this.fi);
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, (byte[])object, colorModel);
                imagePlus.setProcessor(null, byteProcessor);
                break;
            }
            case 1: 
            case 2: {
                ShortProcessor shortProcessor = new ShortProcessor(this.width, this.height, (short[])object, colorModel);
                imagePlus.setProcessor(null, shortProcessor);
                break;
            }
            case 3: 
            case 4: {
                FloatProcessor floatProcessor = new FloatProcessor(this.width, this.height, (float[])object, colorModel);
                imagePlus.setProcessor(null, floatProcessor);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])object, 0, this.width));
                imagePlus.setImage(image);
            }
        }
    }

    void setCalibration(ImagePlus imagePlus) {
        int n;
        Object object;
        Calibration calibration = imagePlus.getCalibration();
        if (this.fi.fileType == 1) {
            if (IJ.debugMode) {
                IJ.log("16-bit signed");
            }
            object = new double[2];
            object[0] = -32768.0;
            object[1] = 1.0;
            calibration.setFunction(0, (double[])object, "gray value");
        }
        object = this.decodeDescriptionString();
        if (this.fi.pixelWidth > 0.0 && this.fi.unit != null) {
            calibration.pixelWidth = this.fi.pixelWidth;
            calibration.pixelHeight = this.fi.pixelHeight;
            calibration.pixelDepth = this.fi.pixelDepth;
            calibration.setUnit(this.fi.unit);
        }
        if (this.fi.valueUnit != null && ((n = this.fi.calibrationFunction) >= 0 && n <= 8 && this.fi.coefficients != null || n == 21)) {
            calibration.setFunction(n, this.fi.coefficients, this.fi.valueUnit);
        }
        if (this.fi.frameInterval != 0.0) {
            calibration.frameInterval = this.fi.frameInterval;
        }
        if (object == null) {
            return;
        }
        calibration.xOrigin = this.getDouble((Properties)object, "xorigin");
        calibration.yOrigin = this.getDouble((Properties)object, "yorigin");
        calibration.zOrigin = this.getDouble((Properties)object, "zorigin");
        calibration.info = ((Properties)object).getProperty("info");
        double d = this.getDouble((Properties)object, "min");
        double d2 = this.getDouble((Properties)object, "max");
        if (d != 0.0 || d2 != 0.0) {
            int n2 = imagePlus.getType();
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (n2 == 0 || n2 == 3) {
                imageProcessor.setMinAndMax(d, d2);
            } else if (!(n2 != 1 && n2 != 2 || imageProcessor.getMin() == d && imageProcessor.getMax() == d2)) {
                imageProcessor.setMinAndMax(d, d2);
            }
        }
    }

    public ColorModel createColorModel(FileInfo fileInfo) {
        if (fileInfo.fileType == 5 && fileInfo.lutSize > 0) {
            return new IndexColorModel(8, fileInfo.lutSize, fileInfo.reds, fileInfo.greens, fileInfo.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fileInfo.whiteIsZero);
    }

    public InputStream createInputStream(FileInfo fileInfo) throws IOException, MalformedURLException {
        File file;
        if (fileInfo.inputStream != null) {
            return fileInfo.inputStream;
        }
        if (fileInfo.url != null && !fileInfo.url.equals("")) {
            return new URL(fileInfo.url + fileInfo.fileName).openStream();
        }
        if (fileInfo.directory.length() > 0 && !fileInfo.directory.endsWith(Prefs.separator)) {
            fileInfo.directory = fileInfo.directory + Prefs.separator;
        }
        if ((file = new File(fileInfo.directory + fileInfo.fileName)) == null || file.isDirectory() || !FileOpener.validateFileInfo(file, fileInfo)) {
            return null;
        }
        return new FileInputStream(file);
    }

    static boolean validateFileInfo(File file, FileInfo fileInfo) {
        long l = fileInfo.longOffset > 0L ? fileInfo.longOffset : (long)fileInfo.offset;
        long l2 = 0L;
        if (fileInfo.width <= 0 || fileInfo.height < 0) {
            FileOpener.error("Width or height <= 0.", fileInfo, l, l2);
            return false;
        }
        if (l >= 0L && l < 1000L) {
            return true;
        }
        if (l < 0L) {
            FileOpener.error("Offset is negative.", fileInfo, l, l2);
            return false;
        }
        l2 = file.length();
        long l3 = fileInfo.width * fileInfo.height * fileInfo.getBytesPerPixel();
        long l4 = l3 = fileInfo.nImages > 1 ? l3 : l3 / 4L;
        if (fileInfo.height == 1) {
            l3 = 0L;
        }
        if (l + l3 > l2) {
            FileOpener.error("Offset + image size > file length.", fileInfo, l, l2);
            return false;
        }
        return true;
    }

    static void error(String string, FileInfo fileInfo, long l, long l2) {
        IJ.showMessage("FileOpener", "FileInfo parameter error. \n" + string + "\n \n" + "  Width: " + fileInfo.width + "\n" + "  Height: " + fileInfo.height + "\n" + "  Offset: " + l + "\n" + "  Bytes/pixel: " + fileInfo.getBytesPerPixel() + "\n" + (l2 > 0L ? "  File length: " + l2 + "\n" : ""));
    }

    Object readPixels(FileInfo fileInfo) {
        Object object = null;
        try {
            InputStream inputStream = this.createInputStream(fileInfo);
            if (inputStream == null) {
                return null;
            }
            ImageReader imageReader = new ImageReader(fileInfo);
            object = imageReader.readPixels(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            IJ.log("FileOpener.readPixels(): " + exception);
        }
        return object;
    }

    public Properties decodeDescriptionString() {
        if (this.fi.description == null || this.fi.description.length() < 7) {
            return null;
        }
        if (IJ.debugMode) {
            IJ.log("Image Description: " + new String(this.fi.description).replace('\n', ' '));
        }
        if (!this.fi.description.startsWith("ImageJ")) {
            return null;
        }
        Properties properties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.fi.description.getBytes());
        try {
            properties.load(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).close();
        }
        catch (IOException iOException) {
            return null;
        }
        this.fi.unit = properties.getProperty("unit", "");
        Double d = this.getNumber(properties, "cf");
        if (d != null) {
            this.fi.calibrationFunction = d.intValue();
        }
        double[] dArray = new double[5];
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            d = this.getNumber(properties, "c" + n2);
            if (d == null) break;
            dArray[n2] = d;
            ++n;
            ++n2;
        }
        if (n >= 2) {
            this.fi.coefficients = new double[n];
            int n3 = 0;
            while (n3 < n) {
                this.fi.coefficients[n3] = dArray[n3];
                ++n3;
            }
        }
        this.fi.valueUnit = properties.getProperty("vunit");
        d = this.getNumber(properties, "images");
        if (d != null && d > 1.0) {
            this.fi.nImages = (int)d.doubleValue();
        }
        if (this.fi.nImages > 1) {
            double d2 = this.getDouble(properties, "spacing");
            if (d2 != 0.0) {
                this.fi.pixelDepth = d2;
            }
            d = this.getNumber(properties, "fps");
            double d3 = this.getDouble(properties, "fps");
            if (d3 != 0.0) {
                this.fi.frameInterval = 1.0 / d3;
            }
        }
        return properties;
    }

    private Double getNumber(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                return Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private double getDouble(Properties properties, String string) {
        Double d = this.getNumber(properties, string);
        return d != null ? d : 0.0;
    }
}

