/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Polygon;
import java.awt.image.IndexColorModel;
import java.util.Random;
import java.util.Vector;

class Bundle
implements Cloneable {
    private double mincs = 0.0;
    private double maxcs = 1.0;
    private double[] ProjMincs = new double[]{0.0, 0.0};
    private double[] ProjMaxcs = new double[]{1.0, 1.0};
    public int ElementModelNr = 0;
    static final int ElementModels = 13;
    static final String[] ElementModelName = new String[]{"GrayScale", "Red", "Green", "Blue", "Purple", "Glow Red", "Glow Green-Blue", "Glow Green-Yellow", "Glow Blue", "Glow Purple", "Rainbow", "Random", "Cyclic"};
    byte[] cmapRed;
    byte[] cmapGreen;
    byte[] cmapBlue;
    static Vector MapSizes = new Vector();
    static Vector RedMaps = new Vector();
    static Vector GreenMaps = new Vector();
    static Vector BlueMaps = new Vector();
    boolean cmapIsInverse = false;
    IndexColorModel ElementModel;
    boolean ShowOvUn = false;
    boolean LogScale = false;
    static final int MaxCTableBits = 15;
    static final int MaxCTable = 32768;
    int cmapcLow = 0;
    int cmapcHigh = 32768;
    boolean DispOverlay = false;
    boolean MulDisplay = false;
    boolean MIPMode = true;
    boolean[] ProjValid;
    ROI ActiveROI;
    RectROI rectROI;
    PolyROI polyROI;

    Bundle(int n, double d, double d2) {
        this.ElementModelNr = n;
        this.mincs = d;
        this.maxcs = d2;
        this.ProjMincs[0] = d;
        this.ProjMaxcs[0] = d2;
        this.ProjMincs[1] = d;
        this.ProjMaxcs[1] = d2;
        this.ProjValid = new boolean[3];
        this.rectROI = new RectROI();
        this.polyROI = new PolyROI();
        this.ActiveROI = this.rectROI;
        this.Invalidate();
        try {
            this.GenCMap();
        }
        catch (Exception exception) {
            System.out.println("Exception creating Bundle\n");
            exception.printStackTrace();
        }
    }

    void Invalidate() {
        this.ProjValid[0] = false;
        this.ProjValid[1] = false;
        this.ProjValid[2] = false;
    }

    double GetMincs() {
        return this.mincs;
    }

    double GetMaxcs() {
        return this.maxcs;
    }

    void SetMincs(double d) {
        this.mincs = d;
    }

    void SetMaxcs(double d) {
        this.maxcs = d;
    }

    void ToggleROI() {
        this.ActiveROI = this.ActiveROI == this.rectROI ? this.polyROI : this.rectROI;
    }

    boolean InOverlayDispl() {
        return this.DispOverlay;
    }

    boolean MulOverlayDispl() {
        return this.MulDisplay;
    }

    void ToggleOverlayDispl(int n) {
        if (n < 0) {
            this.DispOverlay = !this.DispOverlay;
        } else if (n == 0) {
            this.DispOverlay = false;
        } else if (n == 1) {
            this.DispOverlay = true;
        }
    }

    void ToggleMulDispl(int n) {
        if (n < 0) {
            this.MulDisplay = !this.MulDisplay;
        } else if (n == 0) {
            this.MulDisplay = false;
        } else if (n == 1) {
            this.MulDisplay = true;
            this.DispOverlay = false;
        }
    }

    public boolean SquareROIs() {
        return this.ActiveROI == this.rectROI;
    }

    public void TakeSqrROIs(int[] nArray, int[] nArray2) {
        this.rectROI.TakeSqrROIs(nArray, nArray2);
    }

    public void UpdateSqrROI(int n, int n2, int n3, int n4, int n5) {
        this.rectROI.UpdateSqrROI(n, n2, n3, n4, n5);
    }

    public void TakePolyROIs(Polygon[] polygonArray) {
        this.polyROI.TakePolyROIs(polygonArray);
    }

    public void TakePlaneROIs(Vector[] vectorArray, Vector[] vectorArray2) {
    }

    public Object clone() {
        Bundle bundle = new Bundle(this.ElementModelNr, this.mincs, this.maxcs);
        bundle.MIPMode = this.MIPMode;
        bundle.ShowOvUn = this.ShowOvUn;
        bundle.LogScale = this.LogScale;
        bundle.DispOverlay = this.DispOverlay;
        bundle.TakeSqrROIs(this.rectROI.ProjMin, this.rectROI.ProjMax);
        return bundle;
    }

    public static double CClip(double d) {
        return d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
    }

    public static double MClip(double d) {
        return d <= 0.0 ? 0.0 : (d > 1.0 ? (d >= 2.0 ? 0.0 : 2.0 - d) : d);
    }

    public Color GetCMapColor(int n, int n2) {
        int n3 = n * (this.cmapcHigh - this.cmapcLow) / n2 + this.cmapcLow;
        if (n3 >= 32768) {
            n3 = Short.MAX_VALUE;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = this.cmapRed[n3] & 0xFF;
        int n5 = this.cmapGreen[n3] & 0xFF;
        int n6 = this.cmapBlue[n3] & 0xFF;
        return new Color(n4, n5, n6);
    }

    public static Color ColFromHue(float f) {
        return new Color((float)Bundle.MClip((double)f * 1.5 + 1.0), (float)Bundle.MClip((double)f * 1.5 + 0.25), (float)Bundle.MClip((double)f * 1.5 - 0.5));
    }

    public void CompCMap() {
        double d = 32768.0;
        double d2 = Math.log(d + 1.0);
        Random random = new Random(0L);
        for (int i = 0; i < 32768; ++i) {
            double d3 = ((double)i - (double)this.cmapcLow) / (double)(this.cmapcHigh - this.cmapcLow);
            if (d3 <= 0.0 || i == 0) {
                d3 = 0.0;
                if (this.ShowOvUn) {
                    this.cmapGreen[i] = 100;
                    this.cmapRed[i] = 0;
                    this.cmapBlue[i] = 0;
                    continue;
                }
            }
            if (d3 >= 1.0 || i == Short.MAX_VALUE) {
                d3 = 1.0;
                if (this.ShowOvUn) {
                    this.cmapGreen[i] = 0;
                    this.cmapRed[i] = 0;
                    this.cmapBlue[i] = -1;
                    continue;
                }
            }
            if (this.LogScale) {
                d3 = Math.log(d * d3 + 1.0) / d2;
            }
            switch (this.ElementModelNr) {
                case 0: {
                    this.cmapRed[i] = (byte)(d3 * 255.0);
                    this.cmapGreen[i] = (byte)(d3 * 255.0);
                    this.cmapBlue[i] = (byte)(d3 * 255.0);
                    break;
                }
                case 1: {
                    this.cmapRed[i] = (byte)(d3 * 255.0);
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = 0;
                    break;
                }
                case 2: {
                    this.cmapRed[i] = 0;
                    this.cmapGreen[i] = (byte)(d3 * 255.0);
                    this.cmapBlue[i] = 0;
                    break;
                }
                case 3: {
                    this.cmapRed[i] = 0;
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = (byte)(d3 * 255.0);
                    break;
                }
                case 4: {
                    this.cmapRed[i] = (byte)(d3 * 255.0);
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = (byte)(d3 * 255.0);
                    break;
                }
                case 5: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0 - 1.0));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0 - 2.0));
                    break;
                }
                case 6: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0 - 2.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0 - 1.0));
                    break;
                }
                case 7: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0 - 1.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0 - 2.0));
                    break;
                }
                case 8: {
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0 - 1.0));
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(d3 * 3.0 - 2.0));
                    break;
                }
                case 9: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.CClip(d3 * 2.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.CClip(d3 * 2.0 - 1.0));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.CClip(d3 * 2.0));
                    break;
                }
                case 10: {
                    this.cmapRed[i] = (byte)(255.0 * Bundle.MClip(d3 * 1.5 + 1.0));
                    this.cmapGreen[i] = (byte)(255.0 * Bundle.MClip(d3 * 1.5 + 0.25));
                    this.cmapBlue[i] = (byte)(255.0 * Bundle.MClip(d3 * 1.5 - 0.5));
                    if (i != 0) break;
                    this.cmapRed[i] = 0;
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = 0;
                    break;
                }
                case 11: {
                    if (i == 0) {
                        this.cmapRed[i] = 0;
                        this.cmapGreen[i] = 0;
                        this.cmapBlue[i] = 0;
                        break;
                    }
                    this.cmapRed[i] = (byte)(255.0 * random.nextDouble());
                    this.cmapGreen[i] = (byte)(255.0 * random.nextDouble());
                    this.cmapBlue[i] = (byte)(255.0 * random.nextDouble());
                    break;
                }
                case 12: {
                    if (d3 < 0.3333333333333333) {
                        this.cmapRed[i] = (byte)(255.0 * Bundle.MClip(1.0 - d3 * 3.0));
                        this.cmapGreen[i] = (byte)(255.0 * Bundle.MClip(d3 * 3.0));
                        this.cmapBlue[i] = 0;
                    }
                    if (d3 >= 0.3333333333333333 && d3 < 0.6666666666666666) {
                        this.cmapRed[i] = 0;
                        this.cmapGreen[i] = (byte)(255.0 * Bundle.MClip(1.0 - (d3 - 0.3333333333333333) * 3.0));
                        this.cmapBlue[i] = (byte)(255.0 * Bundle.MClip((d3 - 0.3333333333333333) * 3.0));
                    }
                    if (d3 >= 0.6666666666666666) {
                        this.cmapRed[i] = (byte)(255.0 * Bundle.MClip((d3 - 0.6666666666666666) * 3.0));
                        this.cmapGreen[i] = 0;
                        this.cmapBlue[i] = (byte)(255.0 * Bundle.MClip(1.0 - (d3 - 0.6666666666666666) * 3.0));
                    }
                    if (i != 0) break;
                    this.cmapRed[i] = 0;
                    this.cmapGreen[i] = 0;
                    this.cmapBlue[i] = 0;
                    break;
                }
                default: {
                    int n = this.ElementModelNr - 13;
                    int n2 = (Integer)MapSizes.elementAt(n);
                    int n3 = (int)((double)(n2 - 1) * d3);
                    this.cmapRed[i] = ((byte[])RedMaps.elementAt(n))[n3];
                    this.cmapGreen[i] = ((byte[])GreenMaps.elementAt(n))[n3];
                    this.cmapBlue[i] = ((byte[])BlueMaps.elementAt(n))[n3];
                }
            }
            if (!this.cmapIsInverse) continue;
            this.cmapRed[i] = (byte)(255 - this.cmapRed[i]);
            this.cmapGreen[i] = (byte)(255 - this.cmapGreen[i]);
            this.cmapBlue[i] = (byte)(255 - this.cmapBlue[i]);
        }
        this.ElementModel = new IndexColorModel(15, 32768, this.cmapRed, this.cmapGreen, this.cmapBlue);
    }

    public void GenCMap() {
        this.cmapRed = new byte[32768];
        this.cmapGreen = new byte[32768];
        this.cmapBlue = new byte[32768];
        this.CompCMap();
    }

    public static int AddLookUpTable(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        MapSizes.addElement(new Integer(n));
        RedMaps.addElement(byArray);
        GreenMaps.addElement(byArray2);
        BlueMaps.addElement(byArray3);
        return MapSizes.size() - 1;
    }

    public void ToggleModel(int n) {
        this.ElementModelNr = n < 0 ? ++this.ElementModelNr : n;
        if (this.ElementModelNr >= 13 + MapSizes.size()) {
            this.ElementModelNr = 0;
        }
        this.CompCMap();
    }

    public boolean ToggleOvUn(int n) {
        this.ShowOvUn = n < 0 ? !this.ShowOvUn : n == 1;
        this.CompCMap();
        return this.ShowOvUn;
    }

    public void ToggleLog(int n) {
        this.LogScale = n < 0 ? !this.LogScale : n == 1;
        this.CompCMap();
    }
}

