/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.gui.NewImage;
import java.awt.Container;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

class ASlice {
    int[] mySlice;
    double[] my1DProj = null;
    int myDim;
    int AllSize;
    int SliceSizeX;
    int SliceSizeY;
    boolean isValid;
    int previousSlice;
    double ROISum = 0.0;
    double ROIAvg = 0.0;
    double ROIMax = 0.0;
    double ROIMin = 0.0;
    double ROIVoxels = 0.0;
    boolean MIPMode = true;
    ColorModel MyColorModel;
    int[] my1DProjVoxels = null;
    double Proj1DScale = 1.0;
    double Proj1DOffset = 0.0;

    ASlice(int n, AnElement anElement) {
        this.myDim = n;
        this.isValid = false;
        this.previousSlice = -1;
        switch (this.myDim) {
            case 0: {
                this.SliceSizeX = anElement.Sizes[2];
                this.SliceSizeY = anElement.Sizes[1];
                this.AllSize = this.SliceSizeX * this.SliceSizeY;
                this.mySlice = new int[this.AllSize];
                break;
            }
            case 1: {
                this.SliceSizeX = anElement.Sizes[0];
                this.SliceSizeY = anElement.Sizes[2];
                this.AllSize = this.SliceSizeX * this.SliceSizeY;
                this.mySlice = new int[this.AllSize];
                break;
            }
            case 2: {
                this.SliceSizeX = anElement.Sizes[0];
                this.SliceSizeY = anElement.Sizes[1];
                this.AllSize = this.SliceSizeX * this.SliceSizeY;
                this.mySlice = new int[this.AllSize];
            }
        }
        this.AllSize = this.SliceSizeX * this.SliceSizeY;
    }

    void TakeModel(ColorModel colorModel) {
        this.MyColorModel = colorModel;
    }

    void Invalidate() {
        this.isValid = false;
    }

    void setMIPMode(boolean bl) {
        if (bl != this.MIPMode) {
            this.Invalidate();
        }
        this.MIPMode = bl;
    }

    Image GenImage(Container container) {
        MemoryImageSource memoryImageSource;
        try {
            memoryImageSource = new MemoryImageSource(this.SliceSizeX, this.SliceSizeY, this.MyColorModel, this.mySlice, 0, this.SliceSizeX);
        }
        catch (Exception exception) {
            System.out.println("Caught Image generation Exception:" + exception + "\n");
            exception.printStackTrace();
            memoryImageSource = null;
        }
        return container.createImage(memoryImageSource);
    }

    Image GenColorImage(Container container) {
        MemoryImageSource memoryImageSource;
        try {
            memoryImageSource = new MemoryImageSource(this.SliceSizeX, this.SliceSizeY, this.mySlice, 0, this.SliceSizeX);
        }
        catch (Exception exception) {
            System.out.println("Caught Image generation Exception:" + exception + "\n");
            exception.printStackTrace();
            memoryImageSource = null;
        }
        return container.createImage(memoryImageSource);
    }

    void UpdateSlice(int n, AnElement anElement, AnElement anElement2) {
        if (this.previousSlice != n) {
            this.isValid = false;
        }
        if (this.isValid) {
            return;
        }
        try {
            switch (this.myDim) {
                case 0: {
                    for (int i = 0; i < anElement.Sizes[2]; ++i) {
                        for (int j = 0; j < anElement.Sizes[1]; ++j) {
                            int n2 = anElement.GetIntValueAt(n, j, i);
                            if (n2 < 0) {
                                n2 = 0;
                            }
                            if (n2 > Short.MAX_VALUE) {
                                n2 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(n, j, i) <= 0) {
                                n2 = 0;
                            }
                            this.mySlice[i + anElement.Sizes[2] * j] = n2;
                        }
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < anElement.Sizes[2]; ++i) {
                        for (int j = 0; j < anElement.Sizes[0]; ++j) {
                            int n3 = anElement.GetIntValueAt(j, n, i);
                            if (n3 < 0) {
                                n3 = 0;
                            }
                            if (n3 > Short.MAX_VALUE) {
                                n3 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(j, n, i) <= 0) {
                                n3 = 0;
                            }
                            this.mySlice[j + anElement.Sizes[0] * i] = n3;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < anElement.Sizes[1]; ++i) {
                        for (int j = 0; j < anElement.Sizes[0]; ++j) {
                            int n4 = anElement.GetIntValueAt(j, i, n);
                            if (n4 < 0) {
                                n4 = 0;
                            }
                            if (n4 > Short.MAX_VALUE) {
                                n4 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(j, i, n) <= 0) {
                                n4 = 0;
                            }
                            this.mySlice[j + anElement.Sizes[0] * i] = n4;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Slice-Copy Exception:" + exception + "\n");
            exception.printStackTrace();
        }
        this.isValid = true;
        this.previousSlice = n;
    }

    void SumToColorSlice(int n, AnElement anElement, byte[] byArray, byte[] byArray2, byte[] byArray3, AnElement anElement2) {
        try {
            switch (this.myDim) {
                case 0: {
                    for (int i = 0; i < anElement.Sizes[2]; ++i) {
                        for (int j = 0; j < anElement.Sizes[1]; ++j) {
                            int n2 = anElement.GetIntValueAt(n, j, i);
                            if (n2 < 0) {
                                n2 = 0;
                            }
                            if (n2 > Short.MAX_VALUE) {
                                n2 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(n, j, i) <= 0) {
                                n2 = 0;
                            }
                            int n3 = this.mySlice[i + anElement.Sizes[2] * j];
                            int n4 = byArray[n2] & 0xFF;
                            int n5 = byArray2[n2] & 0xFF;
                            int n6 = byArray3[n2] & 0xFF;
                            if ((n4 = (n4 << 16) + (n3 & 0xFF0000)) > 0xFF0000) {
                                n4 = 0xFF0000;
                            }
                            if ((n5 = (n5 << 8) + (n3 & 0xFF00)) > 65280) {
                                n5 = 65280;
                            }
                            if ((n6 += n3 & 0xFF) > 255) {
                                n6 = 255;
                            }
                            this.mySlice[i + anElement.Sizes[2] * j] = 0xFF000000 | n4 | n5 | n6;
                        }
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < anElement.Sizes[2]; ++i) {
                        for (int j = 0; j < anElement.Sizes[0]; ++j) {
                            int n7 = anElement.GetIntValueAt(j, n, i);
                            if (n7 < 0) {
                                n7 = 0;
                            }
                            if (n7 > Short.MAX_VALUE) {
                                n7 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(j, n, i) <= 0) {
                                n7 = 0;
                            }
                            int n8 = this.mySlice[j + anElement.Sizes[0] * i];
                            int n9 = byArray[n7] & 0xFF;
                            int n10 = byArray2[n7] & 0xFF;
                            int n11 = byArray3[n7] & 0xFF;
                            if ((n9 = (n9 << 16) + (n8 & 0xFF0000)) > 0xFF0000) {
                                n9 = 0xFF0000;
                            }
                            if ((n10 = (n10 << 8) + (n8 & 0xFF00)) > 65280) {
                                n10 = 65280;
                            }
                            if ((n11 += n8 & 0xFF) > 255) {
                                n11 = 255;
                            }
                            this.mySlice[j + anElement.Sizes[0] * i] = 0xFF000000 | n9 | n10 | n11;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < anElement.Sizes[1]; ++i) {
                        for (int j = 0; j < anElement.Sizes[0]; ++j) {
                            int n12 = anElement.GetIntValueAt(j, i, n);
                            if (n12 < 0) {
                                n12 = 0;
                            }
                            if (n12 > Short.MAX_VALUE) {
                                n12 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(j, i, n) <= 0) {
                                n12 = 0;
                            }
                            int n13 = this.mySlice[j + anElement.Sizes[0] * i];
                            int n14 = byArray[n12] & 0xFF;
                            int n15 = byArray2[n12] & 0xFF;
                            int n16 = byArray3[n12] & 0xFF;
                            if ((n14 = (n14 << 16) + (n13 & 0xFF0000)) > 0xFF0000) {
                                n14 = 0xFF0000;
                            }
                            if ((n15 = (n15 << 8) + (n13 & 0xFF00)) > 65280) {
                                n15 = 65280;
                            }
                            if ((n16 += n13 & 0xFF) > 255) {
                                n16 = 255;
                            }
                            this.mySlice[j + anElement.Sizes[0] * i] = 0xFF000000 | n14 | n15 | n16;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Slice-Copy Exception:" + exception + "\n");
            exception.printStackTrace();
        }
        this.previousSlice = n;
    }

    void MulToColorSlice(int n, AnElement anElement, byte[] byArray, byte[] byArray2, byte[] byArray3, AnElement anElement2) {
        try {
            switch (this.myDim) {
                case 0: {
                    for (int i = 0; i < anElement.Sizes[2]; ++i) {
                        for (int j = 0; j < anElement.Sizes[1]; ++j) {
                            int n2 = anElement.GetIntValueAt(n, j, i);
                            if (n2 < 0) {
                                n2 = 0;
                            }
                            if (n2 > Short.MAX_VALUE) {
                                n2 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(n, j, i) <= 0) {
                                n2 = 0;
                            }
                            int n3 = this.mySlice[i + anElement.Sizes[2] * j];
                            int n4 = (byArray[n2] & 0xFF) * (n3 >> 16 & 0xFF);
                            int n5 = (byArray2[n2] & 0xFF) * (n3 >> 8 & 0xFF);
                            int n6 = (byArray3[n2] & 0xFF) * (n3 & 0xFF);
                            n4 = (n4 >> 8 & 0xFF) << 16;
                            n6 = n6 >> 8 & 0xFF;
                            this.mySlice[i + anElement.Sizes[2] * j] = 0xFF000000 | n4 | (n5 &= 0xFF00) | n6;
                        }
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < anElement.Sizes[2]; ++i) {
                        for (int j = 0; j < anElement.Sizes[0]; ++j) {
                            int n7 = anElement.GetIntValueAt(j, n, i);
                            if (n7 < 0) {
                                n7 = 0;
                            }
                            if (n7 > Short.MAX_VALUE) {
                                n7 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(j, n, i) <= 0) {
                                n7 = 0;
                            }
                            int n8 = this.mySlice[j + anElement.Sizes[0] * i];
                            int n9 = (byArray[n7] & 0xFF) * (n8 >> 16 & 0xFF);
                            int n10 = (byArray2[n7] & 0xFF) * (n8 >> 8 & 0xFF);
                            int n11 = (byArray3[n7] & 0xFF) * (n8 & 0xFF);
                            n9 = (n9 >> 8 & 0xFF) << 16;
                            n11 = n11 >> 8 & 0xFF;
                            this.mySlice[j + anElement.Sizes[0] * i] = 0xFF000000 | n9 | (n10 &= 0xFF00) | n11;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < anElement.Sizes[1]; ++i) {
                        for (int j = 0; j < anElement.Sizes[0]; ++j) {
                            int n12 = anElement.GetIntValueAt(j, i, n);
                            if (n12 < 0) {
                                n12 = 0;
                            }
                            if (n12 > Short.MAX_VALUE) {
                                n12 = Short.MAX_VALUE;
                            }
                            if (anElement2.GetIntValueAt(j, i, n) <= 0) {
                                n12 = 0;
                            }
                            int n13 = this.mySlice[j + anElement.Sizes[0] * i];
                            int n14 = (byArray[n12] & 0xFF) * (n13 >> 16 & 0xFF);
                            int n15 = (byArray2[n12] & 0xFF) * (n13 >> 8 & 0xFF);
                            int n16 = (byArray3[n12] & 0xFF) * (n13 & 0xFF);
                            n14 = (n14 >> 8 & 0xFF) << 16;
                            n16 = n16 >> 8 & 0xFF;
                            this.mySlice[j + anElement.Sizes[0] * i] = 0xFF000000 | n14 | (n15 &= 0xFF00) | n16;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Slice-Copy Exception:" + exception + "\n");
            exception.printStackTrace();
        }
        this.previousSlice = n;
    }

    void MergeColor(int n, ASlice aSlice) {
        int n2 = 0;
        n2 = n == 0 ? 16 : (n == 1 ? 8 : 0);
        int n3 = 0;
        while (n3 < this.AllSize) {
            int n4 = aSlice.mySlice[n3] >> 8;
            int n5 = n3++;
            this.mySlice[n5] = this.mySlice[n5] | n4 << n2;
        }
    }

    public void ClearColor() {
        for (int i = 0; i < this.AllSize; ++i) {
            this.mySlice[i] = -16777216;
        }
    }

    public void Clear() {
        for (int i = 0; i < this.AllSize; ++i) {
            this.mySlice[i] = 0;
        }
    }

    private int ProjectionPos(int n, int n2, int n3, int n4) {
        if (n == 0) {
            return n4 + this.SliceSizeX * n3;
        }
        if (n == 1) {
            return n2 + this.SliceSizeX * n4;
        }
        if (n == 2) {
            return n2 + this.SliceSizeX * n3;
        }
        return 0;
    }

    private int ProjSizeDim(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 1) {
            return 0;
        }
        return 2;
    }

    private int Proj1DPos(int n, int n2, int n3, int n4) {
        if (n == 0) {
            return n3;
        }
        if (n == 2) {
            return n4;
        }
        if (n == 1) {
            return n2;
        }
        return n4;
    }

    private int XPos3D(int n, int n2, int n3, int n4) {
        if (n == 0) {
            return n4;
        }
        if (n == 1) {
            return n2;
        }
        return n2;
    }

    private int YPos3D(int n, int n2, int n3, int n4) {
        if (n == 0) {
            return n3;
        }
        if (n == 1) {
            return n4;
        }
        return n3;
    }

    private int ZPos3D(int n, int n2, int n3, int n4) {
        if (n == 0) {
            return n2;
        }
        if (n == 1) {
            return n3;
        }
        return n4;
    }

    public void DoProject(int n, AnElement anElement, AnElement anElement2, ROI rOI) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.ROISum = 0.0;
        this.ROIAvg = 0.0;
        this.ROIMax = -1.7976931348623157E308;
        this.ROIMin = Double.MAX_VALUE;
        int n7 = anElement.Sizes[this.ProjSizeDim(n)];
        if (this.my1DProj == null) {
            this.my1DProj = new double[n7];
            this.my1DProjVoxels = new int[n7];
        }
        this.Clear();
        for (n3 = 0; n3 < n7; ++n3) {
            this.my1DProj[n3] = 0.0;
            this.my1DProjVoxels[n3] = 0;
        }
        for (n3 = 0; n3 < this.SliceSizeX; ++n3) {
            for (int i = 0; i < this.SliceSizeY; ++i) {
                n6 = 0;
                for (n2 = 0; n2 < anElement.Sizes[n]; ++n2) {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = this.XPos3D(n, n3, i, n2);
                    if (!rOI.InROIRange(n11, n10 = this.YPos3D(n, n3, i, n2), n9 = this.ZPos3D(n, n3, i, n2)) || anElement2.GetIntValueAt(n11, n10, n9) <= 0) continue;
                    ++n4;
                    ++n6;
                    double d = anElement.GetValueAt(n11, n10, n9);
                    this.ROISum += d;
                    if (d < this.ROIMin) {
                        this.ROIMin = d;
                    }
                    if (d > this.ROIMax) {
                        this.ROIMax = d;
                    }
                    if ((n8 = anElement.GetIntValueAt(n11, n10, n9)) < 0) {
                        n8 = 0;
                    }
                    int n12 = this.Proj1DPos(n, n11, n10, n9);
                    this.my1DProjVoxels[n12] = this.my1DProjVoxels[n12] + 1;
                    if (this.MIPMode) {
                        if (n8 > this.mySlice[n3 + this.SliceSizeX * i]) {
                            this.mySlice[n3 + this.SliceSizeX * i] = n8;
                        }
                        if (!(d > this.my1DProj[this.Proj1DPos(n, n11, n10, n9)])) continue;
                        this.my1DProj[this.Proj1DPos((int)n, (int)n11, (int)n10, (int)n9)] = d;
                        continue;
                    }
                    int n13 = n3 + this.SliceSizeX * i;
                    this.mySlice[n13] = this.mySlice[n13] + n8;
                    int n14 = this.Proj1DPos(n, n11, n10, n9);
                    this.my1DProj[n14] = this.my1DProj[n14] + d;
                }
                if (n6 <= 0) continue;
                if (!this.MIPMode) {
                    int n15 = n3 + this.SliceSizeX * i;
                    this.mySlice[n15] = this.mySlice[n15] / n6;
                }
                if (this.mySlice[n3 + this.SliceSizeX * i] <= n5) continue;
                n5 = this.mySlice[n3 + this.SliceSizeX * i];
            }
        }
        double d = 32767.0 / (double)n5;
        for (n2 = 0; n2 < this.AllSize; ++n2) {
            this.mySlice[n2] = (int)((double)this.mySlice[n2] * d);
            if (this.mySlice[n2] >= 0) continue;
            this.mySlice[n2] = 0;
        }
        double d2 = -1.0E30;
        double d3 = 1.0E30;
        for (int i = 0; i < n7; ++i) {
            if (!this.MIPMode && this.my1DProjVoxels[i] > 0) {
                int n16 = i;
                this.my1DProj[n16] = this.my1DProj[n16] / (double)this.my1DProjVoxels[i];
            }
            if (this.my1DProj[i] > d2) {
                d2 = this.my1DProj[i];
            }
            if (!(this.my1DProj[i] < d3)) continue;
            d3 = this.my1DProj[i];
        }
        this.Proj1DScale = 1.0 / (d2 - d3);
        this.Proj1DOffset = d3;
        if (n4 > 0) {
            this.ROIAvg = this.ROISum / (double)n4;
        }
        this.ROIVoxels = n4;
        this.isValid = true;
    }

    double Get1DProjValue(int n) {
        if (this.my1DProj != null) {
            return this.my1DProj[n];
        }
        System.out.println("Error: Projection not initialized\n");
        return 0.0;
    }

    double GetNormed1DProjValue(int n) {
        if (this.my1DProj != null) {
            return (this.my1DProj[n] - this.Proj1DOffset) * this.Proj1DScale;
        }
        System.out.println("Error: Projection not initialized\n");
        return 0.0;
    }

    public ImagePlus Export() {
        ImagePlus imagePlus = NewImage.createShortImage("View5D Gray Slice", this.SliceSizeX, this.SliceSizeY, 1, 1);
        short[] sArray = (short[])imagePlus.getStack().getPixels(1);
        for (int i = 0; i < this.SliceSizeX * this.SliceSizeY; ++i) {
            sArray[i] = (short)this.mySlice[i];
        }
        return imagePlus;
    }

    public ImagePlus ColorExport() {
        ImagePlus imagePlus = NewImage.createRGBImage("View5D Color Slice", this.SliceSizeX, this.SliceSizeY, 1, 1);
        int[] nArray = (int[])imagePlus.getStack().getPixels(1);
        for (int i = 0; i < this.SliceSizeX * this.SliceSizeY; ++i) {
            nArray[i] = this.mySlice[i];
        }
        return imagePlus;
    }
}

