/*
 * Filename: dip_filtering.h
 *
 * (C) Copyright 1995-1997               Pattern Recognition Group
 *     All rights reserved               Faculty of Applied Physics
 *                                       Delft University of Technology
 *                                       Lorentzweg 1
 *                                       2628 CJ Delft
 *                                       The Netherlands
 *
 * Contact: Dr. ir. Lucas J. van Vliet
 * email : lucas@ph.tn.tudelft.nl
 *
 */

#ifndef DIP_FILTERING_H
#define DIP_FILTERING_H
#ifdef __cplusplus
extern "C" {
#endif

#include "dip_pixel_table.h"

typedef enum
{
	DIP_SUBPIXELMAXIMA_DEFAULT = 0,     /* parabolic */
	DIP_SUBPIXELMAXIMA_LINEAR = 1,
   DIP_SUBPIXELMAXIMA_PARABOLIC_SEPARABLE = 2,
   DIP_SUBPIXELMAXIMA_GAUSSIAN_SEPARABLE = 3,
   DIP_SUBPIXELMAXIMA_BSPLINE = 4,
	DIP_SUBPIXELMAXIMA_PARABOLIC = 5,
	DIP_SUBPIXELMAXIMA_GAUSSIAN = 6
} dipf_SubpixelMaxima;

typedef struct
{
   dip_float sigma;
   dip_float sigma2;
   dip_Boolean outputCount;
   dip_Boolean threshold;
   dip_FloatArray gaussCoeff;
} dip_SigmaFilterParameters;

#define DIP_SIGMA_EXP_CUTOFF (-20.0)

DIP_ERROR dip_VarianceFilter( dip_Image, dip_Image, dip_Image,
      dip_BoundaryArray, dip_FloatArray, dip_FilterShape );

DIP_ERROR dip_Kuwahara( dip_Image, dip_Image, dip_Image, dip_BoundaryArray,
      dip_FloatArray, dip_FilterShape );

DIP_ERROR dip_GeneralisedKuwahara( dip_Image, dip_Image, dip_Image,
      dip_Image, dip_BoundaryArray, dip_FloatArray,
      dip_FilterShape, dip_Boolean );

DIP_ERROR dip_Sigma ( dip_Image, dip_Image, dip_Image, dip_BoundaryArray,
         dip_FloatArray, dip_FilterShape, dip_float, dip_Boolean, dip_Boolean);

DIP_ERROR dip_BiasedSigma ( dip_Image, dip_Image, dip_Image, dip_BoundaryArray,
         dip_FloatArray, dip_FilterShape, dip_float, dip_Boolean, dip_Boolean);

DIP_ERROR dip_GaussianSigma ( dip_Image, dip_Image, dip_BoundaryArray,
         dip_float, dip_FloatArray, dip_Boolean, dip_Boolean, dip_float);

DIP_ERROR dip_Maxima ( dip_Image, dip_Image, dip_Image, dip_int, dip_Boolean );
DIP_ERROR dip_Minima ( dip_Image, dip_Image, dip_Image, dip_int, dip_Boolean );

DIP_ERROR dip_SubpixelMaxima ( dip_Image, dip_Image, dip_ImageArray, dipf_SubpixelMaxima );

#ifdef __cplusplus
}
#endif
#endif
