%CROPIM   Crop an image
%
% SYNOPSIS:
%  image_out = gaussf(image_in,<origin>,crop_size)
%
% PARAMETERS:
%    <origin>    optional: the origin of the crop region, if not explicitly
%                          given: origin=floor(0.5*(size(image_in)-crop_size))
%    crop_size   size of the crop region

function imo=cropim(varargin)

imi=varargin{1};
if nargin==1
   if ischar(imi) & strcmp(imi,'DIP_GetParamList')
      imo=struct('menu','none');
      return;
   end
end

origin=[];
cropsize=[];
switch nargin
   case 1
   case 2
      cropsize=varargin{2};
   case 3
      origin=varargin{2};
      cropsize=varargin{3};
   otherwise
      error('too many input arguments');
end
imo=iterate('dip_crop',imi,origin,cropsize);
return;
