%OUTER   Outer product of two tensor images.
%   OUTER(A,B) returns the outer product of the tensors in the
%   dip_image_arrays A and B.
%
%   OUTER is only defined for tensors with 3 components.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger and Cris Luengo, July 2000.

function out = outer(in1,in2)
try
   [in1,in2,arrayop] = doarrayinputs(in1,in2);
catch
   error(di_firsterr)
end
if arrayop
   s1 = imarsize(in1);
   s2 = imarsize(in2);
   if length(s1) ~= length(s2) | s1 ~= s2
      error('Tensor sizes do not match.')
   end
   if prod(s1) ~= 3
      error('Outer product only implemented for 3D tensors.')
   end
   out = dip_image('array',3);
   out(1) = in1(2).*in2(3)-in1(3).*in2(2);
   out(2) = in1(3).*in2(1)-in1(1).*in2(3);
   out(3) = in1(1).*in2(2)-in1(2).*in2(1);
else
   error('Operation only defined for tensor images.')
end
