%MEAN   Mean of all pixels in an image.
%   VALUE = MEAN(B) returns the mean intensity of all pixels in image B.
%
%   VALUE = MEAN(B,W) is a weighted mean, equivalent to MEAN(B*W). W can
%   be a binary image M to work as a mask, but if B contains NaN's, you
%   should use MEAN(B(M)).
%
%   VALUE = MEAN(B,W,DIM) performs the computation over the dimensions
%   specified in DIM. DIM can be an array with any number of dimensions.
%   W can be [].

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2001.
% 24 June 2003: Corrected help on mask parameter.

function value = mean(in,mask,d)
if ~isscalar(in), error('Parameter "in" is an array of images.'), end
nd = ndims(in);
if nd == 0
   value = double(in);
else
   if nargin < 2
      mask = [];
   end
   try
      if nargin < 3
         process = di_processarray(nd);
         value = double(dip_mean(in,mask,process));
      else
         process = di_processarray(nd,d);
         value = dip_mean(in,mask,process);
      end
   catch
      error(di_firsterr)
   end
end
