%GT   Overloaded operator for a>b.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2000.
% 15 September 2001: We don't need to use COMPUTE2 for relational operators.
% 15 November 2002: Fixed binary images to work in MATLAB 6.5 (R13)
% February 2008: Adding pixel dimensions and units to dip_image. (BR)

function out = gt(in1,in2)
try
   [in1,in2,dims,out_type,out_phys] = do2inputs(in1,in2);
   out = dip_image;
   out.data = uint8(+(in1>in2));
      % IN1>IN2 is not 'uint8' if both IN1 and IN2 are 'double'.
   out.dims = dims;
   out.dip_type = 'bin'; 
   out.physDims = out_phys;
catch
   error(di_firsterr)
end
