%CONJ   Complex conjugate.
%   CONJ(B) returns the complex conjugate of each pixel in B.

% (C) Copyright 1999-2000               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, May 2000.
% June 2006, added tensor image support (BR)

function out = conj(in)
try
   [in,arrayop] = do1arrayinput(in);
catch
   error(di_firsterr)
end
if arrayop
   try
      out = compute1array('conj',in);
   catch
      error(di_firsterr)
   end
else
   if strcmp(in.dip_type(2:end),'complex')
      out = compute1('conj',in.data,in.dims,in.dip_type,in.physDims);
   else % do nothing!
      out = in;
   end
end
