%BESSELJ   Bessel function of the first kind.
%   J = BESSELJ(NU,Z), where Z is an image, creates an image of the same
%   size as Z, with the NU'th order Bessel function of the pixel values
%   of Z. For this to work, NU must be either a scalar or of the same
%   size as Z.
%
%   B = 2*BESSELJ(1,RR)/RR is the Fourier Transform of a correctly sampled
%   circle.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, October 2000.
% February 2008: Adding pixel dimensions and units to dip_image. (BR)

function out = besselj(in1,in2)
try
   [in1,in2,dims,out_type,out_phys] = do2inputs(in1,in2);
   out_type = di_diptype(in2);
   if ~strcmp(out_type,'dfloat')
      out_type = 'sfloat';
   end
   if prod(size(in2)) == 1 & prod(size(in1)) ~= 1
      % Don't let second be scalar, but first not.
      error('Dimensionalities do not match.')
   end
   % If both are vectors, don't let one have a different orientation
   % than the other. This is accomplished automatically with the new
   % do2inputs.
   out = compute2('besselj',in1,in2,dims,out_type,out_phys);
catch
   error(di_firsterr)
end
