/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.plugin.filter.Convolver;
import ij.process.BinaryProcessor;
import ij.process.ByteBlitter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Random;

public class ByteProcessor
extends ImageProcessor {
    protected byte[] pixels;
    protected byte[] snapshotPixels;
    private int bgColor = 255;
    private int min = 0;
    private int max = 255;
    static double oldx;
    static double oldy;

    public ByteProcessor(Image image) {
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.resetRoi();
        this.pixels = new byte[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
        this.cm = pixelGrabber.getColorModel();
        if (this.cm instanceof IndexColorModel) {
            this.pixels = (byte[])pixelGrabber.getPixels();
        } else {
            System.err.println("ByteProcessor: not 8-bit image");
        }
    }

    public ByteProcessor(int n, int n2) {
        this(n, n2, new byte[n * n2], null);
    }

    public ByteProcessor(int n, int n2, byte[] byArray, ColorModel colorModel) {
        if (byArray != null && n * n2 != byArray.length) {
            throw new IllegalArgumentException("(width*height) != pixels.length");
        }
        this.width = n;
        this.height = n2;
        this.resetRoi();
        this.pixels = byArray;
        this.cm = colorModel;
    }

    public Image createImage() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.source == null || IJ.isMacintosh() && !IJ.isJava2()) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    public ImageProcessor createProcessor(int n, int n2) {
        ByteProcessor byteProcessor = new ByteProcessor(n, n2, new byte[n * n2], this.getColorModel());
        if (this.baseCM != null) {
            ((ImageProcessor)byteProcessor).setMinAndMax(this.min, this.max);
        }
        return byteProcessor;
    }

    public ImageProcessor crop() {
        ImageProcessor imageProcessor = this.createProcessor(this.roiWidth, this.roiHeight);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = (n - this.roiY) * this.roiWidth;
            int n3 = n * this.width + this.roiX;
            int n4 = 0;
            while (n4 < this.roiWidth) {
                byArray[n2++] = this.pixels[n3++];
                ++n4;
            }
            ++n;
        }
        return imageProcessor;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new byte[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset(int[] nArray) {
        if (nArray == null || this.snapshotPixels == null) {
            return;
        }
        if (nArray.length != this.roiWidth * this.roiHeight) {
            throw new IllegalArgumentException("mask.length!=roiWidth*roiHeight");
        }
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] != -16777216) {
                    this.pixels[n3] = this.snapshotPixels[n3];
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public void fill(int[] nArray) {
        if (nArray == null) {
            this.fill();
            return;
        }
        if (nArray.length != this.roiWidth * this.roiHeight) {
            throw new IllegalArgumentException();
        }
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] == -16777216) {
                    this.pixels[n3] = (byte)this.fgColor;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public int getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.pixels[n2 * this.width + n] & 0xFF;
        }
        return 0;
    }

    public double getInterpolatedPixel(double d, double d2) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d >= (double)this.width - 1.0) {
            d = (double)this.width - 1.001;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 >= (double)this.height - 1.0) {
            d2 = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(d, d2, this.pixels);
    }

    public double getInterpolatedValue(double d, double d2) {
        if (this.cTable == null) {
            return this.getInterpolatedPixel(d, d2);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d >= (double)this.width - 1.0) {
            d = (double)this.width - 1.001;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 >= (double)this.height - 1.0) {
            d2 = (double)this.height - 1.001;
        }
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        double d5 = this.cTable[this.pixels[n3] & 0xFF];
        double d6 = this.cTable[this.pixels[n3 + 1] & 0xFF];
        double d7 = this.cTable[this.pixels[n3 + this.width + 1] & 0xFF];
        double d8 = this.cTable[this.pixels[n3 + this.width] & 0xFF];
        double d9 = d8 + d3 * (d7 - d8);
        double d10 = d5 + d3 * (d6 - d5);
        return d10 + d4 * (d9 - d10);
    }

    public float getPixelValue(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (this.cTable == null) {
                return this.pixels[n2 * this.width + n] & 0xFF;
            }
            return this.cTable[this.pixels[n2 * this.width + n] & 0xFF];
        }
        return 0.0f;
    }

    public void setColor(Color color) {
        this.drawingColor = color;
        this.fgColor = this.getBestIndex(color);
    }

    public void setValue(double d) {
        this.fgColor = (int)d;
        if (this.fgColor < 0) {
            this.fgColor = 0;
        }
        if (this.fgColor > 255) {
            this.fgColor = 255;
        }
    }

    public void putPixelValue(int n, int n2, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (d > 255.0) {
                d = 255.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
            this.pixels[n2 * this.width + n] = (byte)(d + 0.5);
        }
    }

    public void putPixel(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height && n3 > 255) {
            n3 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.pixels[n2 * this.width + n] = (byte)n3;
    }

    public void drawPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = (byte)this.fgColor;
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.snapshotPixels != null && this.newSnapshot) {
            return this.snapshotPixels;
        }
        byte[] byArray = new byte[this.width * this.height];
        System.arraycopy(this.pixels, 0, byArray, 0, this.width * this.height);
        return byArray;
    }

    public void setPixels(Object object) {
        if (object != null && this.pixels != null && ((byte[])object).length != this.pixels.length) {
            throw new IllegalArgumentException("");
        }
        this.pixels = (byte[])object;
        this.resetPixels(object);
        this.snapshotPixels = null;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double d, double d2) {
        if (d2 < d) {
            return;
        }
        this.min = (int)d;
        this.max = (int)d2;
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            indexColorModel.getReds(this.rLUT1);
            indexColorModel.getGreens(this.gLUT1);
            indexColorModel.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        int n = 0;
        while (n < 256) {
            if ((double)n < d) {
                this.rLUT2[n] = this.rLUT1[0];
                this.gLUT2[n] = this.gLUT1[0];
                this.bLUT2[n] = this.bLUT1[0];
            } else if ((double)n > d2) {
                this.rLUT2[n] = this.rLUT1[255];
                this.gLUT2[n] = this.gLUT1[255];
                this.bLUT2[n] = this.bLUT1[255];
            } else {
                int n2 = n - this.min;
                if ((n2 = (int)(256.0 * (double)n2 / (d2 - d))) < 0) {
                    n2 = 0;
                }
                if (n2 > 255) {
                    n2 = 255;
                }
                this.rLUT2[n] = this.rLUT1[n2];
                this.gLUT2[n] = this.gLUT1[n2];
                this.bLUT2[n] = this.bLUT1[n2];
            }
            ++n;
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
        this.newPixels = true;
        this.minThreshold = -808080.0;
    }

    public void resetMinAndMax() {
        this.setMinAndMax(0.0, 255.0);
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        if (!(imageProcessor instanceof ByteProcessor) && !(imageProcessor instanceof ColorProcessor)) {
            throw new IllegalArgumentException("8-bit or RGB image required");
        }
        new ByteBlitter(this).copyBits(imageProcessor, n, n2, n3);
    }

    public void applyTable(int[] nArray) {
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2;
            int n3 = n * this.width + this.roiX;
            int n4 = n2 = n3 + this.roiWidth;
            while (--n4 >= n3) {
                this.pixels[n4] = (byte)nArray[this.pixels[n4] & 0xFF];
            }
            ++n;
        }
    }

    public void convolve3x3(int[] nArray) {
        int n;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = 0;
        int n12 = 0;
        while (n12 < nArray.length) {
            n11 += nArray[n12];
            ++n12;
        }
        if (n11 == 0) {
            n11 = 1;
        }
        if ((n = this.roiHeight / 25) < 1) {
            n = 1;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        int n13 = this.width;
        int n14 = this.yMin;
        while (n14 <= this.yMax) {
            int n15 = this.xMin + n14 * this.width;
            int n16 = 0;
            int n17 = byArray[n15 - n13 - 1] & 0xFF;
            int n18 = byArray[n15 - n13] & 0xFF;
            int n19 = 0;
            int n20 = byArray[n15 - 1] & 0xFF;
            int n21 = byArray[n15] & 0xFF;
            int n22 = 0;
            int n23 = byArray[n15 + n13 - 1] & 0xFF;
            int n24 = byArray[n15 + n13] & 0xFF;
            int n25 = this.xMin;
            while (n25 <= this.xMax) {
                n16 = n17;
                n17 = n18;
                n18 = byArray[n15 - n13 + 1] & 0xFF;
                n19 = n20;
                n20 = n21;
                n21 = byArray[n15 + 1] & 0xFF;
                n22 = n23;
                n23 = n24;
                n24 = byArray[n15 + n13 + 1] & 0xFF;
                int n26 = n2 * n16 + n3 * n17 + n4 * n18 + n5 * n19 + n6 * n20 + n7 * n21 + n8 * n22 + n9 * n23 + n10 * n24;
                if ((n26 /= n11) > 255) {
                    n26 = 255;
                }
                if (n26 < 0) {
                    n26 = 0;
                }
                this.pixels[n15++] = (byte)n26;
                ++n25;
            }
            if (n14 % n == 0) {
                this.showProgress((double)(n14 - this.roiY) / (double)this.roiHeight);
            }
            ++n14;
        }
        this.hideProgress();
    }

    public void filter(int n) {
        int n2 = this.roiHeight / 25;
        if (n2 < 1) {
            n2 = 1;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[10];
        if (n == 2) {
            nArray = new int[10];
        }
        int n5 = this.width;
        boolean bl = false;
        int n6 = this.yMin;
        while (n6 <= this.yMax) {
            int n7 = this.xMin + n6 * this.width;
            int n8 = byArray[n7 - n5 - 1] & 0xFF;
            int n9 = byArray[n7 - n5] & 0xFF;
            int n10 = byArray[n7 - 1] & 0xFF;
            int n11 = byArray[n7] & 0xFF;
            int n12 = byArray[n7 + n5 - 1] & 0xFF;
            int n13 = byArray[n7 + n5] & 0xFF;
            int n14 = this.xMin;
            while (n14 <= this.xMax) {
                int n15 = n8;
                n8 = n9;
                n9 = byArray[n7 - n5 + 1] & 0xFF;
                int n16 = n10;
                n10 = n11;
                n11 = byArray[n7 + 1] & 0xFF;
                int n17 = n12;
                n12 = n13;
                n13 = byArray[n7 + n5 + 1] & 0xFF;
                switch (n) {
                    case 0: {
                        n4 = (n15 + n8 + n9 + n16 + n10 + n11 + n17 + n12 + n13) / 9;
                        break;
                    }
                    case 1: {
                        int n18 = n15 + 2 * n8 + n9 - n17 - 2 * n12 - n13;
                        n3 = n15 + 2 * n16 + n17 - n9 - 2 * n11 - n13;
                        n4 = (int)Math.sqrt(n18 * n18 + n3 * n3);
                        if (n4 <= 255) break;
                        n4 = 255;
                        break;
                    }
                    case 2: {
                        nArray[1] = n15;
                        nArray[2] = n8;
                        nArray[3] = n9;
                        nArray[4] = n16;
                        nArray[5] = n10;
                        nArray[6] = n11;
                        nArray[7] = n17;
                        nArray[8] = n12;
                        nArray[9] = n13;
                        n4 = this.findMedian(nArray);
                        break;
                    }
                    case 3: {
                        n4 = n10;
                        if (n15 < n4) {
                            n4 = n15;
                        }
                        if (n8 < n4) {
                            n4 = n8;
                        }
                        if (n9 < n4) {
                            n4 = n9;
                        }
                        if (n16 < n4) {
                            n4 = n16;
                        }
                        if (n11 < n4) {
                            n4 = n11;
                        }
                        if (n17 < n4) {
                            n4 = n17;
                        }
                        if (n12 < n4) {
                            n4 = n12;
                        }
                        if (n13 >= n4) break;
                        n4 = n13;
                        break;
                    }
                    case 4: {
                        n4 = n10;
                        if (n15 > n4) {
                            n4 = n15;
                        }
                        if (n8 > n4) {
                            n4 = n8;
                        }
                        if (n9 > n4) {
                            n4 = n9;
                        }
                        if (n16 > n4) {
                            n4 = n16;
                        }
                        if (n11 > n4) {
                            n4 = n11;
                        }
                        if (n17 > n4) {
                            n4 = n17;
                        }
                        if (n12 > n4) {
                            n4 = n12;
                        }
                        if (n13 <= n4) break;
                        n4 = n13;
                    }
                }
                this.pixels[n7++] = (byte)n4;
                ++n14;
            }
            if (n6 % n2 == 0) {
                this.showProgress((double)(n6 - this.roiY) / (double)this.roiHeight);
            }
            ++n6;
        }
        this.hideProgress();
    }

    public void erode() {
        if (this.isInvertedLut()) {
            this.filter(3);
        } else {
            this.filter(4);
        }
    }

    public void dilate() {
        if (this.isInvertedLut()) {
            this.filter(4);
        } else {
            this.filter(3);
        }
    }

    public void outline() {
        new BinaryProcessor(this).outline();
    }

    public void skeletonize() {
        new BinaryProcessor(this).skeletonize();
    }

    private final int findMedian(int[] nArray) {
        int n;
        int n2;
        int n3 = 1;
        while (n3 <= 4) {
            n2 = 0;
            n = 1;
            int n4 = 1;
            while (n4 <= 9) {
                if (nArray[n4] > n2) {
                    n2 = nArray[n4];
                    n = n4;
                }
                ++n4;
            }
            nArray[n] = 0;
            ++n3;
        }
        n2 = 0;
        n = 1;
        while (n <= 9) {
            if (nArray[n] > n2) {
                n2 = nArray[n];
            }
            ++n;
        }
        return n2;
    }

    public void medianFilter() {
        this.filter(2);
    }

    public void noise(double d) {
        Random random = new Random();
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = n * this.width + this.roiX;
            int n3 = this.roiX;
            while (n3 < this.roiX + this.roiWidth) {
                int n4 = (int)Math.round(random.nextGaussian() * d);
                int n5 = (this.pixels[n2] & 0xFF) + n4;
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > 255) {
                    n5 = 255;
                }
                this.pixels[n2] = (byte)n5;
                ++n2;
                ++n3;
            }
            if (n % 10 == 0) {
                this.showProgress((double)(n - this.roiY) / (double)this.roiHeight);
            }
            ++n;
        }
        this.hideProgress();
    }

    public void scale(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4;
        double d3 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d4 = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (this.isInvertedLut()) {
            this.bgColor = 0;
        }
        if (d > 1.0 && d2 > 1.0) {
            n4 = (int)(d3 - (d3 - (double)this.roiX) * d);
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + (int)((double)this.roiWidth * d) - 1) >= this.width) {
                n3 = this.width - 1;
            }
            if ((n2 = (int)(d4 - (d4 - (double)this.roiY) * d2)) < 0) {
                n2 = 0;
            }
            if ((n = n2 + (int)((double)this.roiHeight * d2) - 1) >= this.height) {
                n = this.height - 1;
            }
        } else {
            n4 = this.roiX;
            n3 = this.roiX + this.roiWidth - 1;
            n2 = this.roiY;
            n = this.roiY + this.roiHeight - 1;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        boolean bl = d < 1.0 || d2 < 1.0;
        double d5 = (double)this.width - 1.0;
        double d6 = (double)this.width - 1.001;
        double d7 = (double)this.height - 1.0;
        double d8 = (double)this.height - 1.001;
        int n5 = n2;
        while (n5 <= n) {
            double d9 = ((double)n5 - d4) / d2 + d4;
            int n6 = (int)d9;
            if (d9 < 0.0) {
                d9 = 0.0;
            }
            if (d9 >= d7) {
                d9 = d8;
            }
            int n7 = n5 * this.width + n4;
            int n8 = this.width * (int)d9;
            int n9 = n4;
            while (n9 <= n3) {
                double d10 = ((double)n9 - d3) / d + d3;
                int n10 = (int)d10;
                if (bl && (n10 < n4 || n10 > n3 || n6 < n2 || n6 > n)) {
                    this.pixels[n7++] = (byte)this.bgColor;
                } else if (this.interpolate) {
                    if (d10 < 0.0) {
                        d10 = 0.0;
                    }
                    if (d10 >= d5) {
                        d10 = d6;
                    }
                    this.pixels[n7++] = (byte)((int)(this.getInterpolatedPixel(d10, d9, byArray) + 0.5) & 0xFF);
                } else {
                    this.pixels[n7++] = byArray[n8 + n10];
                }
                ++n9;
            }
            if (n5 % 20 == 0) {
                this.showProgress((double)(n5 - n2) / (double)this.height);
            }
            ++n5;
        }
        this.hideProgress();
    }

    private final double getInterpolatedPixel(double d, double d2, byte[] byArray) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        int n4 = byArray[n3] & 0xFF;
        int n5 = byArray[n3 + 1] & 0xFF;
        int n6 = byArray[n3 + this.width + 1] & 0xFF;
        int n7 = byArray[n3 + this.width] & 0xFF;
        double d5 = (double)n7 + d3 * (double)(n6 - n7);
        double d6 = (double)n4 + d3 * (double)(n5 - n4);
        return d6 + d4 * (d5 - d6);
    }

    public ImageProcessor resize(int n, int n2) {
        if (this.roiWidth == n && this.roiHeight == n2) {
            return this.crop();
        }
        double d = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d2 = (double)this.roiY + (double)this.roiHeight / 2.0;
        double d3 = (double)n / 2.0;
        double d4 = (double)n2 / 2.0;
        double d5 = (double)n / (double)this.roiWidth;
        double d6 = (double)n2 / (double)this.roiHeight;
        if (this.interpolate) {
            d3 += d5 / 2.0;
            d4 += d6 / 2.0;
        }
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        double d7 = (double)this.width - 1.0;
        double d8 = (double)this.width - 1.001;
        double d9 = (double)this.height - 1.0;
        double d10 = (double)this.height - 1.001;
        int n3 = 0;
        while (n3 <= n2 - 1) {
            double d11 = ((double)n3 - d4) / d6 + d2;
            if (this.interpolate) {
                if (d11 < 0.0) {
                    d11 = 0.0;
                }
                if (d11 >= d9) {
                    d11 = d10;
                }
            }
            int n4 = this.width * (int)d11;
            int n5 = n3 * n;
            int n6 = 0;
            while (n6 <= n - 1) {
                double d12 = ((double)n6 - d3) / d5 + d;
                if (this.interpolate) {
                    if (d12 < 0.0) {
                        d12 = 0.0;
                    }
                    if (d12 >= d7) {
                        d12 = d8;
                    }
                    byArray[n5++] = (byte)((int)(this.getInterpolatedPixel(d12, d11, this.pixels) + 0.5) & 0xFF);
                } else {
                    byArray[n5++] = this.pixels[n4 + (int)d12];
                }
                ++n6;
            }
            if (n3 % 20 == 0) {
                this.showProgress((double)n3 / (double)n2);
            }
            ++n3;
        }
        this.hideProgress();
        return imageProcessor;
    }

    public void rotate(double d) {
        if (d % 360.0 == 0.0) {
            return;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        double d2 = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double d3 = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int n = this.roiX + this.roiWidth - 1;
        if (this.isInvertedLut()) {
            this.bgColor = 0;
        }
        double d4 = -d / 57.29577951308232;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d3 * d6 - d2 * d5;
        double d8 = -d2 * d6 - d3 * d5;
        double d9 = this.width;
        double d10 = this.height;
        double d11 = (double)this.width - 1.0;
        double d12 = (double)this.width - 1.001;
        double d13 = (double)this.height - 1.0;
        double d14 = (double)this.height - 1.001;
        int n2 = this.roiY;
        while (n2 < this.roiY + this.roiHeight) {
            int n3 = n2 * this.width + this.roiX;
            double d15 = d7 - (double)n2 * d6 + d2;
            double d16 = d8 + (double)n2 * d5 + d3;
            int n4 = this.roiX;
            while (n4 <= n) {
                double d17 = (double)n4 * d5 + d15;
                double d18 = (double)n4 * d6 + d16;
                if (d17 >= -0.01 && d17 < d9 && d18 >= -0.01 && d18 < d10) {
                    if (this.interpolate) {
                        if (d17 < 0.0) {
                            d17 = 0.0;
                        }
                        if (d17 >= d11) {
                            d17 = d12;
                        }
                        if (d18 < 0.0) {
                            d18 = 0.0;
                        }
                        if (d18 >= d13) {
                            d18 = d14;
                        }
                        this.pixels[n3++] = (byte)((int)(this.getInterpolatedPixel(d17, d18, byArray) + 0.5) & 0xFF);
                    } else {
                        int n5 = (int)(d17 + 0.5);
                        int n6 = (int)(d18 + 0.5);
                        if (n5 >= this.width) {
                            n5 = this.width - 1;
                        }
                        if (n6 >= this.height) {
                            n6 = this.height - 1;
                        }
                        this.pixels[n3++] = byArray[this.width * n6 + n5];
                    }
                } else {
                    this.pixels[n3++] = (byte)this.bgColor;
                }
                ++n4;
            }
            if (n2 % 30 == 0) {
                this.showProgress((double)(n2 - this.roiY) / (double)this.roiHeight);
            }
            ++n2;
        }
        this.hideProgress();
    }

    public void flipVertical() {
        int n = 0;
        while (n < this.roiHeight / 2) {
            int n2 = (this.roiY + n) * this.width + this.roiX;
            int n3 = (this.roiY + this.roiHeight - 1 - n) * this.width + this.roiX;
            int n4 = 0;
            while (n4 < this.roiWidth) {
                byte by = this.pixels[n2];
                this.pixels[n2++] = this.pixels[n3];
                this.pixels[n3++] = by;
                ++n4;
            }
            ++n;
        }
        this.newSnapshot = false;
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] nArray = new int[256];
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = n * this.width + this.roiX;
            int n3 = this.roiX;
            while (n3 < this.roiX + this.roiWidth) {
                int n4;
                int n5 = n4 = this.pixels[n2++] & 0xFF;
                nArray[n5] = nArray[n5] + 1;
                ++n3;
            }
            ++n;
        }
        return nArray;
    }

    public int[] getHistogram(int[] nArray) {
        int[] nArray2 = new int[256];
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] == -16777216) {
                    int n6;
                    int n7 = n6 = this.pixels[n3] & 0xFF;
                    nArray2[n7] = nArray2[n7] + 1;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
        return nArray2;
    }

    public void threshold(int n) {
        int n2 = 0;
        while (n2 < this.width * this.height) {
            this.pixels[n2] = (this.pixels[n2] & 0xFF) <= n ? 0 : -1;
            ++n2;
        }
        this.newSnapshot = false;
    }

    public void applyLut() {
        if (this.rLUT2 == null) {
            return;
        }
        if (this.isInvertedLut()) {
            int n = 0;
            while (n < this.width * this.height) {
                this.pixels[n] = (byte)(255 - this.rLUT2[this.pixels[n] & 0xFF]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.width * this.height) {
                this.pixels[n] = this.rLUT2[this.pixels[n] & 0xFF];
                ++n;
            }
        }
        this.setMinAndMax(0.0, 255.0);
    }

    public void convolve(float[] fArray, int n, int n2) {
        ImageProcessor imageProcessor = this.convertToFloat();
        imageProcessor.setRoi(this.getRoi());
        new Convolver().convolve(imageProcessor, fArray, n, n2);
        imageProcessor = imageProcessor.convertToByte(false);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        System.arraycopy(byArray, 0, this.pixels, 0, this.pixels.length);
    }
}

