/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.SaveChangesDialog;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.PlugInFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Properties;

public class Editor
extends PlugInFrame
implements ActionListener,
TextListener,
ClipboardOwner,
MacroConstants {
    public static final int MAX_SIZE = 28000;
    public static final int MAX_MACROS = 50;
    public static final int XINC = 10;
    public static final int YINC = 18;
    private TextArea ta;
    private String path;
    private boolean changes;
    private static String searchString = "";
    private static int lineNumber = 1;
    private static int xoffset;
    private static int yoffset;
    private static int nWindows;
    private Menu fileMenu;
    private Properties p = new Properties();
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb = new MenuBar();
    private Menu macrosMenu;
    private int nMacros;
    private Program pgm;
    private boolean firstEvent = true;
    private String shortcutsInUse;
    private int inUseCount;
    private int nShortcuts;
    private MacroInstaller installer;
    static /* synthetic */ Class class$ij$plugin$frame$Editor;

    public Editor() {
        super("Editor");
        WindowManager.addWindow(this);
        Menu menu = new Menu("File");
        menu.add(new MenuItem("Save", new MenuShortcut(83)));
        menu.add(new MenuItem("Save As..."));
        menu.add(new MenuItem("Print...", new MenuShortcut(80)));
        menu.addSeparator();
        menu.add(new MenuItem("Compile and Run", new MenuShortcut(82)));
        menu.addActionListener(this);
        this.fileMenu = menu;
        this.mb.add(menu);
        menu = new Menu("Edit");
        String string = IJ.isMacintosh() ? " = Cmd " : " = Ctrl+";
        MenuItem menuItem = new MenuItem("Undo" + string + "Z");
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menu.addSeparator();
        boolean bl = IJ.isWindows() && System.getProperty("java.version").indexOf("1.1.8") >= 0;
        menuItem = bl ? new MenuItem("Cut") : new MenuItem("Cut", new MenuShortcut(88));
        menu.add(menuItem);
        menuItem = bl ? new MenuItem("Copy") : new MenuItem("Copy", new MenuShortcut(67));
        menu.add(menuItem);
        menuItem = bl ? new MenuItem("Paste") : new MenuItem("Paste", new MenuShortcut(86));
        menu.add(menuItem);
        menu.addSeparator();
        menu.add(new MenuItem("Find...", new MenuShortcut(70)));
        menu.add(new MenuItem("Find Next", new MenuShortcut(71)));
        menu.add(new MenuItem("Go to Line...", new MenuShortcut(76)));
        menu.addActionListener(this);
        this.mb.add(menu);
        this.setMenuBar(this.mb);
        this.ta = new TextArea(16, 60);
        this.ta.addTextListener(this);
        if (IJ.isMacOSX()) {
            this.ta.setFont(new Font("SansSerif", 0, 12));
        }
        this.addKeyListener(IJ.getInstance());
        this.add(this.ta);
        this.pack();
        this.positionWindow();
        this.display("Test.java", "");
        IJ.register(class$ij$plugin$frame$Editor == null ? (class$ij$plugin$frame$Editor = Editor.class$("ij.plugin.frame.Editor")) : class$ij$plugin$frame$Editor);
    }

    public void positionWindow() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.width == 0) {
            return;
        }
        int n = dimension.width / 2 - dimension2.width / 2;
        int n2 = (dimension.height - dimension2.height) / 4;
        if (n2 < 0) {
            n2 = 0;
        }
        if (nWindows <= 0 || xoffset > 80) {
            xoffset = 0;
            yoffset = 0;
        }
        ((Component)this).setLocation(n + xoffset, n2 + yoffset);
        xoffset += 10;
        yoffset += 18;
        ++nWindows;
    }

    void setWindowTitle(String string) {
        Menus.updateWindowMenuItem(this.getTitle(), string);
        this.setTitle(string);
    }

    public void create(String string, String string2) {
        this.ta.append(string2);
        this.ta.setCaretPosition(0);
        this.setWindowTitle(string);
        if (!string.endsWith(".java")) {
            this.fileMenu.remove(4);
            this.fileMenu.insert(new MenuItem("Run Macro", new MenuShortcut(82)), 4);
            int n = this.fileMenu.getItemCount();
            if (n == 5) {
                this.fileMenu.insert(new MenuItem("Abort Macro"), 5);
            }
            this.macrosMenu = new Menu("Macros");
            this.macrosMenu.add(new MenuItem("Install Macros", new MenuShortcut(73)));
            this.macrosMenu.addSeparator();
            this.macrosMenu.addActionListener(this);
            this.mb.add(this.macrosMenu);
            if (string2.indexOf("macro ") != -1) {
                this.installMacros(string2, false);
            }
        }
        this.show();
        this.changes = false;
    }

    void installMacros(String string, boolean bl) {
        this.installer = new MacroInstaller();
        this.installer.setFileName(this.getTitle());
        int n = this.installer.install(string, this.macrosMenu);
        if (bl || n > 0) {
            this.installer.install(null);
        }
    }

    public void open(String string, String string2) {
        this.path = string + string2;
        File file = new File(this.path);
        int n = (int)file.length();
        if (n > 28000 && !IJ.isJava2() && !IJ.isMacintosh()) {
            IJ.error("This file is too large for ImageJ to open.\n \n\t  File size: " + n + " bytes\n" + "\t  Max. size: " + 28000 + " bytes");
            this.dispose();
            return;
        }
        try {
            String string3;
            StringBuffer stringBuffer = new StringBuffer(5000);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\n");
            }
            bufferedReader.close();
            this.create(string2, new String(stringBuffer));
            this.changes = false;
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return;
        }
    }

    public String getText() {
        if (this.ta == null) {
            return "";
        }
        return this.ta.getText();
    }

    public void display(String string, String string2) {
        this.ta.selectAll();
        this.ta.replaceRange(string2, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.ta.setCaretPosition(0);
        this.setWindowTitle(string);
        this.changes = false;
        this.show();
    }

    void save() {
        if (this.path == null) {
            this.saveAs();
            return;
        }
        String string = this.ta.getText();
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new CharArrayReader(cArray));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.path));
            while ((string2 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            IJ.showStatus(string.length() + " chars saved to " + this.path);
            this.changes = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void compileAndRun() {
        if (this.path == null) {
            this.saveAs();
        }
        if (this.path != null) {
            this.save();
            IJ.runPlugIn("ij.plugin.Compiler", this.path);
        }
    }

    void runMacro() {
        int n;
        int n2 = this.ta.getSelectionStart();
        String string = n2 == (n = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        new MacroRunner(string);
    }

    void print() {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this, "Cool Stuff", this.p);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                String string = this.ta.getText();
                this.printString(printJob, graphics, string);
                graphics.dispose();
            }
            printJob.end();
        }
    }

    void printString(PrintJob printJob, Graphics graphics, String string) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 30;
        int n5 = 30;
        int n6 = 30;
        if (!(graphics instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics contextt not PrintGraphics");
        }
        if (IJ.isMacintosh()) {
            n4 = 0;
            n5 = 0;
            n6 = 0;
        }
        StringReader stringReader = new StringReader(string);
        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
        int n7 = printJob.getPageDimension().height - n6;
        Font font = new Font("Helvetica", 0, 10);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getDescent();
        int n10 = n4;
        try {
            String string2;
            do {
                if ((string2 = lineNumberReader.readLine()) == null) continue;
                string2 = this.detabLine(string2);
                if (n10 + n8 > n7) {
                    ++n;
                    n2 = 0;
                    graphics.dispose();
                    graphics = printJob.getGraphics();
                    if (graphics != null) {
                        graphics.setFont(font);
                    }
                    n10 = n4;
                }
                n10 += n8;
                if (graphics == null) continue;
                graphics.drawString(string2, n5, n10 - n9);
                ++n2;
                ++n3;
            } while (string2 != null);
        }
        catch (EOFException eOFException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    String detabLine(String string) {
        if (string.indexOf(9) < 0) {
            return string;
        }
        int n = 4;
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.25));
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\t') {
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(' ');
                    ++n3;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    boolean copy() {
        String string = this.ta.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        if (clipboard != null) {
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, this);
            return true;
        }
        return false;
    }

    void cut() {
        if (this.copy()) {
            int n = this.ta.getSelectionStart();
            int n2 = this.ta.getSelectionEnd();
            this.ta.replaceRange("", n, n2);
            if (IJ.isMacOSX()) {
                this.ta.setCaretPosition(n);
            }
        }
    }

    void paste() {
        String string = this.ta.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(string);
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        int n = this.ta.getSelectionStart();
        int n2 = this.ta.getSelectionEnd();
        this.ta.replaceRange(string, n, n2);
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(n + string.length());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Save".equals(string)) {
            this.save();
        } else if ("Compile and Run".equals(string)) {
            this.compileAndRun();
        } else if ("Run Macro".equals(string)) {
            this.runMacro();
        } else if ("Abort Macro".equals(string)) {
            Interpreter.abort();
            IJ.beep();
        } else if ("Install Macros".equals(string)) {
            this.installMacros(this.ta.getText(), true);
        } else if ("Print...".equals(string)) {
            this.print();
        } else if ("Paste".equals(string)) {
            this.paste();
        } else if ("Copy".equals(string)) {
            this.copy();
        } else if ("Cut".equals(string)) {
            this.cut();
        } else if ("Save As...".equals(string)) {
            this.saveAs();
        } else if ("Find...".equals(string)) {
            this.find(null);
        } else if ("Find Next".equals(string)) {
            this.find(searchString);
        } else if ("Go to Line...".equals(string)) {
            this.gotoLine();
        } else {
            this.installer.runMacro(string);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.firstEvent) {
            this.firstEvent = false;
        } else {
            this.changes = true;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        WindowManager.setWindow(this);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void close() {
        boolean bl = true;
        if (!this.getTitle().equals("Errors") && this.changes) {
            SaveChangesDialog saveChangesDialog = new SaveChangesDialog((Frame)this, this.getTitle());
            if (saveChangesDialog.cancelPressed()) {
                bl = false;
            } else if (saveChangesDialog.savePressed()) {
                this.save();
            }
        }
        if (bl) {
            ((Component)this).setVisible(false);
            this.dispose();
            WindowManager.removeWindow(this);
            --nWindows;
        }
    }

    void saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save Plugin As...", 1);
        String string = this.getTitle();
        fileDialog.setFile(string);
        String string2 = Menus.getPlugInsPath();
        if (this.path != null) {
            fileDialog.setDirectory(string2);
        }
        fileDialog.show();
        String string3 = fileDialog.getFile();
        String string4 = fileDialog.getDirectory();
        fileDialog.dispose();
        if (string3 != null) {
            if (string3.endsWith(".java")) {
                this.updateClassName(string, string3);
            }
            this.path = string4 + string3;
            this.save();
            this.changes = false;
            this.setWindowTitle(string3);
        }
    }

    void updateClassName(String string, String string2) {
        if (string2.indexOf("_") < 0) {
            IJ.showMessage("Plugin Editor", "Plugins without an underscore in their name will not\nbe automatically installed when ImageJ is restarted.");
        }
        if (string.equals(string2) || !string.endsWith(".java") || !string2.endsWith(".java")) {
            return;
        }
        string = string.substring(0, string.length() - 5);
        string2 = string2.substring(0, string2.length() - 5);
        String string3 = this.ta.getText();
        int n = string3.indexOf("public class " + string);
        if (n < 0) {
            return;
        }
        String string4 = string3.substring(0, n + 13) + string2 + string3.substring(n + 13 + string.length(), string3.length());
        this.ta.setText(string4);
    }

    void find(String string) {
        Object object;
        if (string == null) {
            object = new GenericDialog("Find", this);
            ((GenericDialog)object).addStringField("Find: ", searchString, 20);
            ((GenericDialog)object).showDialog();
            if (((GenericDialog)object).wasCanceled()) {
                return;
            }
            string = ((GenericDialog)object).getNextString();
        }
        if (string.equals("")) {
            return;
        }
        object = this.ta.getText();
        int n = ((String)object).indexOf(string, this.ta.getCaretPosition() + 1);
        if (n < 0) {
            IJ.beep();
            return;
        }
        this.ta.setSelectionStart(n);
        this.ta.setSelectionEnd(n + string.length());
        searchString = string;
    }

    void gotoLine() {
        GenericDialog genericDialog = new GenericDialog("Go to Line", this);
        genericDialog.addNumericField("Go to line number: ", lineNumber, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = (int)genericDialog.getNextNumber();
        if (n < 1) {
            return;
        }
        String string = this.ta.getText();
        char[] cArray = new char[string.length()];
        cArray = string.toCharArray();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            if (cArray[n4] == '\n') {
                ++n2;
            }
            if (n2 == n) {
                n3 = n4 + 1;
                break;
            }
            ++n4;
        }
        this.ta.setCaretPosition(n3);
        lineNumber = n;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

