/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

public class SplineFitter {
    private double[] y2;

    public SplineFitter(int[] nArray, int[] nArray2, int n) {
        this.initSpline(nArray, nArray2, n);
    }

    void initSpline(int[] nArray, int[] nArray2, int n) {
        this.y2 = new double[n];
        double[] dArray = new double[n];
        int n2 = 1;
        while (n2 < n - 1) {
            double d = ((double)nArray[n2] - (double)nArray[n2 - 1]) / ((double)nArray[n2 + 1] - (double)nArray[n2 - 1]);
            double d2 = d * this.y2[n2 - 1] + 2.0;
            this.y2[n2] = (d - 1.0) / d2;
            dArray[n2] = ((double)nArray2[n2 + 1] - (double)nArray2[n2]) / (double)(nArray[n2 + 1] - nArray[n2]) - ((double)nArray2[n2] - (double)nArray2[n2 - 1]) / (double)(nArray[n2] - nArray[n2 - 1]);
            dArray[n2] = (6.0 * dArray[n2] / (double)(nArray[n2 + 1] - nArray[n2 - 1]) - d * dArray[n2 - 1]) / d2;
            ++n2;
        }
        double d = 0.0;
        double d3 = 0.0;
        this.y2[n - 1] = (d - d3 * dArray[n - 2]) / (d3 * this.y2[n - 2] + 1.0);
        int n3 = n - 2;
        while (n3 >= 0) {
            this.y2[n3] = this.y2[n3] * this.y2[n3 + 1] + dArray[n3];
            --n3;
        }
    }

    public double evalSpline(int[] nArray, int[] nArray2, int n, double d) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 - n2 > 1) {
            int n4 = n3 + n2 >> 1;
            if ((double)nArray[n4] > d) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        double d2 = nArray[n3] - nArray[n2];
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = ((double)nArray[n3] - d) / d2;
        double d4 = (d - (double)nArray[n2]) / d2;
        if (this.y2 == null) {
            return 0.0;
        }
        return d3 * (double)nArray2[n2] + d4 * (double)nArray2[n3] + ((d3 * d3 * d3 - d3) * this.y2[n2] + (d4 * d4 * d4 - d4) * this.y2[n3]) * (d2 * d2) / 6.0;
    }
}

