/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PlotWindow;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Variable;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Info;
import ij.plugin.frame.Editor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class Functions
implements MacroConstants,
Measurements {
    Interpreter interp;
    Program pgm;
    boolean updateNeeded;
    boolean autoUpdate = true;
    ImagePlus imp;
    ImageProcessor ip;
    int imageType;
    boolean colorSet;
    Random ran;

    Functions(Interpreter interpreter, Program program) {
        this.interp = interpreter;
        this.pgm = program;
        Variable.doHash = false;
    }

    void doFunction(int n) {
        switch (n) {
            case 300: {
                this.doRun();
                break;
            }
            case 302: {
                IJ.selectWindow(this.getStringArg());
                this.resetImage();
                break;
            }
            case 303: {
                IJ.wait((int)this.getArg());
                break;
            }
            case 304: {
                this.interp.getParens();
                IJ.beep();
                break;
            }
            case 305: {
                this.interp.getParens();
                IJ.resetMinAndMax();
                this.resetImage();
                break;
            }
            case 306: {
                this.interp.getParens();
                IJ.resetThreshold();
                this.resetImage();
                break;
            }
            case 307: {
                IJ.log(this.getStringArg());
                break;
            }
            case 308: {
                IJ.write(this.getStringArg());
                break;
            }
            case 309: {
                IJ.doWand((int)this.getFirstArg(), (int)this.getLastArg());
                this.resetImage();
                break;
            }
            case 310: {
                IJ.setMinAndMax(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 311: {
                IJ.setThreshold(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 312: {
                IJ.setTool((int)this.getArg());
                break;
            }
            case 313: {
                this.setForegroundColor();
                break;
            }
            case 314: {
                this.setBackgroundColor();
                break;
            }
            case 336: {
                this.setColor();
                break;
            }
            case 315: {
                this.makeLine();
                break;
            }
            case 316: {
                this.makeOval();
                break;
            }
            case 317: {
                this.makeRectangle();
                break;
            }
            case 318: {
                this.interp.dump();
                break;
            }
            case 320: {
                this.lineTo();
                break;
            }
            case 319: {
                this.moveTo();
                break;
            }
            case 321: {
                this.drawLine();
                break;
            }
            case 322: {
                this.requires();
                break;
            }
            case 323: {
                this.autoUpdate = this.getBooleanArg();
                break;
            }
            case 324: {
                this.interp.getParens();
                this.updateDisplay();
                break;
            }
            case 325: {
                this.drawString();
                break;
            }
            case 326: {
                IJ.setPasteMode(this.getStringArg());
                break;
            }
            case 327: {
                IJ.doCommand(this.getStringArg());
                break;
            }
            case 328: {
                IJ.showStatus(this.getStringArg());
                this.interp.statusUpdated = true;
                break;
            }
            case 329: {
                this.showProgress();
                break;
            }
            case 330: {
                this.showMessage(false);
                break;
            }
            case 352: {
                this.showMessage(true);
                break;
            }
            case 331: 
            case 332: {
                this.setPixel();
                break;
            }
            case 333: 
            case 334: 
            case 335: {
                this.doIPMethod(n);
                break;
            }
            case 337: {
                this.getProcessor().setLineWidth((int)this.getArg());
                break;
            }
            case 338: {
                this.changeValues();
                break;
            }
            case 339: {
                IJ.selectWindow((int)this.getArg());
                this.resetImage();
                break;
            }
            case 340: {
                this.exit();
                break;
            }
            case 341: {
                ((Component)this.getImage().getWindow()).setLocation((int)this.getFirstArg(), (int)this.getLastArg());
            }
            case 342: {
                this.getCursorLoc();
                break;
            }
            case 343: {
                this.getLine();
                break;
            }
            case 344: {
                this.getVoxelSize();
                break;
            }
            case 345: {
                this.getHistogram();
                break;
            }
            case 346: {
                this.getStatistics();
                break;
            }
            case 347: {
                this.graph();
                break;
            }
            case 348: {
                this.getBoundingRect();
                break;
            }
            case 349: {
                this.getLut();
                break;
            }
            case 350: {
                this.setLut();
                break;
            }
            case 351: {
                this.getCoordinates();
            }
        }
    }

    final double getFunctionValue(int n) {
        double d = 0.0;
        switch (n) {
            case 1000: {
                d = this.getPixel();
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1027: {
                d = this.math(n);
                break;
            }
            case 1006: 
            case 1007: 
            case 1008: {
                d = this.math2(n);
                break;
            }
            case 1013: {
                this.interp.getParens();
                d = System.currentTimeMillis();
                break;
            }
            case 1014: {
                this.interp.getParens();
                d = this.getImage().getWidth();
                break;
            }
            case 1015: {
                this.interp.getParens();
                d = this.getImage().getHeight();
                break;
            }
            case 1016: {
                d = this.random();
                break;
            }
            case 1018: 
            case 1023: {
                d = this.getResultsCount();
                break;
            }
            case 1017: {
                d = this.getResult();
                break;
            }
            case 1019: {
                d = this.getNumber();
                break;
            }
            case 1020: {
                d = this.getImageCount();
                break;
            }
            case 1021: {
                d = this.getStackSize();
                break;
            }
            case 1022: {
                d = this.lengthOf();
                break;
            }
            case 1024: {
                this.interp.getParens();
                d = this.getImage().getID();
                break;
            }
            case 1025: {
                this.interp.getParens();
                d = this.getImage().getBitDepth();
                break;
            }
            case 1026: {
                d = this.getSelectionType();
                break;
            }
            case 1028: {
                d = this.isOpen();
                break;
            }
            case 1029: {
                d = this.isActive();
                break;
            }
            case 1030: {
                d = this.indexOf();
                break;
            }
            case 1031: {
                d = this.getFirstStringArg().lastIndexOf(this.getLastStringArg());
                break;
            }
            case 1032: {
                d = this.getFirstStringArg().charAt((int)this.getLastArg());
                break;
            }
            default: {
                this.interp.error("Numeric function expected");
            }
        }
        return d;
    }

    String getStringFunction(int n) {
        String string;
        switch (n) {
            case 2000: {
                string = this.d2s();
                break;
            }
            case 2001: {
                string = this.toString(16);
                break;
            }
            case 2002: {
                string = this.toString(2);
                break;
            }
            case 2003: {
                this.interp.getParens();
                string = this.getImage().getTitle();
                break;
            }
            case 2004: {
                string = this.getStringDialog();
                break;
            }
            case 2005: {
                string = this.substring();
                break;
            }
            case 2006: {
                string = this.fromCharCode();
                break;
            }
            case 2007: {
                string = this.getInfo();
                break;
            }
            default: {
                string = "";
                this.interp.error("String function expected");
            }
        }
        return string;
    }

    Variable[] getArrayFunction(int n) {
        Variable[] variableArray;
        switch (n) {
            case 3000: {
                variableArray = this.getProfile();
                break;
            }
            case 3001: {
                variableArray = this.newArray();
                break;
            }
            case 3002: {
                variableArray = this.split();
                break;
            }
            default: {
                variableArray = null;
                this.interp.error("Array function expected");
            }
        }
        return variableArray;
    }

    final double math(int n) {
        double d = this.getArg();
        switch (n) {
            case 1001: {
                return Math.abs(d);
            }
            case 1002: {
                return Math.cos(d);
            }
            case 1003: {
                return Math.exp(d);
            }
            case 1004: {
                return Math.floor(d);
            }
            case 1005: {
                return Math.log(d);
            }
            case 1009: {
                return Math.round(d);
            }
            case 1010: {
                return Math.sin(d);
            }
            case 1011: {
                return Math.sqrt(d);
            }
            case 1012: {
                return Math.tan(d);
            }
            case 1027: {
                return Math.atan(d);
            }
        }
        return 0.0;
    }

    final double math2(int n) {
        double d = this.getFirstArg();
        double d2 = this.getLastArg();
        switch (n) {
            case 1007: {
                return Math.min(d, d2);
            }
            case 1006: {
                return Math.max(d, d2);
            }
            case 1008: {
                return Math.pow(d, d2);
            }
        }
        return 0.0;
    }

    final String getString() {
        String string = this.interp.getStringTerm();
        while (true) {
            this.interp.getToken();
            if (this.interp.token != 43) break;
            string = string + this.interp.getStringTerm();
        }
        this.interp.putTokenBack();
        return string;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.interp.tokenAddress];
        return symbol.type == 2000;
    }

    final double getArg() {
        this.interp.getLeftParen();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        return d;
    }

    final double getFirstArg() {
        this.interp.getLeftParen();
        return this.interp.getExpression();
    }

    final double getNextArg() {
        this.interp.getComma();
        return this.interp.getExpression();
    }

    final double getLastArg() {
        this.interp.getComma();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        return d;
    }

    String getStringArg() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getRightParen();
        return string;
    }

    final String getFirstStringArg() {
        this.interp.getLeftParen();
        return this.getString();
    }

    final String getNextStringArg() {
        this.interp.getComma();
        return this.getString();
    }

    final String getLastStringArg() {
        this.interp.getComma();
        String string = this.getString();
        this.interp.getRightParen();
        return string;
    }

    boolean getBooleanArg() {
        this.interp.getLeftParen();
        double d = this.interp.getBooleanExpression();
        this.interp.checkBoolean(d);
        this.interp.getRightParen();
        return d != 0.0;
    }

    final Variable getFirstVariable() {
        this.interp.getLeftParen();
        return this.getVariable();
    }

    final Variable getNextVariable() {
        this.interp.getComma();
        return this.getVariable();
    }

    final Variable getLastVariable() {
        this.interp.getComma();
        Variable variable = this.getVariable();
        this.interp.getRightParen();
        return variable;
    }

    final Variable getVariable() {
        Variable[] variableArray;
        Variable variable;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((variable = this.interp.lookupVariable(this.interp.tokenAddress)) == null) {
            variable = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        if ((variableArray = variable.getArray()) != null) {
            int n = this.interp.getIndex();
            this.checkIndex(n, 0, variableArray.length - 1);
            variable = variableArray[n];
        }
        return variable;
    }

    final Variable getFirstArrayVariable() {
        this.interp.getLeftParen();
        return this.getArrayVariable();
    }

    final Variable getNextArrayVariable() {
        this.interp.getComma();
        return this.getArrayVariable();
    }

    final Variable getLastArrayVariable() {
        this.interp.getComma();
        Variable variable = this.getArrayVariable();
        this.interp.getRightParen();
        return variable;
    }

    final Variable getArrayVariable() {
        Variable variable;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((variable = this.interp.lookupVariable(this.interp.tokenAddress)) == null) {
            variable = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        return variable;
    }

    final double[] getFirstArray() {
        this.interp.getLeftParen();
        return this.getArray();
    }

    final double[] getNextArray() {
        this.interp.getComma();
        return this.getArray();
    }

    final double[] getLastArray() {
        this.interp.getComma();
        double[] dArray = this.getArray();
        this.interp.getRightParen();
        return dArray;
    }

    double[] getArray() {
        Variable[] variableArray;
        Variable variable;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Array expected");
        }
        if ((variable = this.interp.lookupVariable(this.interp.tokenAddress)) == null) {
            this.interp.error("Undefined variable");
        }
        if ((variableArray = variable.getArray()) == null) {
            this.interp.error("Array expected");
        }
        double[] dArray = new double[variableArray.length];
        int n = 0;
        while (n < variableArray.length) {
            dArray[n] = variableArray[n].getValue();
            ++n;
        }
        return dArray;
    }

    void checkIndex(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            this.interp.error("Index (" + n + ") is outside of the " + n2 + "-" + n3 + " range");
        }
    }

    void doRun() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getToken();
        if (this.interp.token != 41 && this.interp.token != 44) {
            this.interp.error("',' or ')'  expected");
        }
        String string2 = null;
        if (this.interp.token == 44) {
            string2 = this.getString();
            this.interp.getRightParen();
        }
        if (string2 != null) {
            IJ.run(string, string2);
        } else {
            IJ.run(string);
        }
        this.resetImage();
    }

    void setForegroundColor() {
        IJ.setForegroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setBackgroundColor() {
        IJ.setBackgroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setColor() {
        double d = this.getFirstArg();
        this.colorSet = true;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            this.setColor(d);
            return;
        }
        int n = (int)d;
        int n2 = (int)this.getNextArg();
        int n3 = (int)this.getLastArg();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        Color color = new Color(n, n2, n3);
        this.getProcessor().setColor(color);
    }

    void setColor(double d) {
        ImageProcessor imageProcessor = this.getProcessor();
        switch (this.imp.getBitDepth()) {
            case 8: {
                if (d < 0.0 || d > 255.0) {
                    this.interp.error("Argument out of 8-bit range (0-255)");
                }
                imageProcessor.setValue(d);
                break;
            }
            case 16: {
                if (d < 0.0 || d > 65535.0) {
                    this.interp.error("Argument out of 16-bit range (0-65535)");
                }
                imageProcessor.setValue(d);
                break;
            }
            default: {
                imageProcessor.setValue(d);
            }
        }
    }

    void makeLine() {
        IJ.makeLine((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void makeOval() {
        IJ.makeOval((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void makeRectangle() {
        IJ.makeRectangle((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    ImagePlus getImage() {
        if (this.imp == null) {
            this.imp = IJ.getImage();
        }
        if (this.imp.getWindow() == null) {
            throw new RuntimeException("Macro canceled");
        }
        return this.imp;
    }

    void resetImage() {
        this.imp = null;
        this.ip = null;
    }

    ImageProcessor getProcessor() {
        if (this.ip == null) {
            this.ip = this.getImage().getProcessor();
        }
        return this.ip;
    }

    int getType() {
        if (this.imp == null) {
            this.imp = IJ.getImage();
        }
        this.imageType = this.imp.getType();
        return this.imageType;
    }

    double getPixel() {
        this.interp.getLeftParen();
        int n = (int)this.interp.getExpression();
        this.interp.getComma();
        int n2 = (int)this.interp.getExpression();
        this.interp.getRightParen();
        double d = 0.0;
        ImageProcessor imageProcessor = this.getProcessor();
        d = this.getType() == 2 ? (double)imageProcessor.getPixelValue(n, n2) : (double)imageProcessor.getPixel(n, n2);
        return d;
    }

    void setPixel() {
        this.interp.getLeftParen();
        int n = (int)this.interp.getExpression();
        this.interp.getComma();
        int n2 = (int)this.interp.getExpression();
        this.interp.getComma();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        if (this.getType() == 2) {
            this.getProcessor().putPixelValue(n, n2, d);
        } else {
            this.getProcessor().putPixel(n, n2, (int)d);
        }
        this.updateNeeded = true;
    }

    void moveTo() {
        this.interp.getLeftParen();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        this.getProcessor().moveTo(n, n2);
    }

    void lineTo() {
        this.interp.getLeftParen();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor imageProcessor = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(imageProcessor);
        }
        imageProcessor.lineTo(n, n2);
        this.updateAndDraw(this.imp);
    }

    void drawLine() {
        this.interp.getLeftParen();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n3 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n4 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor imageProcessor = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(imageProcessor);
        }
        imageProcessor.drawLine(n, n2, n3, n4);
        this.updateAndDraw(this.imp);
    }

    void setForegroundColor(ImageProcessor imageProcessor) {
        imageProcessor.setColor(Toolbar.getForegroundColor());
        this.colorSet = true;
    }

    void doIPMethod(int n) {
        this.interp.getParens();
        ImageProcessor imageProcessor = this.getProcessor();
        switch (n) {
            case 333: {
                imageProcessor.snapshot();
                break;
            }
            case 334: {
                imageProcessor.reset();
                break;
            }
            case 335: {
                ImagePlus imagePlus = this.getImage();
                Roi roi = imagePlus.getRoi();
                if (!this.colorSet) {
                    this.setForegroundColor(imageProcessor);
                }
                if (roi == null) {
                    imageProcessor.resetRoi();
                    imageProcessor.fill();
                } else {
                    imageProcessor.setRoi(roi.getBoundingRect());
                    imageProcessor.fill(imagePlus.getMask());
                }
                this.updateAndDraw(imagePlus);
            }
        }
    }

    void updateAndDraw(ImagePlus imagePlus) {
        if (this.autoUpdate) {
            imagePlus.updateAndDraw();
        } else {
            this.updateNeeded = true;
        }
    }

    void updateDisplay() {
        if (this.updateNeeded) {
            ImagePlus imagePlus = this.getImage();
            imagePlus.updateAndDraw();
            this.updateNeeded = false;
        }
    }

    void drawString() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor imageProcessor = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(imageProcessor);
        }
        imageProcessor.drawString(string, n, n2);
        this.updateAndDraw(this.imp);
    }

    void changeValues() {
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        double d3 = this.getLastArg();
        ImagePlus imagePlus = this.getImage();
        ImageProcessor imageProcessor = this.getProcessor();
        Roi roi = imagePlus.getRoi();
        int[] nArray = null;
        if (roi == null || roi.getType() > 4) {
            imageProcessor.resetRoi();
            roi = null;
        } else {
            imageProcessor.setRoi(roi.getBoundingRect());
            nArray = imagePlus.getMask();
            imageProcessor.setMask(nArray);
            if (nArray != null) {
                imageProcessor.snapshot();
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getHeight();
        if (roi != null) {
            Rectangle rectangle = roi.getBoundingRect();
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.x + rectangle.width;
            n4 = rectangle.y + rectangle.height;
        }
        boolean bl = this.getType() == 2;
        int n5 = n2;
        while (n5 < n4) {
            int n6 = n;
            while (n6 < n3) {
                double d4;
                double d5 = d4 = bl ? (double)imageProcessor.getPixelValue(n6, n5) : (double)(imageProcessor.getPixel(n6, n5) & 0xFFFFFF);
                if (d4 >= d && d4 <= d2) {
                    if (bl) {
                        imageProcessor.putPixelValue(n6, n5, d3);
                    } else {
                        imageProcessor.putPixel(n6, n5, (int)d3);
                    }
                }
                ++n6;
            }
            ++n5;
        }
        if (nArray != null) {
            imageProcessor.reset(nArray);
        }
        if (imagePlus.getType() == 1 || imagePlus.getType() == 2) {
            imageProcessor.resetMinAndMax();
        }
        imagePlus.updateAndDraw();
        this.updateNeeded = false;
    }

    void requires() {
        if (IJ.versionLessThan(this.getStringArg())) {
            this.interp.done = true;
        }
    }

    double random() {
        this.interp.getParens();
        if (this.ran == null) {
            this.ran = new Random();
        }
        return this.ran.nextDouble();
    }

    double getResult() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        int n = (int)this.interp.getExpression();
        this.interp.getRightParen();
        ResultsTable resultsTable = Analyzer.getResultsTable();
        int n2 = resultsTable.getColumnIndex(string);
        if (n2 == -1) {
            this.interp.error("'" + string + "' not found");
        }
        if (n < 0 || n >= resultsTable.getCounter()) {
            this.interp.error("Row (" + n + ") out of range");
        }
        return resultsTable.getValue(n2, n);
    }

    double getNumber() {
        String string;
        this.interp.getLeftParen();
        String string2 = this.getString();
        this.interp.getComma();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        String string3 = string = this.interp.macroName != null ? this.interp.macroName : "";
        if (string.endsWith(" Options")) {
            string = string.substring(0, string.length() - 8);
        }
        GenericDialog genericDialog = new GenericDialog(string);
        int n = (double)((int)d) == d ? 0 : 2;
        genericDialog.addNumericField(string2, d, n);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.interp.done = true;
            return d;
        }
        double d2 = genericDialog.getNextNumber();
        if (genericDialog.invalidNumber()) {
            return d;
        }
        return d2;
    }

    String getStringDialog() {
        String string;
        this.interp.getLeftParen();
        String string2 = this.getString();
        this.interp.getComma();
        String string3 = this.getString();
        this.interp.getRightParen();
        String string4 = string = this.interp.macroName != null ? this.interp.macroName : "";
        if (string.endsWith(" Options")) {
            string = string.substring(0, string.length() - 8);
        }
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addStringField(string2, string3, 20);
        genericDialog.showDialog();
        String string5 = "";
        if (genericDialog.wasCanceled()) {
            this.interp.done = true;
        } else {
            string5 = genericDialog.getNextString();
        }
        return string5;
    }

    String d2s() {
        return IJ.d2s(this.getFirstArg(), (int)this.getLastArg());
    }

    String toString(int n) {
        int n2 = (int)this.getArg();
        if (n == 2) {
            return Integer.toBinaryString(n2);
        }
        return Integer.toHexString(n2);
    }

    double getStackSize() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return this.getImage().getStackSize();
    }

    double getImageCount() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return WindowManager.getWindowCount();
    }

    double getResultsCount() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return Analyzer.getResultsTable().getCounter();
    }

    void getCoordinates() {
        Variable variable = this.getFirstArrayVariable();
        Variable variable2 = this.getLastArrayVariable();
        this.resetImage();
        ImageProcessor imageProcessor = this.getProcessor();
        Roi roi = this.imp.getRoi();
        if (roi == null || !(roi instanceof PolygonRoi)) {
            this.interp.error("Polygonal selection required");
        }
        int[] nArray = ((PolygonRoi)roi).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
        int n = ((PolygonRoi)roi).getNCoordinates();
        Rectangle rectangle = roi.getBoundingRect();
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = rectangle.x + nArray[n2];
            nArray4[n2] = rectangle.y + nArray2[n2];
            ++n2;
        }
        variable.setArray(new Variable(nArray3).getArray());
        variable2.setArray(new Variable(nArray4).getArray());
    }

    Variable[] getProfile() {
        this.interp.getParens();
        ImagePlus imagePlus = this.getImage();
        ProfilePlot profilePlot = new ProfilePlot(imagePlus, false);
        double[] dArray = profilePlot.getProfile();
        if (dArray == null) {
            this.interp.done = true;
            return null;
        }
        return new Variable(dArray).getArray();
    }

    Variable[] newArray() {
        this.interp.getLeftParen();
        if (this.interp.nextNonEolToken() == 133 || this.interp.nextNextNonEolToken() == 44) {
            return this.initNewArray();
        }
        int n = (int)this.interp.getExpression();
        this.interp.getRightParen();
        Variable[] variableArray = new Variable[n];
        int n2 = 0;
        while (n2 < n) {
            variableArray[n2] = new Variable();
            ++n2;
        }
        return variableArray;
    }

    Variable[] split() {
        String[] stringArray;
        String string = this.getFirstStringArg();
        String string2 = this.getLastStringArg();
        StringTokenizer stringTokenizer = string2.equals("") ? new StringTokenizer(string) : new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = stringTokenizer.nextToken();
                ++n2;
            }
        } else {
            stringArray = new String[]{string};
            n = 1;
        }
        Variable[] variableArray = new Variable[n];
        int n3 = 0;
        while (n3 < n) {
            variableArray[n3] = new Variable(0, 0.0, stringArray[n3]);
            ++n3;
        }
        return variableArray;
    }

    Variable[] initNewArray() {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        do {
            objectArray = new Variable();
            if (this.interp.nextNonEolToken() == 133) {
                objectArray.setString(this.getString());
            } else {
                objectArray.setValue(this.interp.getExpression());
            }
            vector.addElement(objectArray);
            ++n;
            this.interp.getToken();
        } while (this.interp.token == 44);
        if (this.interp.token != 41) {
            this.interp.error("';' expected");
        }
        objectArray = new Variable[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    String fromCharCode() {
        char[] cArray = new char[100];
        int n = 0;
        this.interp.getLeftParen();
        while (this.interp.nextToken() != 41) {
            int n2 = (int)this.interp.getExpression();
            if (n2 < 0 || n2 > 65535) {
                this.interp.error("Value (" + n2 + ") out of 0-65535 range");
            }
            cArray[n++] = (char)n2;
            if (this.interp.nextToken() != 44) continue;
            this.interp.getToken();
        }
        this.interp.getRightParen();
        return new String(cArray);
    }

    public String getInfo() {
        this.interp.getParens();
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextPanel textPanel = ((TextWindow)frame).getTextPanel();
            return textPanel.getText();
        }
        if (frame != null && frame instanceof Editor) {
            return ((Editor)frame).getText();
        }
        ImagePlus imagePlus = this.getImage();
        Info info = new Info();
        return info.getImageInfo(imagePlus, this.getProcessor());
    }

    double getSelectionType() {
        this.interp.getParens();
        double d = -1.0;
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            d = roi.getType();
        }
        return d;
    }

    void showMessage(boolean bl) {
        String string;
        this.interp.getLeftParen();
        String string2 = this.getString();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            string = this.getString();
        } else {
            string = string2;
            string2 = "";
        }
        this.interp.getRightParen();
        if (bl) {
            IJ.showMessageWithCancel(string2, string);
        } else {
            IJ.showMessage(string2, string);
        }
    }

    double lengthOf() {
        int n = 0;
        this.interp.getLeftParen();
        switch (this.interp.nextToken()) {
            case 133: 
            case 136: 
            case 138: {
                n = this.getString().length();
                break;
            }
            case 129: {
                this.interp.getToken();
                Variable variable = this.interp.lookupNumericVariable();
                if (variable == null) {
                    return 0.0;
                }
                String string = variable.getString();
                if (string != null) {
                    n = string.length();
                    break;
                }
                Variable[] variableArray = variable.getArray();
                if (variableArray != null) {
                    n = variableArray.length;
                    break;
                }
                this.interp.error("String or array expected");
                break;
            }
            default: {
                this.interp.error("String or array expected");
            }
        }
        this.interp.getRightParen();
        return n;
    }

    void getCursorLoc() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getLastVariable();
        ImagePlus imagePlus = this.getImage();
        ImageWindow imageWindow = imagePlus.getWindow();
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        Point point = imageCanvas.getCursorLoc();
        variable.setValue(point.x);
        variable2.setValue(point.y);
        variable3.setValue(imagePlus.getCurrentSlice() - 1);
        variable4.setValue(imageCanvas.getModifiers());
    }

    void getLine() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getNextVariable();
        Variable variable5 = this.getLastVariable();
        this.resetImage();
        ImagePlus imagePlus = this.getImage();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.getType() == 5) {
            Line line = (Line)roi;
            n = line.x1;
            n2 = line.y1;
            n3 = line.x2;
            n4 = line.y2;
        }
        variable.setValue(n);
        variable2.setValue(n2);
        variable3.setValue(n3);
        variable4.setValue(n4);
        variable5.setValue(Line.getWidth());
    }

    void getVoxelSize() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getLastVariable();
        this.resetImage();
        ImagePlus imagePlus = this.getImage();
        Calibration calibration = imagePlus.getCalibration();
        variable.setValue(calibration.pixelWidth);
        variable2.setValue(calibration.pixelHeight);
        variable3.setValue(calibration.pixelDepth);
        variable4.setString(calibration.getUnit());
    }

    void getHistogram() {
        Variable[] variableArray;
        this.interp.getLeftParen();
        Variable variable = null;
        if (this.interp.nextToken() == 130) {
            this.interp.getExpression();
        } else {
            variable = this.getArrayVariable();
        }
        Variable variable2 = this.getNextArrayVariable();
        int n = (int)this.getLastArg();
        ImagePlus imagePlus = this.getImage();
        int n2 = imagePlus.getBitDepth();
        if (n2 != 32 && n != 256) {
            this.interp.error("Bin count (" + n + ") must be 256 for non-float images");
        }
        ImageStatistics imageStatistics = imagePlus.getStatistics(27, n);
        if (variable != null) {
            variableArray = imagePlus.getCalibration();
            double[] dArray = new double[n];
            double d = variableArray.getCValue(imageStatistics.histMin);
            double d2 = 1.0;
            if (n2 == 16 || n2 == 32 || variableArray.calibrated()) {
                d2 = (variableArray.getCValue(imageStatistics.histMax) - variableArray.getCValue(imageStatistics.histMin)) / (double)imageStatistics.nBins;
            }
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = d;
                d += d2;
                ++n3;
            }
            variable.setArray(new Variable(dArray).getArray());
        }
        if ((variableArray = variable2.getArray()) != null && variableArray.length == n) {
            int n4 = 0;
            while (n4 < n) {
                variableArray[n4].setValue(imageStatistics.histogram[n4]);
                ++n4;
            }
        } else {
            variable2.setArray(new Variable(imageStatistics.histogram).getArray());
        }
    }

    void getLut() {
        Variable variable = this.getFirstArrayVariable();
        Variable variable2 = this.getNextArrayVariable();
        Variable variable3 = this.getLastArrayVariable();
        this.resetImage();
        ImageProcessor imageProcessor = this.getProcessor();
        if (imageProcessor instanceof ColorProcessor) {
            this.interp.error("Non-RGB image expected");
        }
        IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        variable.setArray(new Variable(byArray).getArray());
        variable2.setArray(new Variable(byArray2).getArray());
        variable3.setArray(new Variable(byArray3).getArray());
    }

    void setLut() {
        double[] dArray = this.getFirstArray();
        double[] dArray2 = this.getNextArray();
        double[] dArray3 = this.getLastArray();
        int n = dArray.length;
        if (dArray2.length != n || dArray3.length != n) {
            this.interp.error("Arrays are not the same length");
        }
        this.resetImage();
        ImagePlus imagePlus = this.getImage();
        if (imagePlus.getBitDepth() == 24) {
            this.interp.error("Non-RGB image expected");
        }
        ImageProcessor imageProcessor = this.getProcessor();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)dArray[n2];
            byArray2[n2] = (byte)dArray2[n2];
            byArray3[n2] = (byte)dArray3[n2];
            ++n2;
        }
        imageProcessor.setColorModel(new IndexColorModel(8, n, byArray, byArray2, byArray3));
        imagePlus.updateAndDraw();
        this.updateNeeded = false;
    }

    void graph() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        double[] dArray = this.getArray();
        this.interp.getComma();
        double[] dArray2 = this.getArray();
        this.interp.getComma();
        String string2 = this.getString();
        this.interp.getComma();
        String string3 = this.getString();
        this.interp.getRightParen();
        PlotWindow plotWindow = new PlotWindow(string, string2, string3, dArray, dArray2);
        plotWindow.draw();
    }

    void getBoundingRect() {
        Variable variable = this.getFirstVariable();
        Variable variable2 = this.getNextVariable();
        Variable variable3 = this.getNextVariable();
        Variable variable4 = this.getLastVariable();
        this.resetImage();
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            Rectangle rectangle = roi.getBoundingRect();
            variable.setValue(rectangle.x);
            variable2.setValue(rectangle.y);
            variable3.setValue(rectangle.width);
            variable4.setValue(rectangle.height);
        } else {
            variable.setValue(0.0);
            variable2.setValue(0.0);
            variable3.setValue(imagePlus.getWidth());
            variable4.setValue(imagePlus.getHeight());
        }
    }

    void getStatistics() {
    }

    String substring() {
        int n;
        String string = this.getFirstStringArg();
        int n2 = (int)this.getNextArg();
        if (n2 > (n = (int)this.getLastArg())) {
            this.interp.error("beginIndex>endIndex");
        }
        this.checkIndex(n2, 0, string.length());
        this.checkIndex(n, 0, string.length());
        return string.substring(n2, n);
    }

    int indexOf() {
        String string = this.getFirstStringArg();
        String string2 = this.getNextStringArg();
        int n = 0;
        if (this.interp.nextToken() == 44) {
            n = (int)this.getLastArg();
            this.checkIndex(n, 0, string.length() - 1);
        } else {
            this.interp.getRightParen();
        }
        if (n == 0) {
            return string.indexOf(string2);
        }
        return string.indexOf(string2, n);
    }

    double isActive() {
        int n = (int)this.getArg();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getID() != n) {
            return 0.0;
        }
        return 1.0;
    }

    double isOpen() {
        this.interp.getLeftParen();
        if (this.interp.nextToken() == 133) {
            String string = this.getString();
            this.interp.getRightParen();
            return WindowManager.getFrame(string) == null ? 0.0 : 1.0;
        }
        int n = (int)this.interp.getExpression();
        this.interp.getRightParen();
        return WindowManager.getImage(n) == null ? 0.0 : 1.0;
    }

    void exit() {
        String string = null;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.interp.nextToken() == 133 || this.interp.nextToken() == 136) {
                string = this.getString();
            }
            this.interp.getRightParen();
        }
        IJ.showStatus("");
        IJ.showProgress(1.0);
        if (string != null) {
            IJ.showMessage("Macro", string);
        }
        throw new RuntimeException("Macro canceled");
    }

    void showProgress() {
        this.interp.getLeftParen();
        double d = this.interp.getExpression();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double d2 = this.interp.getExpression();
            IJ.showProgress((int)d, (int)d2);
        } else {
            IJ.showProgress(d);
        }
        this.interp.getRightParen();
        this.interp.showingProgress = true;
    }
}

