/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Toolbar
extends Canvas
implements MouseListener {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int LINE = 4;
    public static final int POLYLINE = 5;
    public static final int FREELINE = 6;
    public static final int CROSSHAIR = 7;
    public static final int WAND = 8;
    public static final int TEXT = 9;
    public static final int SPARE1 = 10;
    public static final int MAGNIFIER = 11;
    public static final int HAND = 12;
    public static final int DROPPER = 13;
    public static final int ANGLE = 14;
    public static final int SPARE2 = 15;
    public static final int SPARE3 = 16;
    public static final int SPARE4 = 17;
    public static final int SPARE5 = 18;
    public static final int SPARE6 = 19;
    private static final int NUM_TOOLS = 20;
    private static final int N_SPARES = 6;
    private static final int SIZE = 22;
    private static final int OFFSET = 3;
    private Dimension ps = new Dimension(440, 22);
    private boolean[] down;
    private static int current;
    private int previous;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private static Toolbar instance;
    private int mpPrevious = 0;
    private String[] names = new String[20];
    private String[] icons = new String[20];
    private int pc;
    private String icon;
    private MacroInstaller macroInstaller;
    private static Color foregroundColor;
    private static Color backgroundColor;
    private Color gray = ImageJ.backgroundColor;
    private Color brighter = this.gray.brighter();
    private Color darker = this.gray.darker();
    private Color evenDarker = this.darker.darker();

    public Toolbar() {
        this.down = new boolean[20];
        this.resetButtons();
        this.down[0] = true;
        this.setForeground(foregroundColor);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        instance = this;
    }

    public static int getToolId() {
        return current;
    }

    public static Toolbar getInstance() {
        return instance;
    }

    private void drawButtons(Graphics graphics) {
        int n = 0;
        while (n < 20) {
            this.drawButton(graphics, n);
            ++n;
        }
    }

    private void fill3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            graphics.setColor(this.gray);
        } else {
            graphics.setColor(this.darker);
        }
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(bl ? this.brighter : this.evenDarker);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
        graphics.setColor(bl ? this.evenDarker : this.brighter);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 2);
    }

    private void drawButton(Graphics graphics, int n) {
        int n2 = this.toolIndex(n);
        this.fill3DRect(graphics, n2 * 22 + 1, 1, 22, 21, !this.down[n]);
        graphics.setColor(Color.black);
        int n3 = n2 * 22 + 3;
        int n4 = 3;
        if (this.down[n]) {
            ++n3;
            ++n4;
        }
        this.g = graphics;
        if (n >= 10 && n <= 19 && this.icons[n] != null) {
            this.drawIcon(graphics, this.icons[n], n3, n4);
            return;
        }
        switch (n) {
            case 0: {
                graphics.drawRect(n3 + 1, n4 + 2, 14, 11);
                return;
            }
            case 1: {
                graphics.drawOval(n3 + 1, n4 + 3, 14, 11);
                return;
            }
            case 2: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 3;
                this.m(4, 0);
                this.d(14, 0);
                this.d(14, 1);
                this.d(10, 5);
                this.d(10, 6);
                this.d(13, 9);
                this.d(13, 10);
                this.d(0, 10);
                this.d(0, 4);
                this.d(4, 0);
                return;
            }
            case 3: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 3;
                this.m(3, 0);
                this.d(5, 0);
                this.d(7, 2);
                this.d(9, 2);
                this.d(11, 0);
                this.d(13, 0);
                this.d(14, 1);
                this.d(15, 2);
                this.d(15, 4);
                this.d(14, 5);
                this.d(14, 6);
                this.d(12, 8);
                this.d(11, 8);
                this.d(10, 9);
                this.d(9, 9);
                this.d(8, 10);
                this.d(5, 10);
                this.d(3, 8);
                this.d(2, 8);
                this.d(1, 7);
                this.d(1, 6);
                this.d(0, 5);
                this.d(0, 2);
                this.d(1, 1);
                this.d(2, 1);
                return;
            }
            case 4: {
                this.xOffset = n3;
                this.yOffset = n4 + 5;
                this.m(0, 0);
                this.d(16, 6);
                return;
            }
            case 5: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 3;
                this.m(0, 3);
                this.d(3, 0);
                this.d(13, 0);
                this.d(13, 1);
                this.d(8, 6);
                this.d(12, 10);
                return;
            }
            case 6: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 4;
                this.m(0, 1);
                this.d(2, 3);
                this.d(4, 3);
                this.d(7, 0);
                this.d(8, 0);
                this.d(10, 4);
                this.d(14, 8);
                this.d(15, 8);
                return;
            }
            case 7: {
                this.xOffset = n3;
                this.yOffset = n4;
                this.m(1, 8);
                this.d(6, 8);
                this.d(6, 6);
                this.d(10, 6);
                this.d(10, 10);
                this.d(6, 10);
                this.d(6, 9);
                this.m(8, 1);
                this.d(8, 5);
                this.m(11, 8);
                this.d(15, 8);
                this.m(8, 11);
                this.d(8, 15);
                this.m(8, 8);
                this.d(8, 8);
                return;
            }
            case 8: {
                this.xOffset = n3 + 2;
                this.yOffset = n4 + 2;
                this.m(4, 0);
                this.d(4, 0);
                this.m(2, 0);
                this.d(3, 1);
                this.d(4, 2);
                this.m(0, 0);
                this.d(1, 1);
                this.m(0, 2);
                this.d(1, 3);
                this.d(2, 4);
                this.m(0, 4);
                this.d(0, 4);
                this.m(3, 3);
                this.d(12, 12);
                return;
            }
            case 9: {
                this.xOffset = n3 + 2;
                this.yOffset = n4 + 1;
                this.m(0, 13);
                this.d(3, 13);
                this.m(1, 12);
                this.d(7, 0);
                this.d(12, 13);
                this.m(11, 13);
                this.d(14, 13);
                this.m(3, 8);
                this.d(10, 8);
                return;
            }
            case 11: {
                this.xOffset = n3 + 2;
                this.yOffset = n4 + 2;
                this.m(3, 0);
                this.d(3, 0);
                this.d(5, 0);
                this.d(8, 3);
                this.d(8, 5);
                this.d(7, 6);
                this.d(7, 7);
                this.d(6, 7);
                this.d(5, 8);
                this.d(3, 8);
                this.d(0, 5);
                this.d(0, 3);
                this.d(3, 0);
                this.m(8, 8);
                this.d(9, 8);
                this.d(13, 12);
                this.d(13, 13);
                this.d(12, 13);
                this.d(8, 9);
                this.d(8, 8);
                return;
            }
            case 12: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 1;
                this.m(5, 14);
                this.d(2, 11);
                this.d(2, 10);
                this.d(0, 8);
                this.d(0, 7);
                this.d(1, 6);
                this.d(2, 6);
                this.d(4, 8);
                this.d(4, 6);
                this.d(3, 5);
                this.d(3, 4);
                this.d(2, 3);
                this.d(2, 2);
                this.d(3, 1);
                this.d(4, 1);
                this.d(5, 2);
                this.d(5, 3);
                this.m(6, 5);
                this.d(6, 1);
                this.d(7, 0);
                this.d(8, 0);
                this.d(9, 1);
                this.d(9, 5);
                this.m(9, 1);
                this.d(11, 1);
                this.d(12, 2);
                this.d(12, 6);
                this.m(13, 4);
                this.d(14, 3);
                this.d(15, 4);
                this.d(15, 7);
                this.d(14, 8);
                this.d(14, 10);
                this.d(13, 11);
                this.d(13, 12);
                this.d(12, 13);
                this.d(12, 14);
                return;
            }
            case 13: {
                this.xOffset = n3;
                this.yOffset = n4;
                graphics.setColor(foregroundColor);
                this.m(12, 2);
                this.d(14, 2);
                this.m(11, 3);
                this.d(15, 3);
                this.m(11, 4);
                this.d(15, 4);
                this.m(8, 5);
                this.d(15, 5);
                this.m(9, 6);
                this.d(14, 6);
                this.m(10, 7);
                this.d(12, 7);
                this.d(12, 9);
                this.m(8, 7);
                this.d(2, 13);
                this.d(2, 15);
                this.d(4, 15);
                this.d(11, 8);
                graphics.setColor(backgroundColor);
                this.m(0, 0);
                this.d(16, 0);
                this.d(16, 16);
                this.d(0, 16);
                this.d(0, 0);
                graphics.setColor(Color.black);
                return;
            }
            case 14: {
                this.xOffset = n3 + 1;
                this.yOffset = n4 + 2;
                this.m(0, 11);
                this.d(11, 0);
                this.m(0, 11);
                this.d(15, 11);
                this.m(10, 11);
                this.d(10, 8);
                this.m(9, 7);
                this.d(9, 6);
                this.m(8, 5);
                this.d(8, 5);
                return;
            }
        }
    }

    void drawIcon(Graphics graphics, String string, int n, int n2) {
        this.icon = string;
        int n3 = string.length();
        this.pc = 0;
        block11: do {
            char c = string.charAt(this.pc++);
            if (this.pc >= n3) break;
            switch (c) {
                case 'B': {
                    n += this.v();
                    n2 += this.v();
                    break;
                }
                case 'R': {
                    graphics.drawRect(n + this.v(), n2 + this.v(), this.v(), this.v());
                    break;
                }
                case 'F': {
                    graphics.fillRect(n + this.v(), n2 + this.v(), this.v(), this.v());
                    break;
                }
                case 'O': {
                    graphics.drawOval(n + this.v(), n2 + this.v(), this.v(), this.v());
                    break;
                }
                case 'o': {
                    graphics.fillOval(n + this.v(), n2 + this.v(), this.v(), this.v());
                    break;
                }
                case 'C': {
                    graphics.setColor(new Color(this.v() * 16, this.v() * 16, this.v() * 16));
                    break;
                }
                case 'L': {
                    graphics.drawLine(n + this.v(), n2 + this.v(), n + this.v(), n2 + this.v());
                    break;
                }
                case 'P': {
                    int n4;
                    int n5;
                    int n6 = n + this.v();
                    int n7 = n2 + this.v();
                    while ((n5 = this.v()) != 0 && (n4 = this.v()) != 0) {
                        graphics.drawLine(n6, n7, n5 += n, n4 += n2);
                        n6 = n5;
                        n7 = n4;
                    }
                    continue block11;
                }
                case 'T': {
                    int n5 = n + this.v();
                    int n4 = n2 + this.v();
                    int n8 = this.v() * 10 + this.v();
                    char[] cArray = new char[]{this.pc < string.length() ? (char)string.charAt(this.pc++) : (char)'e'};
                    graphics.setFont(new Font("SansSerif", 1, n8));
                    graphics.drawString(new String(cArray), n5, n4);
                    break;
                }
            }
        } while (this.pc < n3);
        graphics.setColor(Color.black);
    }

    int v() {
        if (this.pc >= this.icon.length()) {
            return 0;
        }
        char c = this.icon.charAt(this.pc++);
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    private void showMessage(int n) {
        if (n >= 10 && n <= 19 && this.names[n] != null) {
            IJ.showStatus(this.names[n]);
            return;
        }
        switch (n) {
            case 0: {
                IJ.showStatus("Rectangular selections");
                return;
            }
            case 1: {
                IJ.showStatus("Oval selections");
                return;
            }
            case 2: {
                IJ.showStatus("Polygon selections");
                return;
            }
            case 3: {
                IJ.showStatus("Freehand selections");
                return;
            }
            case 4: {
                IJ.showStatus("Straight line selections");
                return;
            }
            case 5: {
                IJ.showStatus("Segmented line selections");
                return;
            }
            case 6: {
                IJ.showStatus("Freehand line selections");
                return;
            }
            case 7: {
                IJ.showStatus("Crosshair (mark and count) tool");
                return;
            }
            case 8: {
                IJ.showStatus("Wand (tracing) tool");
                return;
            }
            case 9: {
                IJ.showStatus("Text tool");
                return;
            }
            case 11: {
                IJ.showStatus("Magnifying glass");
                return;
            }
            case 12: {
                IJ.showStatus("Scrolling tool");
                return;
            }
            case 13: {
                IJ.showStatus("Color picker (" + foregroundColor.getRed() + "," + foregroundColor.getGreen() + "," + foregroundColor.getBlue() + ")");
                return;
            }
            case 14: {
                IJ.showStatus("Angle tool");
                return;
            }
        }
        IJ.showStatus("");
    }

    private void m(int n, int n2) {
        this.x = this.xOffset + n;
        this.y = this.yOffset + n2;
    }

    private void d(int n, int n2) {
        this.g.drawLine(this.x, this.y, n += this.xOffset, n2 += this.yOffset);
        this.x = n;
        this.y = n2;
    }

    private void resetButtons() {
        int n = 0;
        while (n < 20) {
            this.down[n] = false;
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        this.drawButtons(graphics);
    }

    public void setTool(int n) {
        if (n == current || n < 0 || n >= 20) {
            return;
        }
        if ((n == 10 || n >= 15 && n <= 19) && this.names[n] == null) {
            this.names[n] = "Spare tool";
        }
        this.setTool2(n);
    }

    private void setTool2(int n) {
        if (n == current || n < 0 || n >= 20) {
            return;
        }
        if ((n == 10 || n >= 15 && n <= 19) && this.names[n] == null) {
            return;
        }
        current = n;
        this.down[Toolbar.current] = true;
        this.down[this.previous] = false;
        Graphics graphics = this.getGraphics();
        this.drawButton(graphics, this.previous);
        this.drawButton(graphics, current);
        graphics.dispose();
        this.showMessage(current);
        this.previous = current;
        if (Recorder.record) {
            Recorder.record("setTool", current);
        }
        if (IJ.isMacOSX()) {
            this.repaint();
        }
    }

    public Color getColor() {
        return foregroundColor;
    }

    public void setColor(Color color) {
        foregroundColor = color;
        this.drawButton(this.getGraphics(), 13);
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    public static void setForegroundColor(Color color) {
        foregroundColor = color;
        Toolbar.updateColors();
    }

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static void setBackgroundColor(Color color) {
        backgroundColor = color;
        Toolbar.updateColors();
    }

    static void updateColors() {
        Toolbar toolbar = Toolbar.getInstance();
        Graphics graphics = toolbar.getGraphics();
        toolbar.drawButton(graphics, 13);
        toolbar.drawButton(graphics, 7);
        graphics.dispose();
    }

    int toolIndex(int n) {
        if (n <= 6 || n > 14) {
            return n;
        }
        if (n == 14) {
            return 7;
        }
        return n + 1;
    }

    int toolID(int n) {
        if (n <= 6 || n > 14) {
            return n;
        }
        if (n == 7) {
            return 14;
        }
        return n - 1;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = 0;
        int n3 = 0;
        while (n3 < 20) {
            if (n > n3 * 22 && n < n3 * 22 + 22) {
                n2 = this.toolID(n3);
            }
            ++n3;
        }
        boolean bl = n2 == current && System.currentTimeMillis() - this.mouseDownTime <= 500L;
        this.mouseDownTime = System.currentTimeMillis();
        if (!bl) {
            this.mpPrevious = current;
            this.setTool2(n2);
        } else {
            if (current >= 10 && current <= 19 && this.names[current] != null && this.macroInstaller != null) {
                String string = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
                this.macroInstaller.runMacroTool(string + "Options");
                return;
            }
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            switch (current) {
                case 3: {
                    IJ.doCommand("Set Measurements...");
                    this.setTool2(this.mpPrevious);
                    break;
                }
                case 11: {
                    if (imagePlus == null) break;
                    imagePlus.getWindow().getCanvas().unzoom();
                    break;
                }
                case 2: {
                    if (imagePlus != null) {
                        IJ.doCommand("Calibrate...");
                    }
                    this.setTool2(this.mpPrevious);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    IJ.doCommand("Line Width...");
                    break;
                }
                case 7: {
                    IJ.doCommand("Crosshair...");
                    break;
                }
                case 9: {
                    IJ.doCommand("Fonts...");
                    break;
                }
                case 13: {
                    IJ.doCommand("Colors...");
                    this.setTool2(this.mpPrevious);
                    break;
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        return this.ps;
    }

    public Dimension getMinimumSize() {
        return this.ps;
    }

    public int addTool(String string) {
        boolean bl;
        int n = string.indexOf(45);
        boolean bl2 = bl = n >= 0 && string.length() - n > 4;
        if (!bl) {
            this.names[10] = string;
            return 10;
        }
        int n2 = -1;
        if (this.names[10] == null) {
            n2 = 10;
        }
        if (n2 == -1) {
            int n3 = 15;
            while (n3 <= 19) {
                if (this.names[n3] == null) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        if (n2 == -1) {
            return -1;
        }
        this.icons[n2] = string.substring(n + 1);
        this.names[n2] = string.substring(0, n);
        return n2;
    }

    public void addMacroTool(String string, MacroInstaller macroInstaller, int n) {
        int n2;
        if (n == 0) {
            n2 = 10;
            while (n2 < 20) {
                this.names[n2] = null;
                this.icons[n2] = null;
                ++n2;
            }
        }
        n2 = this.addTool(string);
        this.macroInstaller = macroInstaller;
    }

    void runMacroTool(int n) {
        if (this.macroInstaller != null) {
            this.macroInstaller.runMacroTool(this.names[n]);
        }
    }

    static {
        foregroundColor = Prefs.getColor("fcolor", Color.black);
        backgroundColor = Prefs.getColor("bcolor", Color.white);
    }
}

