/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.util.Hashtable;

public class Undo {
    public static final int NOTHING = 0;
    public static final int FILTER = 1;
    public static final int TYPE_CONVERSION = 2;
    public static final int PASTE = 3;
    public static final int COMPOUND_FILTER = 4;
    public static final int COMPOUND_FILTER_DONE = 5;
    public static final int TRANSFORM = 6;
    private static int whatToUndo = 0;
    private static int imageID;
    private static ImageProcessor ipCopy;
    private static ImagePlus impCopy;

    public static void setup(int n, ImagePlus imagePlus) {
        if (imagePlus == null) {
            Undo.reset();
            return;
        }
        if (n == 1 && whatToUndo == 4) {
            return;
        }
        if (n == 5) {
            if (whatToUndo == 4) {
                whatToUndo = n;
            }
            return;
        }
        whatToUndo = n;
        imageID = imagePlus.getID();
        if (n == 2) {
            ipCopy = imagePlus.getProcessor();
        } else if (n == 6) {
            impCopy = new ImagePlus(imagePlus.getTitle(), imagePlus.getProcessor());
            Object object = imagePlus.getProperty("FHT");
            if (object != null) {
                impCopy.setProperty("FHT", object);
            }
        } else {
            ImageProcessor imageProcessor;
            ipCopy = n == 4 ? ((imageProcessor = imagePlus.getProcessor()) != null ? imageProcessor.duplicate() : null) : null;
        }
    }

    public static void reset() {
        whatToUndo = 0;
        imageID = 0;
        ipCopy = null;
        impCopy = null;
    }

    public static void undo() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imageID != imagePlus.getID()) {
            Undo.reset();
            return;
        }
        switch (whatToUndo) {
            case 1: {
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                if (imageProcessor == null) break;
                imageProcessor.reset();
                imagePlus.updateAndDraw();
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                if (ipCopy == null) break;
                imagePlus.setProcessor(null, ipCopy);
                break;
            }
            case 6: {
                if (impCopy == null) break;
                imagePlus.setProcessor(impCopy.getTitle(), impCopy.getProcessor());
                Object object = impCopy.getProperty("FHT");
                if (object != null) {
                    imagePlus.setProperty("FHT", object);
                    break;
                }
                if (imagePlus.getProperty("FHT") == null) break;
                ((Hashtable)imagePlus.getProperties()).remove("FHT");
                break;
            }
            case 3: {
                Roi roi = imagePlus.getRoi();
                if (roi == null) break;
                roi.abortPaste();
            }
        }
        Undo.reset();
    }

    static {
        ipCopy = null;
    }
}

