/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.text.NumberFormat;
import java.util.Locale;

class PixelDisplay
extends Panel
implements MouseListener,
ImageObserver,
KeyListener {
    ImageCanvas c1;
    ImageCanvas c2;
    ImageCanvas c3;
    My3DData data3d;
    int imgw = -1;
    int imgh = -1;
    private int lxold = 0;
    private int lyold = 0;
    private int PointNr = 0;
    private double pval = 0.0;
    boolean didinit = false;
    int PlotMode = 0;
    PlotInfo myInfo = new PlotInfo();
    boolean normalize = true;
    boolean logmode = false;
    double maxdispl = 1.0;
    double mindispl = 0.0;
    String TextToDisplay = "";
    PopupMenu MyPopupMenu;
    Menu ColorMenu;

    void AddColorMenu(String string, int n) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(new MyMenuProcessor(this, this.c1, false, n));
        this.ColorMenu.add(menuItem);
        menuItem = new MenuItem(string + " (inverted)");
        menuItem.addActionListener(new MyMenuProcessor(this, this.c1, true, n));
        this.ColorMenu.add(menuItem);
    }

    PixelDisplay(My3DData my3DData, ImageCanvas imageCanvas, ImageCanvas imageCanvas2, ImageCanvas imageCanvas3) {
        this.c1 = imageCanvas;
        this.c2 = imageCanvas2;
        this.c3 = imageCanvas3;
        this.data3d = my3DData;
        Rectangle rectangle = this.getBounds();
        this.setBounds(0, 0, 200, 50);
        rectangle = this.getBounds();
        if (my3DData.Elements > 5) {
            this.PlotMode = 1;
        }
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.MyPopupMenu = new PopupMenu("Element Menu");
        this.add(this.MyPopupMenu);
        Menu menu = new Menu("General", false);
        this.MyPopupMenu.add(menu);
        MenuItem menuItem = new MenuItem("initialise scaling [i]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'i'));
        menu.add(menuItem);
        menuItem = new MenuItem("Set Value Units and Scalings [N]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'N'));
        menu.add(menuItem);
        menuItem = new MenuItem("eXport to ImageJ (ImageJ only) [X]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'X'));
        menu.add(menuItem);
        menu = new Menu("Markers", false);
        this.MyPopupMenu.add(menu);
        menuItem = new MenuItem("initialise scaling [M]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'M'));
        menu.add(menuItem);
        menuItem = new MenuItem("print/save marker list [m]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'm'));
        menu.add(menuItem);
        menu = new Menu("Plotting", false);
        this.MyPopupMenu.add(menu);
        menuItem = new MenuItem("spawn plot display [s]");
        menuItem.addActionListener(new MyMenuProcessor(this, 's'));
        menu.add(menuItem);
        menuItem = new MenuItem("toggle plot display [q]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'q'));
        menu.add(menuItem);
        menuItem = new MenuItem("normalize plot display [n]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'n'));
        menu.add(menuItem);
        menuItem = new MenuItem("logarithmic mode [O]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'O'));
        menu.add(menuItem);
        menu = new Menu("ColorMaps", false);
        this.MyPopupMenu.add(menu);
        this.ColorMenu = menu;
        for (int i = 0; i < 13; ++i) {
            this.AddColorMenu(Bundle.ElementModelName[i], i);
        }
    }

    Color GetBWColor(int n) {
        int n2 = (int)this.c2.PositionValue;
        int n3 = (int)this.c3.PositionValue;
        int n4 = (int)this.c1.PositionValue;
        int n5 = (int)(this.data3d.NormedValueAt(n2, n3, n4, n) * 255.0);
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        return new Color(n5, n5, n5);
    }

    Color GetBWSatColor(int n) {
        int n2 = (int)this.c2.PositionValue;
        int n3 = (int)this.c3.PositionValue;
        int n4 = (int)this.c1.PositionValue;
        double d = this.data3d.NormedValueAt(n2, n3, n4, n) * 255.0;
        if (d >= 255.0) {
            return Color.blue;
        }
        if (d <= 0.0) {
            return new Color(0, 100, 0);
        }
        return new Color((int)d, (int)d, (int)d);
    }

    Color GetColColor(int n) {
        return this.data3d.GetColColor(n, (int)this.c2.PositionValue, (int)this.c3.PositionValue, (int)this.c1.PositionValue);
    }

    Color GetMarkerColor(int n) {
        return this.data3d.GetMarkerColor(n);
    }

    Color GetCMapColor(int n, int n2, int n3) {
        return this.data3d.GetCMapColor(n, n2, n3);
    }

    void CoordinatesChanged() {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.PlotMode > 0) {
            this.plot(graphics);
            return;
        }
        this.drawCMaps(graphics);
    }

    public void drawCMaps(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        int n = this.data3d.GetNumElements();
        int n2 = this.data3d.GetActiveElement();
        double d = (double)(rectangle.width - 1) / (double)n;
        int n3 = (rectangle.height - 1) / 4;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < rectangle.height; ++j) {
                graphics.setColor(this.GetCMapColor(i, rectangle.height - j - 1, rectangle.height));
                graphics.drawLine((int)((double)i * d), j, (int)((double)(i + 1) * d), j);
            }
            graphics.setColor(Color.white);
            if (i == this.data3d.HistoX) {
                graphics.drawString("HX", (int)((double)i * d + 5.0), (int)(1.0 * (double)n3));
            }
            if (i == this.data3d.HistoY) {
                graphics.drawString("HY", (int)((double)i * d + 5.0), (int)(1.33 * (double)n3));
            }
            if (i == this.data3d.HistoZ) {
                graphics.drawString("HZ", (int)((double)i * d + 5.0), (int)(1.66 * (double)n3));
            }
            if (i == this.data3d.GateElem) {
                if (this.data3d.GateActive) {
                    graphics.drawString("GA", (int)((double)i * d + 5.0), 3 * n3);
                } else {
                    graphics.drawString("G", (int)((double)i * d + 5.0), 3 * n3);
                }
            }
            if (!this.data3d.InOverlayDispl(i)) continue;
            graphics.drawString("Ov", (int)((double)i * d + 0.0), 4 * n3);
        }
        graphics.setColor(Color.red);
        graphics.drawRect(n2 * rectangle.width / n, 0, (int)d, rectangle.height);
        super.paint(graphics);
    }

    public void drawElements(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        int n = this.data3d.GetNumElements();
        int n2 = this.data3d.GetActiveElement();
        double d = (double)(rectangle.width - 1) / (double)n;
        int n3 = (rectangle.height - 1) / 4;
        for (int i = 0; i < n; ++i) {
            graphics.setColor(this.GetBWColor(i));
            graphics.fillRect((int)((double)i * d), 0, (int)((double)(i + 1) * d), n3);
            graphics.setColor(this.GetBWSatColor(i));
            graphics.fillRect((int)((double)i * d), n3, (int)((double)(i + 1) * d), 2 * n3);
            graphics.setColor(this.GetColColor(i));
            graphics.fillRect((int)((double)i * d), 2 * n3, (int)((double)(i + 1) * d), 3 * n3);
            graphics.setColor(this.GetMarkerColor(i));
            graphics.fillRect((int)((double)i * d), 3 * n3, (int)((double)(i + 1) * d), 4 * n3);
            graphics.setColor(Color.white);
            if (i == this.data3d.HistoX) {
                graphics.drawString("HX", (int)((double)i * d + 5.0), (int)(4.2 * (double)n3));
            }
            if (i == this.data3d.HistoY) {
                graphics.drawString("HY", (int)((double)i * d + 5.0 + (d / 3.0 - 10.0)), 4 * n3);
            }
            if (i == this.data3d.HistoZ) {
                graphics.drawString("HZ", (int)((double)i * d + 5.0 + (2.0 * d / 3.0 - 10.0)), 4 * n3);
            }
            if (i == this.data3d.GateElem) {
                if (this.data3d.GateActive) {
                    graphics.drawString("GA", (int)((double)i * d + 5.0), 3 * n3);
                } else {
                    graphics.drawString("G", (int)((double)i * d + 5.0), 3 * n3);
                }
            }
            if (!this.data3d.InOverlayDispl(i)) continue;
            graphics.drawString("Ov", (int)((double)i * d + 0.0), 4 * n3);
        }
        graphics.setColor(Color.red);
        graphics.drawRect(n2 * rectangle.width / n, 0, (int)d, rectangle.height);
        super.paint(graphics);
    }

    public double ApplyLog(double d) {
        if (!this.logmode) {
            return d;
        }
        if (d > 0.0) {
            return (Math.log(d) - Math.log(0.001)) / -Math.log(0.001);
        }
        return -10.0;
    }

    int InitDataPoints(int n) {
        this.PointNr = 0;
        switch (this.PlotMode) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.data3d.Elements;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.data3d.NumMarkers(n);
            }
        }
        return 0;
    }

    double GetNextDataPoint(int n) {
        double d = 0.0;
        switch (this.PlotMode) {
            case 0: {
                break;
            }
            case 1: {
                if (n < 0) {
                    if (this.data3d.GetProjectionMode(2)) {
                        d = this.data3d.GetROIVal(this.PointNr);
                        break;
                    }
                    d = this.data3d.NormedValueAt((int)this.c2.PositionValue, (int)this.c3.PositionValue, (int)this.c1.PositionValue, this.PointNr);
                    break;
                }
                d = this.data3d.NormedValueAt((int)(this.data3d.GetPoint((int)-1, (int)n).coord[0] + 0.5), (int)(this.data3d.GetPoint((int)-1, (int)n).coord[1] + 0.5), (int)(this.data3d.GetPoint((int)-1, (int)n).coord[2] + 0.5), this.PointNr);
                break;
            }
            case 2: {
                this.pval = this.data3d.GetPoint((int)this.PointNr, (int)n).integral / (((double)this.data3d.COMX * 2.0 + 1.0) * ((double)this.data3d.COMY * 2.0 + 1.0) * ((double)this.data3d.COMZ * 2.0 + 1.0));
                int n2 = (int)this.data3d.GetPoint((int)this.PointNr, (int)n).coord[3];
                d = this.data3d.Normalize(this.pval, n2);
                break;
            }
            case 3: {
                this.pval = this.data3d.GetPoint((int)this.PointNr, (int)n).max;
                int n3 = (int)this.data3d.GetPoint((int)this.PointNr, (int)n).coord[3];
                d = this.data3d.Normalize(this.pval, n3);
                break;
            }
            case 4: {
                this.pval = this.data3d.GetPoint((int)this.PointNr, (int)n).min;
                int n4 = (int)this.data3d.GetPoint((int)this.PointNr, (int)n).coord[3];
                d = this.data3d.Normalize(this.pval, n4);
                break;
            }
            case 5: {
                this.pval = this.data3d.GetPoint((int)this.PointNr, (int)n).integralAboveMin / (((double)this.data3d.COMX * 2.0 + 1.0) * ((double)this.data3d.COMY * 2.0 + 1.0) * ((double)this.data3d.COMZ * 2.0 + 1.0));
                int n5 = (int)this.data3d.GetPoint((int)this.PointNr, (int)n).coord[3];
                d = this.data3d.Normalize(this.pval, n5);
            }
        }
        ++this.PointNr;
        return d;
    }

    double GetNextNormDataPoint(int n) {
        double d = this.GetNextDataPoint(n);
        d = this.ApplyLog(d);
        if (this.PointNr == 1) {
            this.myInfo.newMaxVal = d;
            this.myInfo.newMinVal = d;
        }
        if (d > this.myInfo.newMaxVal) {
            this.myInfo.newMaxVal = d;
        }
        if (d < this.myInfo.newMinVal) {
            this.myInfo.newMinVal = d;
        }
        return d;
    }

    void drawDataPoint(Graphics graphics, Rectangle rectangle, double d, double d2, double d3, double d4, boolean bl) {
        d = this.normalize ? (this.myInfo.ValScale * (d - this.myInfo.MinVal) - this.mindispl) / (this.maxdispl - this.mindispl) : (this.myInfo.ValScale * d - this.mindispl) / (this.maxdispl - this.mindispl);
        int n = (int)(10.0 + d2 * ((double)rectangle.width - 20.0) / (d4 - 1.0));
        int n2 = rectangle.height - 10 - (int)((double)(rectangle.height - 20) * d);
        if (this.PointNr > 1) {
            graphics.drawLine(this.lxold, this.lyold, n, n2);
        }
        if (d2 == d3) {
            graphics.fillOval(n - 4, n2 - 4, 9, 9);
        }
        if (bl) {
            graphics.drawOval(n - 5, n2 - 5, 11, 11);
        }
        this.lxold = n;
        this.lyold = n2;
    }

    public void plot(Graphics graphics) {
        int n;
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(Color.white);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.data3d.Elements;
        if (n4 == 1) {
            n4 = 2;
        }
        graphics.drawLine(10, rectangle.height - 10, rectangle.width - 10, rectangle.height - 10);
        n2 = this.data3d.GetActiveElement();
        int n5 = 10 + n2 * (rectangle.width - 20) / (n4 - 1);
        graphics.drawLine(n5, 0, n5, rectangle.height - 1);
        switch (this.PlotMode) {
            case 1: {
                this.TextToDisplay = "Intensity(Elements)";
                break;
            }
            case 2: {
                this.TextToDisplay = "Mean(Marker Trace)";
                break;
            }
            case 3: {
                this.TextToDisplay = "Max(Marker Trace)";
                break;
            }
            case 4: {
                this.TextToDisplay = "Min(Marker Trace)";
                break;
            }
            case 5: {
                this.TextToDisplay = "[Mean-Min](Marker Trace)";
            }
        }
        if (this.data3d.GetProjectionMode(2)) {
            this.TextToDisplay = this.data3d.GetMIPMode(2) ? this.TextToDisplay + ", Max. Proj." : this.TextToDisplay + ", Avg. Proj.";
        }
        if (this.normalize && !this.data3d.GetProjectionMode(2)) {
            this.TextToDisplay = this.TextToDisplay + ", normalized";
        }
        if (this.logmode) {
            this.TextToDisplay = this.TextToDisplay + ", logmode";
        }
        if (!this.normalize) {
            this.myInfo.MinVal = 0.0;
            this.myInfo.MaxVal = 1.0;
            this.myInfo.ValScale = 1.0;
        }
        double d = 0.0;
        String string = "";
        if (this.PlotMode == 1) {
            double d2;
            string = "Elements";
            if (this.normalize) {
                n3 = this.InitDataPoints(-1);
                for (n = 0; n < n3; ++n) {
                    d2 = this.GetNextNormDataPoint(-1);
                }
                this.myInfo.MinVal = this.myInfo.newMinVal;
                this.myInfo.MaxVal = this.myInfo.newMaxVal;
                this.myInfo.ValScale = 1.0 / (this.myInfo.MaxVal - this.myInfo.MinVal);
            }
            graphics.setColor(Color.white);
            n3 = this.InitDataPoints(-1);
            for (n = 0; n < n3; ++n) {
                d2 = this.GetNextNormDataPoint(-1);
                this.drawDataPoint(graphics, rectangle, d2, n, n2, n4, false);
                if (n2 != n) continue;
                d = this.data3d.ValueAt((int)this.c2.PositionValue, (int)this.c3.PositionValue, (int)this.c1.PositionValue, n);
            }
            for (n = 0; n < this.data3d.NumMarkerLists(); ++n) {
                if (this.data3d.NumMarkers(n) <= 0) continue;
                if (this.normalize) {
                    n3 = this.InitDataPoints(-1);
                    for (int i = 0; i < n3; ++i) {
                        d2 = this.GetNextNormDataPoint(n);
                    }
                    this.myInfo.MinVal = this.myInfo.newMinVal;
                    this.myInfo.MaxVal = this.myInfo.newMaxVal;
                    this.myInfo.ValScale = 1.0 / (this.myInfo.MaxVal - this.myInfo.MinVal);
                }
                Color color = new Color(this.data3d.GetPoint((int)0, (int)n).mycolor);
                graphics.setColor(color);
                n3 = this.InitDataPoints(-1);
                for (int i = 0; i < n3; ++i) {
                    d2 = this.GetNextNormDataPoint(n);
                    this.drawDataPoint(graphics, rectangle, d2, i, n2, n4, false);
                }
            }
        } else {
            string = this.data3d.TrackDirections[this.data3d.TrackDirection];
            n = (int)this.c2.PositionValue;
            int n6 = (int)this.c3.PositionValue;
            int n7 = (int)this.c1.PositionValue;
            int n8 = this.data3d.ActiveElement;
            int n9 = this.data3d.ActiveTime;
            for (int i = 0; i < this.data3d.NumMarkerLists(); ++i) {
                double d3;
                if (this.data3d.NumMarkers(i) <= 0) continue;
                n3 = this.InitDataPoints(i);
                for (int j = 0; j < n3; ++j) {
                    d3 = this.GetNextNormDataPoint(i);
                    this.data3d.CheckActiveMarker(i, j, n, n6, n7, n8, n9);
                }
                if (this.normalize) {
                    this.myInfo.MinVal = this.myInfo.newMinVal;
                    this.myInfo.MaxVal = this.myInfo.newMaxVal;
                    this.myInfo.ValScale = 1.0 / (this.myInfo.MaxVal - this.myInfo.MinVal);
                }
                Color color = new Color(this.data3d.GetPoint((int)0, (int)i).mycolor);
                graphics.setColor(color);
                n3 = this.InitDataPoints(i);
                for (int j = 0; j < n3; ++j) {
                    d3 = this.GetNextNormDataPoint(i);
                    boolean bl = this.data3d.MarkerDisplayed(this.data3d.GetPoint(j, i), n7, n9);
                    double d4 = this.data3d.GetPoint((int)j, (int)i).coord[this.data3d.TrackDirection];
                    double d5 = this.data3d.GetPoint((int)this.data3d.ActiveMarkerPos(), (int)i).coord[this.data3d.TrackDirection];
                    if (i == this.data3d.ActiveMarkerListPos() && j == this.data3d.ActiveMarkerPos()) {
                        graphics.setColor(Color.white);
                        d = this.pval;
                    } else {
                        graphics.setColor(color);
                        d5 = -1.0E10;
                    }
                    this.drawDataPoint(graphics, rectangle, d3, d4, d5, this.data3d.GetSize(this.data3d.TrackDirection), bl);
                }
            }
        }
        graphics.setColor(Color.white);
        graphics.drawString(this.TextToDisplay, 12, 12);
        graphics.drawString(string, rectangle.width - string.length() * 9, rectangle.height - 15);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(4);
        numberFormat.setGroupingUsed(false);
        graphics.drawString(numberFormat.format(d), 12, rectangle.height - 20);
    }

    public void SetTrackDirVal(int n) {
        if (n >= this.data3d.GetSize(this.data3d.TrackDirection)) {
            n = this.data3d.GetSize(this.data3d.TrackDirection) - 1;
        }
        if (n < 0) {
            n = 0;
        }
        switch (this.data3d.TrackDirection) {
            case 0: {
                this.c3.PositionValue = n;
                break;
            }
            case 1: {
                this.c2.PositionValue = n;
                break;
            }
            case 2: {
                this.c1.PositionValue = n;
                break;
            }
            case 3: {
                this.data3d.setElement(n);
            }
            case 4: {
                this.data3d.setTime(n);
            }
        }
    }

    public int GetTrackDirVal() {
        switch (this.data3d.TrackDirection) {
            case 0: {
                return (int)this.c3.PositionValue;
            }
            case 1: {
                return (int)this.c2.PositionValue;
            }
            case 2: {
                return (int)this.c1.PositionValue;
            }
            case 3: {
                return this.data3d.ActiveElement;
            }
            case 4: {
                return this.data3d.ActiveTime;
            }
        }
        return 0;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.MyPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        Rectangle rectangle = this.getBounds();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.PlotMode <= 1) {
            int n3 = this.data3d.GetNumElements();
            int n4 = n * n3 / rectangle.width;
            this.data3d.setElement(n4);
        } else if (this.PlotMode > 1) {
            int n5 = (int)((double)(n * this.data3d.GetSize(this.data3d.TrackDirection) / rectangle.width) + 0.5);
            this.SetTrackDirVal(n5);
        }
        this.c1.UpdateAll();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.MyPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c;
        block9: {
            block10: {
                block8: {
                    c = keyEvent.getKeyChar();
                    if (this.PlotMode > 1) break block8;
                    if (39 == keyEvent.getKeyCode()) {
                        this.c1.my3ddata.advanceElement(1);
                        this.c1.UpdateAll();
                        return;
                    }
                    if (37 == keyEvent.getKeyCode()) {
                        this.c1.my3ddata.advanceElement(-1);
                        this.c1.UpdateAll();
                        return;
                    }
                    break block9;
                }
                if (39 == keyEvent.getKeyCode()) break block10;
                if (37 != keyEvent.getKeyCode()) break block9;
            }
            int n = this.GetTrackDirVal();
            if (39 == keyEvent.getKeyCode()) {
                ++n;
            }
            if (37 == keyEvent.getKeyCode()) {
                --n;
            }
            this.SetTrackDirVal(n);
            this.c1.UpdateAll();
            return;
        }
        this.ProcessKey(c);
    }

    public void ProcessKey(char c) {
        switch (c) {
            case 's': {
                this.c1.myPanel.label.remove(this);
                GridLayout gridLayout = new GridLayout(1, 2);
                this.c1.myPanel.label.setLayout(gridLayout);
                this.c1.myPanel.label.doLayout();
                AlternateViewer alternateViewer = new AlternateViewer(this.c1.applet);
                alternateViewer.AssignPixelDisplay(this);
                return;
            }
            case 'q': {
                this.PlotMode = (this.PlotMode + 1) % 6;
                this.repaint();
                break;
            }
            case 'n': {
                this.normalize = !this.normalize;
                this.repaint();
                break;
            }
            case 'N': {
                this.data3d.ValueUnitsDialog();
                this.data3d.InvalidateProjs(-1);
                this.c1.label.CoordsChanged();
                this.c1.UpdateAll();
                break;
            }
            case 'm': {
                if (this.data3d.markerOutfilename != null) {
                    this.data3d.SaveMarkers();
                }
                this.c1.label.PrintPointList();
                break;
            }
            case 'M': {
                this.data3d.MarkerDialog();
                break;
            }
            case 'O': {
                this.logmode = !this.logmode;
                this.repaint();
                break;
            }
            case '1': {
                if (this.mindispl < this.maxdispl - 0.01) {
                    this.mindispl += 0.01;
                }
                this.repaint();
                break;
            }
            case '2': {
                this.mindispl -= 0.01;
                this.repaint();
                break;
            }
            case '3': {
                this.maxdispl += 0.02;
                this.repaint();
                break;
            }
            case '4': {
                if (this.mindispl < this.maxdispl - 0.02) {
                    this.maxdispl -= 0.02;
                }
                this.repaint();
                break;
            }
            case '5': {
                if (this.mindispl < this.maxdispl - 0.001) {
                    this.mindispl += 0.001;
                }
                this.repaint();
                break;
            }
            case '6': {
                this.mindispl -= 0.001;
                this.repaint();
                break;
            }
            case '7': {
                this.maxdispl += 0.002;
                this.repaint();
                break;
            }
            case '8': {
                if (this.mindispl < this.maxdispl - 0.002) {
                    this.maxdispl -= 0.002;
                }
                this.repaint();
                break;
            }
            case 'i': {
                this.maxdispl = 1.0;
                this.mindispl = 0.0;
                this.repaint();
                break;
            }
            case 'X': {
                if (!(this.c1.applet instanceof View5D_)) break;
                this.data3d.Export(-1, -1);
                break;
            }
            default: {
                this.c1.ProcessKey(c);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

