/*
 * Decompiled with CFR 0.152.
 */
class FloatElement
extends AnElement {
    float[] myData;
    int SizeXY;

    FloatElement(int n, int n2, int n3, float f) {
        super(n, n2, n3, f);
        this.myData = new float[this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
        this.SizeXY = this.Sizes[0] * this.Sizes[1];
        AnElement.DataType = AnElement.FloatType;
    }

    void Clear() {
        for (int i = 0; i < this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0.0f;
        }
    }

    void DeleteData() {
        this.myData = null;
    }

    int GetStdByteNum() {
        return 4;
    }

    void SetValueAt(int n, int n2, int n3, double d) {
        this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] = (float)d;
    }

    int GetIntValueAt(int n, int n2, int n3) {
        return (int)(((double)this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] - this.shift) * this.scaleI);
    }

    int GetByteValueAt(int n, int n2, int n3) {
        return (int)(((double)this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] - this.shift) * this.scaleB);
    }

    double GetRawValueAt(int n, int n2, int n3) {
        return this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3];
    }

    double GetValueAt(int n, int n2, int n3) {
        return (double)this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] * this.ScaleV + this.OffsetV;
    }

    void ConvertSliceFromSimilar(int n, int n2, Object object, int n3, int n4) {
        float[] fArray = (float[])object;
        for (int i = 0; i < this.SizeXY; i += n3) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * n] = fArray[n2 * this.SizeXY + i + n4];
        }
    }

    void ConvertSliceFromByte(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 4 * this.SizeXY;
        for (int i = 0; i < this.SizeXY; i += n3) {
            float f;
            int n6 = 0;
            for (int j = 1; j < 4; ++j) {
                int n7 = byArray[n2 * n5 + 4 * (i + n4) + j] & 0xFF;
                n6 |= n7 << 8 * j;
            }
            this.myData[i + this.SizeXY * n] = f = Float.intBitsToFloat(n6);
        }
    }

    void ConvertSliceFromRGB(int n, int n2, int[] nArray, int n3, int n4, int n5) {
        throw new IllegalArgumentException("Int: Inapplicable conversion\n");
    }

    void CopySliceToSimilar(int n, Object object) {
        float[] fArray = (float[])object;
        for (int i = 0; i < this.SizeXY; ++i) {
            fArray[i] = this.myData[i + this.Sizes[0] * this.Sizes[1] * n];
        }
    }
}

