%PSNR   Peak Signal-to-Noise Ratio in dB
%
% SYNOPSIS:
%  function result = psnr(img, org)
%
% PARAMETERS:
%  img = test image (<= 3D)
%  org = reference image -> PSNR from mean squared error (optional)
%        OR a maximum value -> PSNR from estimated noise & given max

% (C) Copyright 1999-2003               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Tuan Pham, December 2003.
function out = psnr(img, org)

% handle automatic probing from DIPimage menu
if nargin == 1
   if ischar(img) & strcmp(img,'DIP_GetParamList')
      out = struct('menu','none');
      return
   end
end


if nargin>1 
   % PSNR based on the original image
   if strcmp(class(org),'dip_image')==1
      out = 10*log10(max(org)^2/mean((img-org)^2));
      
   % PSNR based on estimated noise and given max value
   elseif strcmp(class(org),'double')==1
      std_noise = noisestd(img)
      out = 20*log10(org/std_noise);
   end
else
   % estimate (Gaussian) noise and max value from the image
   std_noise = noisestd(img)
   out = 20*log10(max(img)/std_noise);
end