%CUT   Cuts/crops an image symmetrically around the center
%
% SYNOPSIS:
%  out = cut(in,newsize)
%
% PARAMETERS:
%  in:  input image
%  newsize:  new image size
%
% EXAMPLE:
%  a=readim
%  cut(a,[300 100]) %symmetric cut
%  a(:,0:99) %cut from upper left corner
%
% SEE ALSO:
%  extend,

% (C) Copyright 2004-2007      Department of Molecular Biology
%     All rights reserved      Max-Planck-Institute for Biophysical Chemistry
%                              Am Fassberg 11, 37077 G"ottingen
%                              Germany
%
% Bernd Rieger, Sep 2004.
% 9 April 2007, Rewrote to use SUBSREF instead of EVAL. (CL)

function out = cut(varargin)
d = struct('menu','Manipulation',...
   'display','Cut (cropping)',...
   'inparams',struct('name', {'in','bor'},...
         'description',{'Input image','New image size'},...
         'type',       {'image','array'},...
         'dim_check',  {0,1},...
         'range_check',{[],'N+'},...
         'required',   {1,1},...
         'default',    {'a','256'}...
        ),...
   'outparams',struct('name',{'out'},...
                      'description',{'Output image'},...
                      'type',{'image'}...
                      )...
       );
if nargin == 1
   s = varargin{1};
   if ischar(s) & strcmp(s,'DIP_GetParamList')
      out = d;
      return
   end
end
try
   [in,bor] = getparams(d,varargin{:});
catch
   if ~isempty(paramerror)
      error(paramerror)
   else
      error(firsterr)
   end
end
if ~isscalar(in)
   error('Only implemented for scalar (grey-value) images.');
end
sz = imsize(in);
N  = length(sz);

tmp = bor >= sz;
bor(tmp) = sz(tmp);  %if newsize > oldsize do nothing
if all(tmp)
   out = in;
   return;
end

start = round((sz-bor)./2)'; %start coord
stop = round((sz+bor)./2-1)';%end coord

s = substruct('()',{});
for ii = 1:N
   s.subs{ii} = start(ii):stop(ii);
end
out = subsref(in,s);
