%OUT = COMPUTE1ARRAY(OPERATION,IN)
%    This applies COMPUTE1 on each image IN{ii}.
%OUT = COMPUTE1ARRAY(OPERATION,IN,OUT_DIP_TYPE)
%    Use this if the type returned by DO1INPUT is not correct.
%
%    This function should be called after DOARRAYINPUTS if the ARRAYOP
%    flag returned was non-zero (true).

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, November 2000.
% 18 December 2001: Color information is not as volitile anymore.
% 10 March 2008: Fixed bug. COMPUTE1 has a new PHYSDIMS input parameter.

function out = compute1array(operation,in,dip_type)
if nargin < 2
   error('Erroneus input.')
elseif nargin == 2
   dip_type = '';
end
s = imarsize(in);
N = prod(s);
out = dip_image('array',s);
if iscolor(in)
   col = in(1).color;
else
   col = '';
end
if isempty(dip_type)
   for ii=1:N
      out(ii) = compute1(operation,in(ii));
      out(ii).color = col;
    end
else
   for ii=1:N
      out(ii) = compute1(operation,in(ii).data,in(ii).dims,dip_type,in(ii).physDims);
      out(ii).color = col;
   end
end
