%FIND   Find indices of nonzero elements.
%   I = FIND(B) returns the indices of the image B that are
%   non-zero.
%
%   [I,V] = FIND(B) also returns a 1-D image containing the
%   nonzero pixels in B.  Note that find(B) and find(B~=0)
%   will produce the same I, but the latter will produce a
%   V with all 1's.
%
%   See also FINDCOORD.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, July 2000.

function [varargout] = find(in)
if ~isscalar(in), error('Parameter "in" is an array of images.'); end
try
   I = find(in.data);
   varargout{1} = I-1;
   if nargout > 1
      varargout{2} = dip_image(in.data(I),in.dip_type);
   end
catch
   error(di_firsterr)
end
