/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FloatStatistics
extends ImageStatistics {
    public FloatStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public FloatStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        double d;
        double d2;
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.setup(imageProcessor, calibration);
        double d3 = imageProcessor.getMinThreshold();
        if ((n & 0x100) == 0 || d3 == -808080.0) {
            d2 = -3.4028234663852886E38;
            d = 3.4028234663852886E38;
        } else {
            d2 = d3;
            d = imageProcessor.getMaxThreshold();
        }
        this.getStatistics(imageProcessor, d2, d);
        if ((n & 8) != 0) {
            this.getMode();
        }
        if ((n & 0x800) != 0) {
            this.fitEllipse(imageProcessor);
        } else if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor, d2, d);
        }
        if ((n & 0x40) != 0) {
            this.getCenterOfMass(imageProcessor, d2, d);
        }
    }

    void getStatistics(ImageProcessor imageProcessor, double d, double d2) {
        double d3;
        int n;
        float[] fArray = (float[])imageProcessor.getPixels();
        this.nBins = imageProcessor.getHistogramSize();
        this.histogram = new int[this.nBins];
        double d4 = 0.0;
        double d5 = 0.0;
        int[] nArray = imageProcessor.getMask();
        double d6 = Double.MAX_VALUE;
        double d7 = -1.7976931348623157E308;
        double d8 = Double.MAX_VALUE;
        double d9 = -1.7976931348623157E308;
        int n2 = this.ry;
        int n3 = 0;
        while (n2 < this.ry + this.rh) {
            int n4 = n2 * this.width + this.rx;
            int n5 = n3 * this.rw;
            n = this.rx;
            while (n < this.rx + this.rw) {
                if ((nArray == null || nArray[n5++] == -16777216) && (d3 = (double)fArray[n4]) >= d && d3 <= d2) {
                    if (d3 < d6) {
                        d6 = d3;
                    }
                    if (d3 > d7) {
                        d7 = d3;
                    }
                }
                ++n4;
                ++n;
            }
            ++n2;
            ++n3;
        }
        this.min = d6;
        this.max = d7;
        this.histMin = this.min;
        this.histMax = this.max;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double d10 = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        int n6 = this.ry;
        int n7 = 0;
        while (n6 < this.ry + this.rh) {
            int n8 = n6 * this.width + this.rx;
            int n9 = n7 * this.rw;
            int n10 = this.rx;
            while (n10 < this.rx + this.rw) {
                if ((nArray == null || nArray[n9++] == -16777216) && (d3 = (double)fArray[n8]) >= d && d3 <= d2) {
                    ++this.pixelCount;
                    d4 += d3;
                    d5 += d3 * d3;
                    n = (int)(d10 * (d3 - this.histMin));
                    if (n >= this.nBins) {
                        n = this.nBins - 1;
                    }
                    int n11 = n;
                    this.histogram[n11] = this.histogram[n11] + 1;
                }
                ++n8;
                ++n10;
            }
            ++n6;
            ++n7;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = d4 / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, d4, d5);
    }

    void getMode() {
        this.maxCount = 0;
        int n = 0;
        while (n < this.nBins) {
            int n2 = this.histogram[n];
            if (n2 > this.maxCount) {
                this.maxCount = n2;
                this.mode = n;
            }
            ++n;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
    }

    void getCenterOfMass(ImageProcessor imageProcessor, double d, double d2) {
        float[] fArray = (float[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = this.ry;
        int n2 = 0;
        while (n < this.ry + this.rh) {
            int n3 = n * this.width + this.rx;
            int n4 = n2 * this.rw;
            int n5 = this.rx;
            while (n5 < this.rx + this.rw) {
                double d6;
                if ((nArray == null || nArray[n4++] == -16777216) && (d6 = (double)fArray[n3] + Double.MIN_VALUE) >= d && d6 <= d2) {
                    d3 += d6;
                    d4 += (double)n5 * d6;
                    d5 += (double)n * d6;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
        this.xCenterOfMass = (d4 / d3 + 0.5) * this.pw;
        this.yCenterOfMass = (d5 / d3 + 0.5) * this.ph;
    }

    void getCentroid(ImageProcessor imageProcessor, double d, double d2) {
        float[] fArray = (float[])imageProcessor.getPixels();
        int[] nArray = imageProcessor.getMask();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = this.ry;
        int n2 = 0;
        while (n < this.ry + this.rh) {
            int n3 = n * this.width + this.rx;
            int n4 = n2 * this.rw;
            int n5 = this.rx;
            while (n5 < this.rx + this.rw) {
                double d6;
                if ((nArray == null || nArray[n4++] == -16777216) && (d6 = (double)fArray[n3]) >= d && d6 <= d2) {
                    d3 += 1.0;
                    d4 += (double)n5;
                    d5 += (double)n;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
        this.xCentroid = (d4 / d3 + 0.5) * this.pw;
        this.yCentroid = (d5 / d3 + 0.5) * this.ph;
    }
}

