/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import ij.io.RandomAccessStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class TiffDecoder {
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTO_INTERP = 262;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int STRIP_OFFSETS = 273;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNT = 279;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int RESOLUTION_UNIT = 296;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int COLOR_MAP = 320;
    public static final int SAMPLE_FORMAT = 339;
    public static final int METAMORPH1 = 33628;
    public static final int IPLAB = 34122;
    public static final int NIH_IMAGE_HDR = 43314;
    static final int UNSIGNED = 1;
    static final int SIGNED = 2;
    static final int FLOATING_POINT = 3;
    static final int SHORT = 3;
    static final int LONG = 4;
    private String directory;
    private String name;
    private String url;
    protected RandomAccessStream in;
    protected boolean debugMode;
    private boolean littleEndian;
    private String dInfo;
    private int ifdCount;

    public TiffDecoder(String string, String string2) {
        this.directory = string;
        this.name = string2;
    }

    public TiffDecoder(InputStream inputStream, String string) {
        this.directory = "";
        this.name = string;
        this.url = "";
        this.in = new RandomAccessStream(inputStream);
    }

    final int getInt() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    int getShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (this.littleEndian) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    int OpenImageFileHeader() throws IOException {
        short s = this.in.readShort();
        if (s == 18761) {
            this.littleEndian = true;
        } else if (s == 19789) {
            this.littleEndian = false;
        } else {
            this.in.close();
            return -1;
        }
        int n = this.getShort();
        int n2 = this.getInt();
        return n2;
    }

    int getValue(int n, int n2) throws IOException {
        int n3 = 0;
        if (n == 3 && n2 == 1) {
            n3 = this.getShort();
            int n4 = this.getShort();
        } else {
            n3 = this.getInt();
        }
        return n3;
    }

    void getColorMap(int n, FileInfo fileInfo) throws IOException {
        byte[] byArray = new byte[1536];
        int n2 = this.in.getFilePointer();
        this.in.seek(n);
        this.in.readFully(byArray);
        this.in.seek(n2);
        fileInfo.lutSize = 256;
        fileInfo.reds = new byte[256];
        fileInfo.greens = new byte[256];
        fileInfo.blues = new byte[256];
        int n3 = 0;
        if (this.littleEndian) {
            ++n3;
        }
        int n4 = 0;
        while (n4 < 256) {
            fileInfo.reds[n4] = byArray[n3];
            fileInfo.greens[n4] = byArray[512 + n3];
            fileInfo.blues[n4] = byArray[1024 + n3];
            n3 += 2;
            ++n4;
        }
        fileInfo.fileType = 5;
    }

    byte[] getString(int n, int n2) throws IOException {
        if (--n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n3 = this.in.getFilePointer();
        this.in.seek(n2);
        this.in.readFully(byArray);
        this.in.seek(n3);
        return byArray;
    }

    public void decodeImageDescription(byte[] byArray, FileInfo fileInfo) {
        if (byArray.length < 7) {
            return;
        }
        if (IJ.debugMode) {
            IJ.log("Image Description: " + new String(byArray).replace('\n', ' '));
        }
        if (!new String(byArray, 0, 6).equals("ImageJ")) {
            return;
        }
        fileInfo.description = new String(byArray);
    }

    void decodeNIHImageHeader(int n, FileInfo fileInfo) throws IOException {
        int n2;
        int n3;
        int n4 = this.in.getFilePointer();
        this.in.seek(n + 12);
        short s = this.in.readShort();
        this.in.seek(n + 160);
        double d = this.in.readDouble();
        if (s > 106 && d != 0.0) {
            fileInfo.pixelHeight = fileInfo.pixelWidth = 1.0 / d;
        }
        this.in.seek(n + 172);
        int n5 = this.in.readShort();
        if (s <= 153) {
            n5 += 5;
        }
        switch (n5) {
            case 5: {
                fileInfo.unit = "nanometer";
                break;
            }
            case 6: {
                fileInfo.unit = "micrometer";
                break;
            }
            case 7: {
                fileInfo.unit = "mm";
                break;
            }
            case 8: {
                fileInfo.unit = "cm";
                break;
            }
            case 9: {
                fileInfo.unit = "meter";
                break;
            }
            case 10: {
                fileInfo.unit = "km";
                break;
            }
            case 11: {
                fileInfo.unit = "inch";
                break;
            }
            case 12: {
                fileInfo.unit = "ft";
                break;
            }
            case 13: {
                fileInfo.unit = "mi";
            }
        }
        this.in.seek(n + 182);
        int n6 = this.in.read();
        int n7 = this.in.read();
        short s2 = this.in.readShort();
        if (n6 == 11) {
            fileInfo.calibrationFunction = 21;
            fileInfo.valueUnit = "U. OD";
        } else if (n6 >= 0 && n6 <= 8 && s2 >= 1 && s2 <= 5) {
            switch (n6) {
                case 0: {
                    fileInfo.calibrationFunction = 0;
                    break;
                }
                case 1: {
                    fileInfo.calibrationFunction = 1;
                    break;
                }
                case 2: {
                    fileInfo.calibrationFunction = 2;
                    break;
                }
                case 3: {
                    fileInfo.calibrationFunction = 3;
                    break;
                }
                case 5: {
                    fileInfo.calibrationFunction = 4;
                    break;
                }
                case 6: {
                    fileInfo.calibrationFunction = 5;
                    break;
                }
                case 7: {
                    fileInfo.calibrationFunction = 6;
                    break;
                }
                case 8: {
                    fileInfo.calibrationFunction = 7;
                }
            }
            fileInfo.coefficients = new double[s2];
            n3 = 0;
            while (n3 < s2) {
                fileInfo.coefficients[n3] = this.in.readDouble();
                ++n3;
            }
            this.in.seek(n + 234);
            n2 = this.in.read();
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 >= 1 && n2 <= 16) {
                int n8 = 0;
                while (n8 < n2) {
                    stringBuffer.append((char)this.in.read());
                    ++n8;
                }
                fileInfo.valueUnit = new String(stringBuffer);
            } else {
                fileInfo.valueUnit = " ";
            }
        }
        this.in.seek(n + 260);
        n3 = this.in.readShort();
        if (n3 >= 2 && (fileInfo.fileType == 0 || fileInfo.fileType == 5)) {
            fileInfo.nImages = n3;
            fileInfo.pixelDepth = this.in.readFloat();
            n2 = this.in.readShort();
            fileInfo.frameInterval = this.in.readFloat();
        }
        this.in.seek(n + 272);
        float f = this.in.readFloat();
        if (s > 140 && (double)f != 0.0) {
            fileInfo.pixelHeight = fileInfo.pixelWidth / (double)f;
        }
        this.in.seek(n4);
    }

    void dumpTag(int n, int n2, int n3, FileInfo fileInfo) {
        String string;
        switch (n) {
            case 254: {
                string = "NewSubfileType";
                break;
            }
            case 256: {
                string = "ImageWidth";
                break;
            }
            case 257: {
                string = "ImageLength";
                break;
            }
            case 273: {
                string = "StripOffsets";
                break;
            }
            case 262: {
                string = "PhotoInterp";
                break;
            }
            case 270: {
                string = "ImageDescription";
                break;
            }
            case 258: {
                string = "BitsPerSample";
                break;
            }
            case 277: {
                string = "SamplesPerPixel";
                break;
            }
            case 278: {
                string = "RowsPerStrip";
                break;
            }
            case 279: {
                string = "StripByteCount";
                break;
            }
            case 282: {
                string = "XResolution";
                break;
            }
            case 283: {
                string = "YResolution";
                break;
            }
            case 296: {
                string = "ResolutionUnit";
                break;
            }
            case 305: {
                string = "Software";
                break;
            }
            case 306: {
                string = "DateTime";
                break;
            }
            case 284: {
                string = "PlanarConfiguration";
                break;
            }
            case 259: {
                string = "Compression";
                break;
            }
            case 320: {
                string = "ColorMap";
                break;
            }
            case 339: {
                string = "SampleFormat";
                break;
            }
            case 43314: {
                string = "NIHImageHeader";
                break;
            }
            default: {
                string = "???";
            }
        }
        String string2 = n2 == 1 ? "" : ", count=" + n2;
        this.dInfo = this.dInfo + "    " + n + ", \"" + string + "\", value=" + n3 + string2 + "\n";
    }

    double getRational(int n) throws IOException {
        int n2 = this.in.getFilePointer();
        this.in.seek(n);
        int n3 = this.getInt();
        int n4 = this.getInt();
        this.in.seek(n2);
        if (n4 != 0) {
            return (double)n3 / (double)n4;
        }
        return 0.0;
    }

    FileInfo OpenIFD() throws IOException {
        int n = this.getShort();
        if (n < 1) {
            return null;
        }
        ++this.ifdCount;
        FileInfo fileInfo = new FileInfo();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.getShort();
            int n4 = this.getShort();
            int n5 = this.getInt();
            int n6 = this.getValue(n4, n5);
            if (this.debugMode) {
                this.dumpTag(n3, n5, n6, fileInfo);
            }
            switch (n3) {
                case 256: {
                    fileInfo.width = n6;
                    break;
                }
                case 257: {
                    fileInfo.height = n6;
                    break;
                }
                case 273: {
                    if (n5 == 1) {
                        fileInfo.offset = n6;
                        break;
                    }
                    int n7 = this.in.getFilePointer();
                    this.in.seek(n6);
                    fileInfo.offset = this.getInt();
                    this.in.seek(n7);
                    break;
                }
                case 262: {
                    fileInfo.whiteIsZero = n6 == 0;
                    break;
                }
                case 258: {
                    if (n5 == 1) {
                        if (n6 == 8) {
                            fileInfo.fileType = 0;
                            break;
                        }
                        if (n6 == 16) {
                            fileInfo.fileType = 2;
                            fileInfo.intelByteOrder = this.littleEndian;
                            break;
                        }
                        if (n6 == 32) {
                            fileInfo.fileType = 3;
                            fileInfo.intelByteOrder = this.littleEndian;
                            break;
                        }
                        if (n6 == 1) {
                            fileInfo.fileType = 8;
                            break;
                        }
                        throw new IOException("Unsupported BitsPerSample: " + n6);
                    }
                    if (n5 != 3) break;
                    int n8 = this.in.getFilePointer();
                    this.in.seek(n6);
                    if (this.getShort() != 8) {
                        throw new IOException("ImageJ can only open 8-bit/channel RGB images");
                    }
                    this.in.seek(n8);
                    break;
                }
                case 277: {
                    if (n6 == 3) {
                        fileInfo.fileType = 6;
                        break;
                    }
                    if (n6 == 1) break;
                    throw new IOException("Unsupported SamplesPerPixel: " + n6);
                }
                case 282: {
                    double d = this.getRational(n6);
                    if (d == 0.0) break;
                    fileInfo.pixelWidth = 1.0 / d;
                    break;
                }
                case 283: {
                    double d = this.getRational(n6);
                    if (d == 0.0) break;
                    fileInfo.pixelHeight = 1.0 / d;
                    break;
                }
                case 296: {
                    if (n6 == 1 && fileInfo.unit == null) {
                        fileInfo.unit = " ";
                        break;
                    }
                    if (n6 == 2) {
                        fileInfo.unit = "inch";
                        break;
                    }
                    if (n6 != 3) break;
                    fileInfo.unit = "cm";
                    break;
                }
                case 284: {
                    if (n6 != 2 || fileInfo.fileType != 6) break;
                    fileInfo.fileType = 7;
                    break;
                }
                case 259: {
                    if (n6 == 1 || n6 == 7) break;
                    throw new IOException("ImageJ cannot open compressed TIFF files (" + n6 + ")");
                }
                case 320: {
                    if (n5 != 768 || fileInfo.fileType != 0) break;
                    this.getColorMap(n6, fileInfo);
                    break;
                }
                case 339: {
                    if (fileInfo.fileType == 3 && n6 == 3) {
                        fileInfo.fileType = 4;
                    }
                    if (fileInfo.fileType != 2 || n6 != 2) break;
                    fileInfo.fileType = 1;
                    break;
                }
                case 270: {
                    byte[] byArray;
                    if (this.ifdCount != 1 || (byArray = this.getString(n5, n6)) == null) break;
                    this.decodeImageDescription(byArray, fileInfo);
                    break;
                }
                case 33628: {
                    if (this.name.indexOf(".STK") <= 0 && this.name.indexOf(".stk") <= 0) break;
                    fileInfo.nImages = 9999;
                    break;
                }
                case 34122: {
                    fileInfo.nImages = n6;
                    break;
                }
                case 43314: {
                    if (n5 != 256) break;
                    this.decodeNIHImageHeader(n6, fileInfo);
                    break;
                }
            }
            ++n2;
        }
        fileInfo.fileFormat = 2;
        fileInfo.fileName = this.name;
        fileInfo.directory = this.directory;
        if (this.url != null) {
            fileInfo.url = this.url;
        }
        if (this.debugMode) {
            this.dInfo = this.dInfo + "    offset=" + fileInfo.offset + "\n";
        }
        return fileInfo;
    }

    public void enableDebugging() {
        this.debugMode = true;
    }

    public FileInfo[] getTiffInfo() throws IOException {
        FileInfo[] fileInfoArray;
        if (this.in == null) {
            this.in = new RandomAccessStream(new RandomAccessFile(this.directory + this.name, "r"));
        }
        Vector<FileInfo[]> vector = new Vector<FileInfo[]>();
        int n = this.OpenImageFileHeader();
        if (n < 0) {
            this.in.close();
            return null;
        }
        if (this.debugMode) {
            this.dInfo = "\n  " + this.name + ": opening\n";
        }
        while (n > 0) {
            this.in.seek(n);
            fileInfoArray = this.OpenIFD();
            if (fileInfoArray != null) {
                vector.addElement(fileInfoArray);
            }
            n = this.getInt();
            if (this.debugMode) {
                this.dInfo = this.dInfo + "  nextIFD=" + n + "\n";
            }
            if (fileInfoArray == null || fileInfoArray.nImages <= 1) continue;
            n = 0;
        }
        if (vector.size() == 0) {
            this.in.close();
            return null;
        }
        fileInfoArray = new FileInfo[vector.size()];
        vector.copyInto(fileInfoArray);
        if (this.debugMode) {
            fileInfoArray[0].info = this.dInfo;
        }
        if (this.url != null) {
            this.in.seek(0);
            fileInfoArray[0].inputStream = this.in;
        } else {
            this.in.close();
        }
        return fileInfoArray;
    }
}

