/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.Menus;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.io.ImportDialog;
import ij.io.OpenDialog;
import ij.plugin.Animator;
import ij.plugin.GelAnalyzer;
import ij.plugin.JpegWriter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.ParticleAnalyzer;
import ij.process.FloatBlitter;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Prefs {
    public static final String PROPS_NAME = "IJ_Props.txt";
    public static final String PREFS_NAME = "IJ_Prefs.txt";
    public static final String DIR_IMAGE = "dir.image";
    public static final String FCOLOR = "fcolor";
    public static final String BCOLOR = "bcolor";
    public static final String ROICOLOR = "roicolor";
    public static final String JPEG = "jpeg";
    public static final String FPS = "fps";
    public static final String DIV_BY_ZERO_VALUE = "div-by-zero";
    private static final int USE_POINTER = 1;
    private static final int ANTIALIASING = 2;
    private static final int INTERPOLATE = 4;
    private static final int ONE_HUNDRED_PERCENT = 8;
    public static final String OPTIONS = "prefs.options";
    public static String separator = System.getProperty("file.separator");
    public static boolean usePointerCursor;
    public static boolean antialiasedText;
    public static boolean interpolateScaledImages;
    public static boolean open100Percent;
    static Properties prefs;
    static Properties props;
    static String prefsDir;
    static String imagesURL;
    static String homeDir;

    public static String load(Object object, Applet applet) {
        InputStream inputStream = object.getClass().getResourceAsStream("/IJ_Props.txt");
        if (applet != null) {
            return Prefs.loadAppletProps(inputStream, applet);
        }
        homeDir = System.getProperty("user.dir");
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("os.name");
        prefsDir = string2.indexOf("Windows", 0) > -1 ? homeDir : string;
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(homeDir + "/" + PROPS_NAME);
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = null;
            }
        }
        if (inputStream == null) {
            return "IJ_Props.txt not found in ij.jar or in " + homeDir;
        }
        inputStream = new BufferedInputStream(inputStream);
        try {
            props.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            return "Error loading IJ_Props.txt";
        }
        imagesURL = props.getProperty("images.location");
        Prefs.loadPreferences();
        Prefs.loadOptions();
        return null;
    }

    static String loadAppletProps(InputStream inputStream, Applet applet) {
        if (inputStream == null) {
            return "IJ_Props.txt not found in ij.jar";
        }
        try {
            props.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            return "Error loading IJ_Props.txt";
        }
        try {
            URL uRL = new URL(applet.getDocumentBase(), "images/");
            imagesURL = uRL.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getImagesURL() {
        return imagesURL;
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static String getString(String string) {
        return props.getProperty(string);
    }

    public static boolean getBoolean(String string, boolean bl) {
        if (props == null) {
            return bl;
        }
        String string2 = props.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    public static int getInt(String string, int n) {
        if (props == null) {
            return n;
        }
        String string2 = props.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                IJ.write("" + numberFormatException);
            }
        }
        return n;
    }

    public static double getDouble(String string, double d) {
        if (props == null) {
            return d;
        }
        String string2 = props.getProperty(string);
        Double d2 = null;
        if (string2 != null) {
            try {
                d2 = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = null;
            }
            if (d2 != null) {
                return d2;
            }
        }
        return d;
    }

    public static Color getColor(String string, Color color) {
        int n = Prefs.getInt(string, 2730);
        if (n == 2730) {
            return color;
        }
        return new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static String getFileSeparator() {
        return separator;
    }

    static void loadPreferences() {
        String string = prefsDir + separator + PREFS_NAME;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            prefs.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            return;
        }
    }

    static void savePreferences() {
        try {
            Properties properties = new Properties();
            String string = OpenDialog.getDefaultDirectory();
            if (string != null) {
                ((Hashtable)properties).put(DIR_IMAGE, Prefs.escapeBackSlashes(string));
            }
            ((Hashtable)properties).put(ROICOLOR, Tools.c2hex(Roi.getColor()));
            ((Hashtable)properties).put(FCOLOR, Tools.c2hex(Toolbar.getForegroundColor()));
            ((Hashtable)properties).put(BCOLOR, Tools.c2hex(Toolbar.getBackgroundColor()));
            ((Hashtable)properties).put(JPEG, Integer.toString(JpegWriter.getQuality()));
            ((Hashtable)properties).put(FPS, Double.toString(Animator.getFrameRate()));
            ((Hashtable)properties).put(DIV_BY_ZERO_VALUE, Double.toString(FloatBlitter.divideByZeroValue));
            Prefs.saveOptions(properties);
            IJ.getInstance().savePreferences(properties);
            Menus.savePreferences(properties);
            ParticleAnalyzer.savePreferences(properties);
            Analyzer.savePreferences(properties);
            ImportDialog.savePreferences(properties);
            PlotWindow.savePreferences(properties);
            GelAnalyzer.savePreferences(properties);
            String string2 = prefsDir + separator + PREFS_NAME;
            Prefs.savePrefs(properties, string2);
        }
        catch (Exception exception) {
            IJ.write("<<Unable to save preferences>>");
            IJ.wait(2000);
        }
    }

    static void loadOptions() {
        int n = Prefs.getInt(OPTIONS, 2);
        usePointerCursor = (n & 1) != 0;
        antialiasedText = (n & 2) != 0;
        interpolateScaledImages = (n & 4) != 0;
        open100Percent = (n & 8) != 0;
    }

    static void saveOptions(Properties properties) {
        int n = (usePointerCursor ? 1 : 0) + (antialiasedText ? 2 : 0) + (interpolateScaledImages ? 4 : 0) + (open100Percent ? 8 : 0);
        ((Hashtable)properties).put(OPTIONS, Integer.toString(n));
    }

    static void savePrefs(Properties properties, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
        printWriter.println("# ImageJ 1.30s Preferences");
        printWriter.println("# " + new Date());
        printWriter.println("");
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            printWriter.print(string2);
            printWriter.write(61);
            printWriter.println((String)((Hashtable)properties).get(string2));
        }
        printWriter.close();
    }

    static String escapeBackSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            stringBuffer.append(cArray[n]);
            if (cArray[n] == '\\') {
                stringBuffer.append('\\');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        prefs = new Properties();
        props = new Properties(prefs);
    }
}

