/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Label;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

class My3DData {
    public String markerInfilename = null;
    public String markerOutfilename = null;
    public Vector MyElements;
    public Vector[] MyProjections;
    public ASlice[] MyColorProjection;
    public ASlice[] MySlice;
    public ASlice[] MyColorSlice;
    public MarkerLists MyMarkers;
    boolean ConnectionShown = true;
    boolean ShowFullTrace = true;
    boolean ShowAllLists = true;
    boolean ShowAllSlices = false;
    boolean ShowAllTimes = false;
    boolean ShowSpectralTrack = false;
    boolean MarkerToMax = true;
    boolean UseCOI = true;
    int SearchX = 3;
    int SearchY = 3;
    int SearchZ = 0;
    int COMX = 3;
    int COMY = 3;
    int COMZ = 0;
    String[] TrackDirections = new String[]{"X", "Y", "Z", "Elements", "Time"};
    int TrackDirection = 2;
    String[] TrackModes = new String[]{"Max", "Min"};
    int TrackMode = 0;
    boolean Repulsion = false;
    boolean FocusDispToMarker = true;
    boolean ActioReactio = false;
    double FWHM = 4.0;
    public int SizeX = 0;
    public int SizeY = 0;
    public int SizeZ = 0;
    public int Elements = 0;
    public int ActiveElement = 0;
    public Vector MyTimes;
    public Vector MyTimeProj;
    public int Times = 0;
    public int ActiveTime = 0;
    public Vector MyTimeColorProj;
    public Vector TimeValues;
    My3DData MyHistogram = null;
    My3DData DataToHistogram = null;
    int[] sizes = new int[]{0, 0, 0, 0, 0};
    int PrevType;
    int PrevBytes;
    int PrevBits;
    int HistoX = 0;
    int HistoY = -1;
    int HistoZ = -1;
    int[] ProjMin;
    int[] ProjMax;
    Vector[] PlanesS;
    Vector[] PlanesD;
    Polygon[] ROIPolygons;
    boolean[] ProjMode;
    boolean projinit = false;
    boolean cprojinit = false;
    int elemR = 0;
    int elemG = 0;
    int elemB = 0;
    int GateElem = 0;
    boolean GateActive = false;
    boolean colormode = false;
    public Container applet;
    Vector MyBundle;

    void AddPoint(APoint aPoint) {
        this.MyMarkers.AddPoint(aPoint);
    }

    void AddPoint(double d, double d2, double d3, double d4, double d5) {
        this.AddPoint(new APoint(d, d2, d3, d4, d5));
    }

    void RemovePoint() {
        this.MyMarkers.RemovePoint();
    }

    void RemoveTrailingPoints() {
        this.MyMarkers.RemoveTrailingPoints();
    }

    void AdvancePoint(int n) {
        this.MyMarkers.AdvancePoint(n);
    }

    APoint GetPoint(int n, int n2) {
        return this.MyMarkers.GetPoint(n, n2);
    }

    APoint GetPoint(int n) {
        return this.MyMarkers.GetPoint(n, -1);
    }

    int NumMarkers(int n) {
        return this.MyMarkers.NumMarkers(n);
    }

    int ActiveMarkerPos() {
        return this.MyMarkers.ActiveMarkerPos();
    }

    void SetActiveMarker(int n) {
        this.MyMarkers.SetActiveMarker(n);
    }

    APoint GetActiveMarker() {
        return this.GetPoint(-1);
    }

    void CheckActiveMarker(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n == this.ActiveMarkerListPos()) {
            switch (this.TrackDirection) {
                case 0: {
                    if (this.GetPoint((int)n2, (int)n).coord[0] != (double)n3 || this.SizeX <= 1) break;
                    this.SetActiveMarker(n2);
                    break;
                }
                case 1: {
                    if (this.GetPoint((int)n2, (int)n).coord[1] != (double)n4 || this.SizeY <= 1) break;
                    this.SetActiveMarker(n2);
                    break;
                }
                case 2: {
                    if (this.GetPoint((int)n2, (int)n).coord[2] != (double)n5 || this.SizeZ <= 1) break;
                    this.SetActiveMarker(n2);
                    break;
                }
                case 3: {
                    if (this.GetPoint((int)n2, (int)n).coord[3] != (double)n6 || this.Elements <= 1) break;
                    this.SetActiveMarker(n2);
                    break;
                }
                case 4: {
                    if (this.GetPoint((int)n2, (int)n).coord[4] != (double)n7 || this.Times <= 1) break;
                    this.SetActiveMarker(n2);
                }
            }
        }
    }

    int NumMarkerLists() {
        return this.MyMarkers.NumMarkerLists();
    }

    int ActiveMarkerListPos() {
        return this.MyMarkers.ActiveMarkerListPos();
    }

    String GetMarkerPrintout(My3DData my3DData) {
        return this.MyMarkers.PrintList(my3DData) + this.MyMarkers.PrintSummary(my3DData);
    }

    void NewMarkerList() {
        this.MyMarkers.NewList();
    }

    void RemoveMarkerList() {
        this.MyMarkers.RemoveList();
    }

    void AdvanceMarkerList(int n) {
        this.MyMarkers.AdvanceList(n);
    }

    void ToggleMarkerListColor(int n) {
        this.MyMarkers.ToggleColor();
    }

    APoint MarkerFromPosition(double d, double d2, int n, double d3, double d4) {
        return this.MyMarkers.MarkerFromPosition(d, d2, n, d3, d4, this.ShowAllLists, this.ShowAllSlices, this.ShowAllTimes);
    }

    public int AddLookUpTable(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n2 = 0;
        n2 = 13 + Bundle.AddLookUpTable(n, byArray, byArray2, byArray3);
        this.SetColorModelNr(this.ActiveElement, n2);
        this.GetBundleAt(this.ActiveElement).CompCMap();
        return n2;
    }

    void cleanup() {
        for (int i = 0; i < this.Times; ++i) {
            for (int j = 0; j < this.Elements; ++j) {
                this.ElementAt((int)j, (int)i).DataToHistogramX = null;
                this.ElementAt((int)j, (int)i).DataToHistogramY = null;
                this.ElementAt((int)j, (int)i).DataToHistogramZ = null;
                this.ElementAt(j, i).DeleteData();
            }
        }
        this.MyElements = null;
        this.MyTimes = null;
        this.MyProjections = null;
    }

    void SetMarker(double d, double d2, double d3, double d4, double d5) {
        APoint aPoint = new APoint(d, d2, d3, d4, d5);
        if (this.MarkerToMax) {
            aPoint = this.IterativeClosestMax(aPoint, this.SearchX, this.SearchY, this.SearchZ);
        }
        this.ClippedCOI(aPoint, this.COMX, this.COMY, this.COMZ, this.UseCOI);
        this.AddPoint(aPoint);
    }

    void SetMarker(double d, double d2, double d3) {
        this.SetMarker(d, d2, d3, this.ActiveElement, this.ActiveTime);
    }

    void TagMarker() {
        this.GetActiveMarker().Tag(-1);
    }

    void AutoTrack() {
        APoint aPoint = this.GetPoint(-1);
        int n = this.ActiveMarkerPos();
        int n2 = this.NumMarkers(-1);
        APoint aPoint2 = aPoint;
        double d = aPoint.coord[this.TrackDirection];
        ++n;
        while (n < n2) {
            this.SetActiveMarker(n);
            aPoint = this.GetPoint(n);
            d = aPoint.coord[this.TrackDirection];
            aPoint.copy(aPoint2);
            aPoint.coord[this.TrackDirection] = d;
            this.UpdateMarker(aPoint);
            aPoint2 = aPoint;
            ++n;
        }
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = 0;
        double d2 = aPoint.coord[0];
        double d3 = aPoint.coord[1];
        double d4 = aPoint.coord[2];
        double d5 = aPoint.coord[3];
        double d6 = aPoint.coord[4];
        switch (this.TrackDirection) {
            case 0: {
                n3 = this.SizeX;
                bl = true;
                n4 = (int)d2 + 1;
                break;
            }
            case 1: {
                n3 = this.SizeY;
                bl2 = true;
                n4 = (int)d3 + 1;
                break;
            }
            case 2: {
                n3 = this.SizeZ;
                bl3 = true;
                n4 = (int)d4 + 1;
                break;
            }
            case 3: {
                n3 = this.Elements;
                bl4 = true;
                n4 = (int)d5 + 1;
                break;
            }
            case 4: {
                n3 = this.Times;
                bl5 = true;
                n4 = (int)d6 + 1;
            }
        }
        d2 += (double)bl;
        d3 += (double)bl2;
        d4 += (double)bl3;
        d5 += (double)bl4;
        d6 += (double)bl5;
        while (n4 < n3) {
            this.SetMarker(d2, d3, d4, d5, d6);
            aPoint = this.GetPoint(n);
            d2 = aPoint.coord[0];
            d3 = aPoint.coord[1];
            d4 = aPoint.coord[2];
            d5 = aPoint.coord[3];
            d2 += (double)bl;
            d3 += (double)bl2;
            d4 += (double)bl3;
            d5 += (double)bl4;
            d6 += (double)bl5;
            ++n;
            ++n4;
        }
    }

    void SubtractTrackedSpot() {
        int n = this.NumMarkers(-1);
        for (int i = this.ActiveMarkerPos(); i < n; ++i) {
            this.SetActiveMarker(i);
            APoint aPoint = this.GetPoint(i);
            this.ElementAt((int)aPoint.coord[3], (int)aPoint.coord[4]).SubtractGauss(aPoint.coord[0], aPoint.coord[1], aPoint.coord[2], aPoint.integral, this.COMX, this.COMY, this.COMZ, this.FWHM);
        }
    }

    void UpdateMarker(APoint aPoint) {
        if (this.MarkerToMax) {
            APoint aPoint2 = (APoint)aPoint.clone();
            APoint aPoint3 = this.IterativeClosestMax(aPoint2, this.SearchX, this.SearchY, this.SearchZ);
            aPoint.copy(aPoint3);
        }
        this.ClippedCOI(aPoint, this.COMX, this.COMY, this.COMZ, this.UseCOI);
    }

    void ToggleMarkerToMax(int n) {
        this.MarkerToMax = n < 0 ? !this.MarkerToMax : n != 0;
    }

    void Penalize(APoint aPoint) {
        if (this.Repulsion) {
            this.MyMarkers.Penalize(aPoint, this.FWHM, this.TrackDirection);
        }
    }

    double Penalty(APoint aPoint) {
        if (this.Repulsion) {
            return this.MyMarkers.Penalty(aPoint, this.FWHM, this.TrackDirection, AnElement.ComputeIntMaxScale(this.COMX, this.COMY, this.COMZ, this.FWHM));
        }
        return 0.0;
    }

    double Restrict(double d, int n) {
        if (d >= (double)n) {
            return n - 1;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    APoint LimitPoint(APoint aPoint) {
        APoint aPoint2 = (APoint)aPoint.clone();
        for (int i = 0; i < 5; ++i) {
            aPoint2.coord[i] = this.Restrict(aPoint.coord[i], this.sizes[i]);
        }
        return aPoint2;
    }

    APoint ClosestMax(APoint aPoint, int n, int n2, int n3) {
        int n4 = (int)(aPoint.coord[0] + 0.5);
        int n5 = (int)(aPoint.coord[1] + 0.5);
        int n6 = (int)(aPoint.coord[2] + 0.5);
        int n7 = (int)(aPoint.coord[3] + 0.5);
        int n8 = (int)(aPoint.coord[4] + 0.5);
        boolean bl = false;
        if (this.TrackMode == 1) {
            bl = true;
            this.ElementAt((int)n7, (int)n8).ScaleV = -this.ElementAt((int)n7, (int)n8).ScaleV;
        }
        double d = this.ElementAt(n7, n8).GetValueWithBounds(n4, n5, n6);
        double d2 = n4;
        double d3 = n5;
        double d4 = n6;
        APoint aPoint2 = (APoint)aPoint.clone();
        d -= this.Penalty(aPoint2);
        for (int i = n6 - n3; i <= n6 + n3; ++i) {
            aPoint2.coord[2] = i;
            for (int j = n5 - n2; j <= n5 + n2; ++j) {
                aPoint2.coord[1] = j;
                for (int k = n4 - n; k <= n4 + n; ++k) {
                    aPoint2.coord[0] = k;
                    double d5 = this.ElementAt(n7, n8).GetValueWithBounds(k, j, i);
                    if (!(d5 > d) || !((d5 -= this.Penalty(aPoint2)) > d)) continue;
                    d = d5;
                    d2 = k;
                    d3 = j;
                    d4 = i;
                }
            }
        }
        aPoint2.coord[0] = d2;
        aPoint2.coord[1] = d3;
        aPoint2.coord[2] = d4;
        aPoint2.max = d;
        if (bl) {
            this.ElementAt((int)n7, (int)n8).ScaleV = -this.ElementAt((int)n7, (int)n8).ScaleV;
        }
        return aPoint2;
    }

    APoint IterativeClosestMax(APoint aPoint, int n, int n2, int n3) {
        APoint aPoint2 = (APoint)aPoint.clone();
        APoint aPoint3 = this.ClosestMax(aPoint, n, n2, n3);
        int n4 = 0;
        int n5 = 10;
        while (aPoint2.SqrDistTo(aPoint3) > 0.1) {
            aPoint2 = aPoint3;
            aPoint3 = this.ClosestMax(aPoint2, n, n2, n3);
            ++n4;
        }
        aPoint3.mycolor = aPoint.mycolor;
        return aPoint3;
    }

    void ConstrainPoint(APoint aPoint) {
        if (aPoint.coord[0] > (double)(this.SizeX - 1)) {
            aPoint.coord[0] = (double)this.SizeX - 1.0;
        }
        if (aPoint.coord[0] < 0.0) {
            aPoint.coord[0] = 0.0;
        }
        if (aPoint.coord[1] > (double)(this.SizeY - 1)) {
            aPoint.coord[1] = (double)this.SizeY - 1.0;
        }
        if (aPoint.coord[1] < 0.0) {
            aPoint.coord[1] = 0.0;
        }
        if (aPoint.coord[2] > (double)(this.SizeZ - 1)) {
            aPoint.coord[2] = (double)this.SizeZ - 1.0;
        }
        if (aPoint.coord[2] < 0.0) {
            aPoint.coord[2] = 0.0;
        }
        if (aPoint.coord[3] > (double)(this.Elements - 1)) {
            aPoint.coord[3] = (double)this.Elements - 1.0;
        }
        if (aPoint.coord[3] < 0.0) {
            aPoint.coord[3] = 0.0;
        }
        if (aPoint.coord[4] > (double)(this.Times - 1)) {
            aPoint.coord[4] = (double)this.Times - 1.0;
        }
        if (aPoint.coord[4] < 0.0) {
            aPoint.coord[4] = 0.0;
        }
    }

    void ClippedCOI(APoint aPoint, int n, int n2, int n3, boolean bl) {
        int n4 = (int)(aPoint.coord[0] + 0.5);
        int n5 = (int)(aPoint.coord[1] + 0.5);
        int n6 = (int)(aPoint.coord[2] + 0.5);
        int n7 = (int)(aPoint.coord[3] + 0.5);
        int n8 = (int)(aPoint.coord[4] + 0.5);
        boolean bl2 = false;
        if (this.TrackMode == 1) {
            bl2 = true;
            this.ElementAt((int)n7, (int)n8).ScaleV = -this.ElementAt((int)n7, (int)n8).ScaleV;
        }
        double d = this.ElementAt(n7, n8).GetValueWithBounds(n4, n5, n6);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d;
        double d7 = 0.0;
        AnElement anElement = this.GetGateElem(n8);
        for (int i = n6 - n3; i <= n6 + n3; ++i) {
            for (int j = n5 - n2; j <= n5 + n2; ++j) {
                for (int k = n4 - n; k <= n4 + n; ++k) {
                    if (anElement.GetIntValueWithBounds(k, j, i) <= 0 || !this.ElementAt(n7, n8).InsideBounds(k, j, i)) continue;
                    double d8 = this.ElementAt(n7, n8).GetValueAt(k, j, i);
                    d3 += d8 * (double)k;
                    d4 += d8 * (double)j;
                    d5 += d8 * (double)i;
                    d2 += d8;
                    if (d8 < d6) {
                        d6 = d8;
                    }
                    if (d8 > d) {
                        d = d8;
                    }
                    d7 += 1.0;
                }
            }
        }
        if (d6 >= d) {
            d6 = 0.0;
        }
        aPoint.integral = d2;
        aPoint.max = d;
        aPoint.min = d6;
        aPoint.integralAboveMin = d2 -= d7 * d6;
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        if (d7 == 0.0) {
            return;
        }
        double d9 = (d3 - d6 * d7 * (double)n4) / d2;
        double d10 = (d4 - d6 * d7 * (double)n5) / d2;
        double d11 = (d5 - d6 * d7 * (double)n6) / d2;
        if (d9 < 0.0) {
            d9 = 0.0;
        }
        if (d10 < 0.0) {
            d10 = 0.0;
        }
        if (d11 < 0.0) {
            d11 = 0.0;
        }
        if (bl && d > d6) {
            aPoint.coord[0] = d9;
            aPoint.coord[1] = d10;
            aPoint.coord[2] = d11;
            aPoint.coord[3] = n7;
            aPoint.coord[4] = n8;
        }
        if (bl2) {
            this.ElementAt((int)n7, (int)n8).ScaleV = -this.ElementAt((int)n7, (int)n8).ScaleV;
        }
    }

    boolean MarkerDisplayed(APoint aPoint, int n, int n2) {
        if (this.ShowAllTimes || aPoint.coord[4] == (double)n2) {
            return this.ShowAllSlices || aPoint.coord[2] == (double)n;
        }
        return false;
    }

    void MarkerDialog() {
        ANGenericDialog aNGenericDialog = new ANGenericDialog("Marker positioning");
        int n = this.ActiveElement;
        aNGenericDialog.addCheckbox("Display connecting lines", this.ConnectionShown);
        aNGenericDialog.addCheckbox("Show all lines", this.ShowFullTrace);
        aNGenericDialog.addCheckbox("Show all lists", this.ShowAllLists);
        aNGenericDialog.addCheckbox("Show all slices", this.ShowAllSlices);
        aNGenericDialog.addCheckbox("Show all times", this.ShowAllTimes);
        aNGenericDialog.addChoice("Tracking Mode: ", this.TrackModes, this.TrackModes[this.TrackMode]);
        aNGenericDialog.addChoice("Tracking direction: ", this.TrackDirections, this.TrackDirections[this.TrackDirection]);
        aNGenericDialog.addCheckbox("Spectral Display for Track", this.ShowSpectralTrack);
        aNGenericDialog.addMessage("For automatic marker positioning an iterative search for the nearest\nmaximum signal is performed. The region to be searched is defined by the\nnumber of voxels to include in each direction, beyond the current plane.\nTo restrict the update to any plane or line choose zero in the\nappropriate fields below.");
        aNGenericDialog.addCheckbox("Use automatic maximum finding", this.MarkerToMax);
        aNGenericDialog.addNumericFields("X Neighbours: ", this.SearchX, 3, 3);
        aNGenericDialog.addNumericFields("Y:", this.SearchY, 3, 3);
        aNGenericDialog.addNumericFields("Z:", this.SearchZ, 3, 3);
        aNGenericDialog.addCheckbox("Subpixel positions by Center of Mass", this.UseCOI);
        aNGenericDialog.addNumericFields("X Center of Intensity: ", this.COMX, 3, 3);
        aNGenericDialog.addNumericFields("Y:", this.COMY, 3, 3);
        aNGenericDialog.addNumericFields("Z:", this.COMZ, 3, 3);
        aNGenericDialog.addNumericField("FWHM of Gaussian for subtaction: ", this.FWHM, 3);
        aNGenericDialog.addCheckbox("Repulsion", this.Repulsion);
        aNGenericDialog.addCheckbox("Focus Display to Marker", this.FocusDispToMarker);
        aNGenericDialog.addInFile("MarkerFileIn: ", this.markerInfilename);
        aNGenericDialog.addOutFile("MarkerFileOut: ", this.markerOutfilename);
        aNGenericDialog.showDialog();
        if (!aNGenericDialog.wasCanceled()) {
            this.ConnectionShown = aNGenericDialog.getNextBoolean();
            this.ShowFullTrace = aNGenericDialog.getNextBoolean();
            this.ShowAllLists = aNGenericDialog.getNextBoolean();
            this.ShowAllSlices = aNGenericDialog.getNextBoolean();
            this.ShowAllTimes = aNGenericDialog.getNextBoolean();
            this.TrackMode = aNGenericDialog.getNextChoiceIndex();
            this.TrackDirection = aNGenericDialog.getNextChoiceIndex();
            this.ShowSpectralTrack = aNGenericDialog.getNextBoolean();
            this.MarkerToMax = aNGenericDialog.getNextBoolean();
            this.SearchX = (int)aNGenericDialog.getNextNumber();
            this.SearchY = (int)aNGenericDialog.getNextNumber();
            this.SearchZ = (int)aNGenericDialog.getNextNumber();
            this.UseCOI = aNGenericDialog.getNextBoolean();
            this.COMX = (int)aNGenericDialog.getNextNumber();
            this.COMY = (int)aNGenericDialog.getNextNumber();
            this.COMZ = (int)aNGenericDialog.getNextNumber();
            this.FWHM = aNGenericDialog.getNextNumber();
            this.Repulsion = aNGenericDialog.getNextBoolean();
            this.FocusDispToMarker = aNGenericDialog.getNextBoolean();
            this.markerInfilename = aNGenericDialog.getInFile();
            this.markerOutfilename = aNGenericDialog.getOutFile();
        }
        switch (this.TrackDirection) {
            case 0: {
                this.SearchX = 0;
                break;
            }
            case 1: {
                this.SearchY = 0;
                break;
            }
            case 2: {
                this.SearchZ = 0;
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public void toggleGate(int n) {
        if (n < 0) {
            this.GateActive = !this.GateActive;
        } else {
            boolean bl = this.GateActive = n == 1;
        }
        if (this.GateActive) {
            this.CThreshToValThresh(this.GateElem, 0.0, 1.0);
        }
        this.InvalidateSlices();
        this.InvalidateProjs(-1);
    }

    public void setGate() {
        this.GateElem = this.ActiveElement;
        if (this.GateActive) {
            this.InvalidateSlices();
            this.InvalidateProjs(-1);
            this.CThreshToValThresh(-1, 0.0, 1.0);
        }
    }

    public void setModelThresh() {
        this.setModelThresh(this.ActiveElement);
    }

    public void setModelThresh(int n) {
        this.GetBundleAt(n).CompCMap();
    }

    public int GetActiveColorModelNr() {
        return this.GetBundleAt((int)this.ActiveElement).ElementModelNr;
    }

    public int GetColorModelNr(int n) {
        return this.GetBundleAt((int)n).ElementModelNr;
    }

    public void SetColorModelNr(int n, int n2) {
        this.GetBundleAt((int)n).ElementModelNr = n2;
    }

    public Bundle GetBundleAt(int n) {
        return (Bundle)this.MyBundle.elementAt(n);
    }

    public void ToggleLog(int n) {
        this.ToggleLog(this.ActiveElement, n);
    }

    public void ToggleConnection(int n) {
        this.ConnectionShown = n < 0 ? !this.ConnectionShown : n != 0;
    }

    public void ToggleLog(int n, int n2) {
        this.GetBundleAt(n).ToggleLog(n2);
    }

    public void ToggleOvUn(int n) {
        boolean bl = this.GetBundleAt(this.ActiveElement).ToggleOvUn(n);
        n = bl ? 1 : 0;
        if (this.colormode) {
            for (int i = 0; i < this.Elements; ++i) {
                this.GetBundleAt(i).ToggleOvUn(n);
            }
        }
    }

    public void ToggleModel(int n, int n2) {
        this.GetBundleAt(n).ToggleModel(n2);
        if (n == this.ActiveElement) {
            IndexColorModel indexColorModel = this.GetBundleAt((int)n).ElementModel;
            this.MySlice[0].TakeModel(indexColorModel);
            this.MySlice[1].TakeModel(indexColorModel);
            this.MySlice[2].TakeModel(indexColorModel);
        }
    }

    public void ToggleModel(int n) {
        this.ToggleModel(this.ActiveElement, n);
    }

    public void InvertCMap() {
        this.GetBundleAt((int)this.ActiveElement).cmapIsInverse = !this.GetBundleAt((int)this.ActiveElement).cmapIsInverse;
    }

    private double Getmincs(int n) {
        return this.BundleAt(n).GetMincs();
    }

    private double Getmaxcs(int n) {
        return this.BundleAt(n).GetMaxcs();
    }

    public double GetScaledMincs(int n) {
        return this.GetMinThresh(n) * this.ElementAt((int)n).ScaleV + this.ElementAt((int)n).OffsetV;
    }

    public double GetScaledMaxcs(int n) {
        return this.GetMaxThresh(n) * this.ElementAt((int)n).ScaleV + this.ElementAt((int)n).OffsetV;
    }

    public double GetScaledRange(int n) {
        if (n < 0) {
            return 0.0;
        }
        return this.ElementAt((int)n).ScaleV * (this.GetMaxThresh(n) - this.GetMinThresh(n));
    }

    public void transferThresh(int n) {
        for (int i = 0; i < this.Times; ++i) {
            this.ElementAt(n, i).SetScaleShift(this.Getmincs(n), this.Getmaxcs(n));
        }
    }

    public boolean SetThresh(double d, double d2) {
        return this.SetThresh(this.ActiveElement, d, d2);
    }

    public boolean SetThresh(int n, double d, double d2) {
        if (this.BundleAt(n).GetMincs() != d || this.BundleAt(n).GetMaxcs() != d2) {
            this.BundleAt(n).SetMincs(d);
            this.BundleAt(n).SetMaxcs(d2);
            return false;
        }
        return true;
    }

    public boolean SetScaledMinMaxcs(int n, double d, double d2) {
        return this.SetThresh(n, (d - this.ElementAt((int)n).OffsetV) / this.ElementAt((int)n).ScaleV, (d2 - this.ElementAt((int)n).OffsetV) / this.ElementAt((int)n).ScaleV);
    }

    public void AdjustThresh(boolean bl) {
        if (!bl) {
            this.BundleAt((int)this.ActiveElement).cmapcHigh = Short.MAX_VALUE;
            this.BundleAt((int)this.ActiveElement).cmapcLow = 0;
            this.BundleAt(this.ActiveElement).CompCMap();
            double d = this.ActElement().ROIMinimum(this.ActROI());
            double d2 = this.ActElement().ROIMaximum(this.ActROI());
            if (!this.SetThresh(this.ActiveElement, d, d2)) {
                this.InvalidateSlices();
            }
            this.transferThresh(this.ActiveElement);
        } else {
            boolean bl2 = true;
            for (int i = 0; i < this.Elements; ++i) {
                this.BundleAt((int)i).cmapcHigh = Short.MAX_VALUE;
                this.BundleAt((int)i).cmapcLow = 0;
                this.BundleAt(i).CompCMap();
                double d = this.ElementAt(i).ROIMinimum(this.ActROI());
                double d3 = this.ElementAt(i).ROIMaximum(this.ActROI());
                if (!this.SetThresh(i, d, d3)) {
                    bl2 = false;
                }
                this.transferThresh(i);
            }
            if (!bl2) {
                this.InvalidateSlices();
            }
        }
    }

    public void adjustColorMapLThresh(double d) {
        double d2 = d * 32768.0;
        double d3 = this.BundleAt((int)this.ActiveElement).cmapcHigh;
        double d4 = this.BundleAt((int)this.ActiveElement).cmapcLow;
        if (d2 < 0.0 || d3 > d4 + d2) {
            this.BundleAt((int)this.ActiveElement).cmapcLow += (int)d2;
        }
        if (this.BundleAt((int)this.ActiveElement).cmapcLow > 0) {
            this.BundleAt(this.ActiveElement).CompCMap();
        } else {
            this.CThreshToValThresh(this.ActiveElement, 0.25, 1.0);
        }
    }

    public void adjustColorMapUThresh(double d) {
        double d2 = d * 32768.0;
        double d3 = this.BundleAt((int)this.ActiveElement).cmapcHigh;
        double d4 = this.BundleAt((int)this.ActiveElement).cmapcLow;
        if (d2 > 0.0 || d3 + d2 > d4) {
            this.BundleAt((int)this.ActiveElement).cmapcHigh += (int)d2;
        }
        if (this.BundleAt((int)this.ActiveElement).cmapcHigh <= Short.MAX_VALUE) {
            this.BundleAt(this.ActiveElement).CompCMap();
        } else {
            this.CThreshToValThresh(this.ActiveElement, 0.0, 0.75);
        }
    }

    public double GetMinThresh(int n) {
        double d = this.BundleAt(n).GetMaxcs();
        double d2 = this.BundleAt(n).GetMincs();
        double d3 = this.BundleAt((int)n).cmapcHigh;
        double d4 = this.BundleAt((int)n).cmapcLow;
        double d5 = (d - d2) / 32768.0;
        double d6 = d2 + d5 * d4;
        return d6;
    }

    public double GetMaxThresh(int n) {
        double d = this.BundleAt(n).GetMaxcs();
        double d2 = this.BundleAt(n).GetMincs();
        double d3 = this.BundleAt((int)n).cmapcHigh;
        double d4 = this.BundleAt((int)n).cmapcLow;
        double d5 = d2 + (d - d2) * d3 / 32768.0;
        return d5;
    }

    public void CThreshToValThresh(int n, double d, double d2) {
        if (n < 0) {
            n = this.ActiveElement;
        }
        double d3 = this.BundleAt(n).GetMaxcs();
        double d4 = this.BundleAt(n).GetMincs();
        double d5 = this.BundleAt((int)n).cmapcHigh;
        double d6 = this.BundleAt((int)n).cmapcLow;
        double d7 = (int)(32767.0 * d2);
        double d8 = (int)(32767.0 * d);
        double d9 = (d3 - d4) / 32768.0;
        double d10 = (d5 - d6) / (d7 - d8);
        double d11 = d3 - d9 * (32768.0 - (d5 + d10 * (32767.0 - d7)));
        double d12 = d4 + d9 * (d6 - d10 * d8);
        this.BundleAt(n).SetMincs(d12);
        this.BundleAt(n).SetMaxcs(d11);
        this.BundleAt((int)n).cmapcLow = (int)d8;
        this.BundleAt((int)n).cmapcHigh = (int)d7;
        this.InvalidateSlices();
        this.InvalidateProjs(n);
        this.transferThresh(n);
        this.BundleAt(n).CompCMap();
    }

    public void addLThresh(double d) {
        double d2 = d * this.ActElement().MaxValue;
        double d3 = this.BundleAt(this.ActiveElement).GetMaxcs();
        double d4 = this.BundleAt(this.ActiveElement).GetMincs();
        if (d2 < 0.0 || d3 > d4 + d2) {
            this.BundleAt(this.ActiveElement).SetMincs(d4 + d2);
            this.InvalidateSlices();
            this.InvalidateProjs(this.ActiveElement);
        }
        this.transferThresh(this.ActiveElement);
    }

    public void addUThresh(double d) {
        double d2 = d * this.ActElement().MaxValue;
        double d3 = this.BundleAt(this.ActiveElement).GetMaxcs();
        double d4 = this.BundleAt(this.ActiveElement).GetMincs();
        if (d2 > 0.0 || d3 + d2 > d4) {
            this.BundleAt(this.ActiveElement).SetMaxcs(d3 + d2);
            this.InvalidateSlices();
            this.InvalidateProjs(this.ActiveElement);
        }
        this.transferThresh(this.ActiveElement);
    }

    public void initThresh() {
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt((int)i).cmapcLow = 0;
            this.BundleAt((int)i).cmapcHigh = Short.MAX_VALUE;
            this.BundleAt(i).CompCMap();
            AnElement anElement = this.ElementAt(i);
            if (anElement instanceof FloatElement || anElement instanceof DoubleElement) {
                this.BundleAt(i).SetMincs(anElement.Min);
                this.BundleAt(i).SetMaxcs(anElement.Max);
            } else {
                this.BundleAt(i).SetMincs(anElement.OffsetV);
                this.BundleAt(i).SetMaxcs(anElement.MaxValue);
            }
            this.ToggleLog(i, 0);
            this.transferThresh(i);
        }
        this.InvalidateSlices();
    }

    public void initGlobalThresh() {
        int n;
        AnElement anElement = this.ElementAt(0);
        double d = anElement.Min;
        double d2 = anElement.Max;
        for (n = 1; n < this.Elements; ++n) {
            anElement = this.ElementAt(n);
            if (anElement.Min < d) {
                d = anElement.Min;
            }
            if (!(anElement.Max > d2)) continue;
            d2 = anElement.Max;
        }
        for (n = 0; n < this.Elements; ++n) {
            this.BundleAt(n).SetMincs(d);
            this.BundleAt(n).SetMaxcs(d2);
            this.ToggleLog(n, 0);
            this.transferThresh(n);
        }
        this.InvalidateSlices();
    }

    public Vector ElementsAtTime(int n) {
        return (Vector)this.MyTimes.elementAt(n);
    }

    public Vector[] ProjsAtTime(int n) {
        return (Vector[])this.MyTimeProj.elementAt(n);
    }

    public ASlice[] ColorProjsAtTime(int n) {
        return (ASlice[])this.MyTimeColorProj.elementAt(n);
    }

    public void GetElementsFromTime() {
        this.MyElements = this.ElementsAtTime(this.ActiveTime);
        this.InvalidateSlices();
    }

    public void GetProjsFromTime() {
        this.MyProjections = this.ProjsAtTime(this.ActiveTime);
        this.MyColorProjection = this.ColorProjsAtTime(this.ActiveTime);
    }

    public void setTime(int n) {
        if (n >= this.Times) {
            n %= this.Times;
        }
        if (n < 0) {
            n = (n + this.Times) % this.Times;
        }
        this.ActiveTime = n;
        this.GetElementsFromTime();
        this.GetProjsFromTime();
    }

    public void nextTime(int n) {
        int n2 = this.ActiveTime + n;
        this.setTime(n2);
    }

    public void advanceTime(int n) {
        this.ActiveTime += n;
        if (this.ActiveTime < 0) {
            this.ActiveTime += this.Times;
        }
        if (this.ActiveTime < 0) {
            this.ActiveTime = 0;
        }
        this.ActiveTime %= this.Times;
        this.GetElementsFromTime();
        this.GetProjsFromTime();
    }

    public void setElement(int n) {
        if (n >= this.Elements) {
            n = this.Elements - 1;
        }
        if (n < 0) {
            n = 0;
        }
        this.ActiveElement = n;
        this.InvalidateSlices();
    }

    public void advanceElement(int n) {
        this.ActiveElement += n;
        if (this.ActiveElement < 0) {
            this.ActiveElement += this.Elements;
        }
        if (this.ActiveElement < 0) {
            this.ActiveElement = 0;
        }
        this.ActiveElement %= this.Elements;
        this.InvalidateSlices();
    }

    public int GetNumElements() {
        return this.Elements;
    }

    public int GetSize(int n) {
        return this.sizes[n];
    }

    public double GetROISize(int n, int n2) {
        if (n < 0) {
            return this.ActElement().Scales[n2] * this.ActROI().GetROISize(n2);
        }
        return this.ElementAt((int)n).Scales[n2] * this.ActROI().GetROISize(n2);
    }

    public double GetROISum(int n) {
        for (int i = 0; i < 3; ++i) {
            if (!this.BundleAt((int)n).ProjValid[i] || !this.ProjAt((int)i, (int)n).isValid) continue;
            return this.ProjAt((int)i, (int)n).ROISum;
        }
        this.DoProject(n, 2);
        return this.ProjAt((int)2, (int)n).ROISum;
    }

    public double GetROIVoxels(int n) {
        for (int i = 0; i < 3; ++i) {
            if (!this.BundleAt((int)n).ProjValid[i] || !this.ProjAt((int)i, (int)n).isValid) continue;
            return this.ProjAt((int)i, (int)n).ROIVoxels;
        }
        this.DoProject(n, 2);
        return this.ProjAt((int)2, (int)n).ROIVoxels;
    }

    public double GetROIAvg(int n) {
        for (int i = 0; i < 3; ++i) {
            if (!this.BundleAt((int)n).ProjValid[i] || !this.ProjAt((int)i, (int)n).isValid) continue;
            return this.ProjAt((int)i, (int)n).ROIAvg;
        }
        this.DoProject(n, 2);
        return this.ProjAt((int)2, (int)n).ROIAvg;
    }

    public double GetROIMax(int n) {
        for (int i = 0; i < 3; ++i) {
            if (!this.BundleAt((int)n).ProjValid[i] || !this.ProjAt((int)i, (int)n).isValid) continue;
            return this.ProjAt((int)i, (int)n).ROIMax;
        }
        this.DoProject(n, 2);
        return this.ProjAt((int)2, (int)n).ROIMax;
    }

    public double GetROIMin(int n) {
        for (int i = 0; i < 3; ++i) {
            if (!this.BundleAt((int)n).ProjValid[i] || !this.ProjAt((int)i, (int)n).isValid) continue;
            return this.ProjAt((int)i, (int)n).ROIMin;
        }
        this.DoProject(n, 2);
        return this.ProjAt((int)2, (int)n).ROIMin;
    }

    public double GetROIVal(int n) {
        if (this.GetMIPMode(0)) {
            return this.GetROIMax(n);
        }
        return this.GetROIAvg(n);
    }

    public double GetValueScale(int n) {
        return this.ElementAt((int)n).ScaleV;
    }

    public double GetScale(int n, int n2) {
        return this.ElementAt((int)n).Scales[n2];
    }

    public double[] GetScale(int n) {
        return this.ElementAt((int)n).Scales;
    }

    public double GetOffset(int n, int n2) {
        return this.ElementAt((int)n).Offsets[n2];
    }

    public double[] GetOffset(int n) {
        return this.ElementAt((int)n).Offsets;
    }

    public void SetValueScale(int n, double d, double d2, String string, String string2) {
        this.ElementAt(n).SetScales(d, d2, string, string2);
    }

    public void SetOffsets(int n, double d, double d2, double d3) {
        this.ElementAt((int)n).Offsets[0] = d;
        this.ElementAt((int)n).Offsets[1] = d2;
        this.ElementAt((int)n).Offsets[2] = d3;
    }

    public String GetValueName(int n) {
        return this.ElementAt((int)n).NameV;
    }

    public String GetValueUnit(int n) {
        return this.ElementAt((int)n).UnitV;
    }

    public String[] GetAxisUnits() {
        return this.ActElement().Units;
    }

    public String[] GetAxisNames() {
        return this.ActElement().Names;
    }

    void AxesUnitsDialog() {
        AGenericDialog aGenericDialog = new AGenericDialog("Axes Units and Scalings");
        int n = this.ActiveElement;
        aGenericDialog.addStringField("NameX: ", this.GetAxisNames()[0]);
        aGenericDialog.addStringField("UnitX: ", this.GetAxisUnits()[0]);
        aGenericDialog.addNumericField("ScaleX: ", this.GetScale(n, 0), 5);
        aGenericDialog.addNumericField("OffsetX: ", this.GetOffset(n, 0), 5);
        aGenericDialog.addStringField("NameY: ", this.GetAxisNames()[1]);
        aGenericDialog.addStringField("UnitY: ", this.GetAxisUnits()[1]);
        aGenericDialog.addNumericField("ScaleY: ", this.GetScale(n, 1), 5);
        aGenericDialog.addNumericField("OffsetY: ", this.GetOffset(n, 1), 5);
        aGenericDialog.addStringField("NameZ: ", this.GetAxisNames()[2]);
        aGenericDialog.addStringField("UnitZ: ", this.GetAxisUnits()[2]);
        aGenericDialog.addNumericField("ScaleZ: ", this.GetScale(n, 2), 5);
        aGenericDialog.addNumericField("OffsetZ: ", this.GetOffset(n, 2), 5);
        aGenericDialog.addStringField("NameE: ", this.GetAxisNames()[3]);
        aGenericDialog.addStringField("UnitE: ", this.GetAxisUnits()[3]);
        aGenericDialog.addNumericField("ScaleE: ", this.GetScale(n, 3), 5);
        aGenericDialog.addNumericField("OffsetE: ", this.GetOffset(n, 3), 5);
        aGenericDialog.addStringField("NameT: ", this.GetAxisNames()[4]);
        aGenericDialog.addStringField("UnitT: ", this.GetAxisUnits()[4]);
        aGenericDialog.addNumericField("ScaleT: ", this.GetScale(n, 4), 5);
        aGenericDialog.addNumericField("OffsetT: ", this.GetOffset(n, 4), 5);
        aGenericDialog.showDialog();
        if (!aGenericDialog.wasCanceled()) {
            String[] stringArray = new String[5];
            String[] stringArray2 = new String[5];
            stringArray2[0] = aGenericDialog.getNextString();
            stringArray[0] = aGenericDialog.getNextString();
            double d = aGenericDialog.getNextNumber();
            double d2 = aGenericDialog.getNextNumber();
            stringArray2[1] = aGenericDialog.getNextString();
            stringArray[1] = aGenericDialog.getNextString();
            double d3 = aGenericDialog.getNextNumber();
            double d4 = aGenericDialog.getNextNumber();
            stringArray2[2] = aGenericDialog.getNextString();
            stringArray[2] = aGenericDialog.getNextString();
            double d5 = aGenericDialog.getNextNumber();
            double d6 = aGenericDialog.getNextNumber();
            stringArray2[3] = aGenericDialog.getNextString();
            stringArray[3] = aGenericDialog.getNextString();
            double d7 = aGenericDialog.getNextNumber();
            double d8 = aGenericDialog.getNextNumber();
            stringArray2[4] = aGenericDialog.getNextString();
            stringArray[4] = aGenericDialog.getNextString();
            double d9 = aGenericDialog.getNextNumber();
            double d10 = aGenericDialog.getNextNumber();
            for (int i = 0; i < this.Elements; ++i) {
                this.ElementAt((int)i).Scales[0] = d;
                this.ElementAt((int)i).Scales[1] = d3;
                this.ElementAt((int)i).Scales[2] = d5;
                this.ElementAt((int)i).Scales[3] = d7;
                this.ElementAt((int)i).Scales[4] = d9;
                this.ElementAt((int)i).Offsets[0] = d2;
                this.ElementAt((int)i).Offsets[1] = d4;
                this.ElementAt((int)i).Offsets[2] = d6;
                this.ElementAt((int)i).Offsets[3] = d8;
                this.ElementAt((int)i).Offsets[4] = d10;
                this.ElementAt((int)i).Names = stringArray2;
                this.ElementAt((int)i).Units = stringArray;
            }
        }
    }

    void ValueUnitsDialog() {
        AGenericDialog aGenericDialog = new AGenericDialog("Value Unit and Scaling");
        int n = this.ActiveElement;
        aGenericDialog.addStringField("ValueName: ", this.GetValueName(n));
        aGenericDialog.addStringField("ValueUnit: ", this.GetValueUnit(n));
        aGenericDialog.addNumericField("ValueScale: ", this.GetValueScale(n), 5);
        aGenericDialog.addNumericField("ValueOffset: ", this.GetValueOffset(n), 5);
        aGenericDialog.addNumericField("Threshold Min: ", this.GetScaledMincs(n), 5);
        aGenericDialog.addNumericField("Threshold Max: ", this.GetScaledMaxcs(n), 5);
        aGenericDialog.showDialog();
        if (!aGenericDialog.wasCanceled()) {
            String string = aGenericDialog.getNextString();
            String string2 = aGenericDialog.getNextString();
            double d = aGenericDialog.getNextNumber();
            double d2 = aGenericDialog.getNextNumber();
            double d3 = aGenericDialog.getNextNumber();
            double d4 = aGenericDialog.getNextNumber();
            this.ElementAt(n).SetScales(d, d2, string, string2);
            this.SetScaledMinMaxcs(n, d3, d4);
        }
    }

    public double GetValueOffset(int n) {
        return this.ElementAt((int)n).OffsetV;
    }

    public void SetValueOffset(int n, double d) {
        this.ElementAt((int)n).OffsetV = d;
    }

    public int GetActiveElement() {
        return this.ActiveElement;
    }

    public int GetActiveTime() {
        return this.ActiveTime;
    }

    public boolean GetColorMode() {
        return this.colormode;
    }

    public int GetChannel(int n) {
        if (n == 0) {
            return this.elemR;
        }
        if (n == 1) {
            return this.elemG;
        }
        if (n == 2) {
            return this.elemB;
        }
        return -1;
    }

    public void InvalidateColor(int n) {
        this.MyColorSlice[0].Invalidate();
        this.MyColorSlice[1].Invalidate();
        this.MyColorSlice[2].Invalidate();
    }

    public void InvalidateColor() {
        for (int i = 0; i < this.Times; ++i) {
            this.InvalidateColor(i);
        }
    }

    void InvalidateSlices() {
        this.MyColorSlice[0].Invalidate();
        this.MyColorSlice[1].Invalidate();
        this.MyColorSlice[2].Invalidate();
        this.MySlice[0].Invalidate();
        this.MySlice[1].Invalidate();
        this.MySlice[2].Invalidate();
    }

    public void InvalidateProjs(int n, int n2) {
        if (n < 0) {
            for (int i = 0; i < this.Elements; ++i) {
                ((ASlice)this.ProjsAtTime(n2)[0].elementAt(i)).Invalidate();
                ((ASlice)this.ProjsAtTime(n2)[1].elementAt(i)).Invalidate();
                ((ASlice)this.ProjsAtTime(n2)[2].elementAt(i)).Invalidate();
                this.BundleAt(i).Invalidate();
            }
            this.ColorProjsAtTime(n2)[0].Invalidate();
            this.ColorProjsAtTime(n2)[1].Invalidate();
            this.ColorProjsAtTime(n2)[2].Invalidate();
        } else {
            ((ASlice)this.ProjsAtTime(n2)[0].elementAt(n)).Invalidate();
            ((ASlice)this.ProjsAtTime(n2)[1].elementAt(n)).Invalidate();
            ((ASlice)this.ProjsAtTime(n2)[2].elementAt(n)).Invalidate();
            this.BundleAt(n).Invalidate();
            if (this.InOverlayDispl(n)) {
                this.ColorProjsAtTime(n2)[0].Invalidate();
                this.ColorProjsAtTime(n2)[1].Invalidate();
                this.ColorProjsAtTime(n2)[2].Invalidate();
            }
        }
    }

    public void InvalidateProjs(int n) {
        for (int i = 0; i < this.Times; ++i) {
            this.InvalidateProjs(n, i);
        }
    }

    public void ClearChannel(int n) {
        if (n == 0) {
            if (this.elemR >= 0) {
                this.GetBundleAt(this.elemR).ToggleOverlayDispl(0);
                this.GetBundleAt(this.elemR).ToggleMulDispl(0);
                this.GetBundleAt(this.elemR).ToggleModel(0);
            }
            this.elemR = -1;
        }
        if (n == 1) {
            if (this.elemG >= 0) {
                this.GetBundleAt(this.elemG).ToggleOverlayDispl(0);
                this.GetBundleAt(this.elemR).ToggleMulDispl(0);
                this.GetBundleAt(this.elemG).ToggleModel(0);
            }
            this.elemG = -1;
        }
        if (n == 2) {
            if (this.elemB >= 0) {
                this.GetBundleAt(this.elemB).ToggleOverlayDispl(0);
                this.GetBundleAt(this.elemR).ToggleMulDispl(0);
                this.GetBundleAt(this.elemB).ToggleModel(0);
            }
            this.elemB = -1;
        }
        this.InvalidateColor();
    }

    public void MarkChannel(int n) {
        this.MarkChannel(this.ActiveElement, n);
    }

    public void MarkChannel(int n, int n2) {
        if (n2 == 0) {
            this.elemR = n;
            this.GetBundleAt(this.elemR).ToggleOverlayDispl(1);
            this.GetBundleAt(this.elemR).ToggleModel(1);
        }
        if (n2 == 1) {
            this.elemG = n;
            this.GetBundleAt(this.elemG).ToggleOverlayDispl(1);
            this.GetBundleAt(this.elemG).ToggleModel(2);
        }
        if (n2 == 2) {
            this.elemB = n;
            this.GetBundleAt(this.elemB).ToggleOverlayDispl(1);
            this.GetBundleAt(this.elemB).ToggleModel(3);
        }
        this.InvalidateColor();
    }

    public void MarkAsHistoDim(int n) {
        System.out.println("Element " + this.ActiveElement + " marked as HistoDim " + n);
        if (n == 0 && this.HistoX != this.ActiveElement) {
            this.HistoX = this.ActiveElement;
        }
        if (n == 1) {
            this.HistoY = this.HistoY == this.ActiveElement && this.HistoZ == -1 ? -1 : this.ActiveElement;
        }
        if (n == 2) {
            this.HistoZ = this.HistoZ == this.ActiveElement ? -1 : this.ActiveElement;
        }
    }

    public void ToggleSquareROIs() {
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).ToggleROI();
        }
        this.InvalidateProjs(-1);
    }

    public boolean SquareROIs() {
        return this.BundleAt(this.ActiveElement).SquareROIs();
    }

    public void ToggleColor(boolean bl) {
        this.colormode = bl;
    }

    public void ToggleColor() {
        this.colormode = !this.colormode;
    }

    public void ComputeColorProj(int n) {
        int n2 = this.elemR;
        int n3 = this.elemG;
        int n4 = this.elemB;
        this.MyColorProjection[n].ClearColor();
        if (n2 >= 0) {
            this.MyColorProjection[n].MergeColor(0, this.ProjAt(n, n2));
        }
        if (n3 >= 0) {
            this.MyColorProjection[n].MergeColor(1, this.ProjAt(n, n3));
        }
        if (n4 >= 0) {
            this.MyColorProjection[n].MergeColor(2, this.ProjAt(n, n4));
        }
        this.MyColorProjection[n].isValid = true;
    }

    Bundle BundleAt(int n) {
        return (Bundle)this.MyBundle.elementAt(n);
    }

    private AnElement GNE(AnElement anElement, Vector vector, Vector[] vectorArray) {
        AnElement anElement2 = null;
        if (AnElement.DataType == AnElement.IntegerType) {
            IntegerElement integerElement = (IntegerElement)anElement;
            anElement2 = new IntegerElement(integerElement.Sizes[0], integerElement.Sizes[1], integerElement.Sizes[2], integerElement.NumBytes, integerElement.MaxValue);
        } else if (AnElement.DataType == AnElement.FloatType) {
            anElement2 = new FloatElement(anElement.Sizes[0], anElement.Sizes[1], anElement.Sizes[2], 1000.0f);
        } else if (AnElement.DataType == AnElement.DoubleType) {
            anElement2 = new DoubleElement(anElement.Sizes[0], anElement.Sizes[1], anElement.Sizes[2], 1000.0);
        } else if (AnElement.DataType == AnElement.ComplexType) {
            anElement2 = new ComplexElement(anElement.Sizes[0], anElement.Sizes[1], anElement.Sizes[2], 1000.0);
        } else if (AnElement.DataType == AnElement.ByteType) {
            anElement2 = new ByteElement(anElement.Sizes[0], anElement.Sizes[1], anElement.Sizes[2]);
        } else {
            System.out.println("Fatal Error! Element of unknown type: " + AnElement.DataType + "\n");
            throw new IllegalArgumentException("Unknown Element type\n");
        }
        vector.addElement(anElement2);
        vectorArray[0].addElement(new ASlice(0, anElement2));
        vectorArray[1].addElement(new ASlice(1, anElement2));
        vectorArray[2].addElement(new ASlice(2, anElement2));
        anElement2.SetScales(anElement);
        return anElement2;
    }

    private void GNE(AnElement anElement) {
        AnElement anElement2 = null;
        for (int i = 0; i < this.Times; ++i) {
            anElement2 = this.GNE(anElement, this.ElementsAtTime(i), this.ProjsAtTime(i));
        }
        ++this.Elements;
    }

    public void CloneElement(AnElement anElement) {
        if (this.Elements == 1) {
            this.MarkChannel(0);
        }
        this.GNE(anElement);
        this.MyBundle.addElement(this.BundleAt(this.Elements - 2).clone());
        this.ActiveElement = this.Elements - 1;
        if (this.Elements == 2) {
            this.MarkChannel(1);
        }
        if (this.Elements == 3) {
            this.MarkChannel(2);
        }
        this.InvalidateSlices();
        this.InvalidateColor();
    }

    public void CloneLastElements() {
        for (int i = 0; i < this.Times; ++i) {
            this.CloneElement((AnElement)this.ElementsAtTime(i).lastElement());
        }
    }

    private AnElement GNE(int n, int n2, int n3, Vector vector, Vector[] vectorArray) {
        double d = (2 << n3 - 1) - 1;
        AnElement anElement = null;
        if (n == AnElement.IntegerType) {
            anElement = new IntegerElement(this.SizeX, this.SizeY, this.SizeZ, n2, d);
        }
        if (n == AnElement.FloatType) {
            anElement = new FloatElement(this.SizeX, this.SizeY, this.SizeZ, 1000.0f);
        }
        if (n == AnElement.DoubleType) {
            anElement = new DoubleElement(this.SizeX, this.SizeY, this.SizeZ, 1000.0);
        }
        if (n == AnElement.ComplexType) {
            anElement = new ComplexElement(this.SizeX, this.SizeY, this.SizeZ, 1000.0);
        }
        if (n == AnElement.ByteType) {
            anElement = new ByteElement(this.SizeX, this.SizeY, this.SizeZ);
        }
        vector.addElement(anElement);
        vectorArray[0].addElement(new ASlice(0, anElement));
        vectorArray[1].addElement(new ASlice(1, anElement));
        vectorArray[2].addElement(new ASlice(2, anElement));
        return anElement;
    }

    private void GNE(int n, int n2, int n3) {
        AnElement anElement = null;
        for (int i = 0; i < this.Times; ++i) {
            anElement = this.GNE(n, n2, n3, this.ElementsAtTime(i), this.ProjsAtTime(i));
        }
        ++this.Elements;
    }

    public int GenerateNewElement(int n, int n2, int n3, double[] dArray, double[] dArray2, double d, double d2, String[] stringArray, String[] stringArray2, Vector vector, Vector[] vectorArray) {
        int n4 = this.Elements;
        AnElement anElement = this.GNE(n, n2, n3, vector, vectorArray);
        anElement.SetScales(dArray, dArray2, d, d2);
        anElement.Names = stringArray;
        anElement.Units = stringArray2;
        return n4;
    }

    public int GenerateNewElement(int n, int n2, int n3, double[] dArray, double[] dArray2, double d, double d2, String[] stringArray, String[] stringArray2) {
        int n4 = 0;
        for (int i = 0; i < this.Times; ++i) {
            n4 = this.GenerateNewElement(n, n2, n3, dArray, dArray2, d, d2, stringArray, stringArray2, this.ElementsAtTime(i), this.ProjsAtTime(i));
        }
        double d3 = (2 << n3 - 1) - 1;
        Bundle bundle = n == AnElement.FloatType ? new Bundle(0, 0.0, 1000.0) : (n == AnElement.ByteType ? new Bundle(0, 0.0, d3) : new Bundle(0, 0.0, d3));
        this.MyBundle.addElement(bundle);
        bundle.TakeSqrROIs(this.ProjMin, this.ProjMax);
        bundle.TakePolyROIs(this.ROIPolygons);
        bundle.ActiveROI = n4 > 0 ? (this.BundleAt((int)0).ActiveROI == this.BundleAt((int)0).rectROI ? bundle.rectROI : bundle.polyROI) : bundle.rectROI;
        ++this.Elements;
        return n4;
    }

    public void AdjustOffsetToROIMean() {
        int n = this.ActiveElement;
        double d = this.GetROIAvg(n);
        this.SetValueOffset(n, this.GetValueOffset(n) - d);
        this.InvalidateProjs(n);
        this.InvalidateSlices();
    }

    int GetPartnerElem() {
        int n = this.GateElem;
        if (n < 0) {
            n = this.Elements - 1;
        }
        return n;
    }

    public void AddMarkedElement() {
        int n = this.GetPartnerElem();
        if (n >= 0) {
            for (int i = 0; i < this.Times; ++i) {
                this.ElementAt(this.ActiveElement, i).Add(this.ElementAt(n, i));
            }
        }
        this.InvalidateSlices();
    }

    public void SubMarkedElement() {
        int n = this.GetPartnerElem();
        if (n >= 0) {
            for (int i = 0; i < this.Times; ++i) {
                this.ElementAt(this.ActiveElement, i).Sub(this.ElementAt(n, i));
            }
        }
        this.InvalidateSlices();
    }

    public void MulMarkedElement() {
        int n = this.GetPartnerElem();
        if (n >= 0) {
            for (int i = 0; i < this.Times; ++i) {
                this.ElementAt(this.ActiveElement, i).Mul(this.ElementAt(n, i));
            }
        }
        this.InvalidateSlices();
    }

    public void DivMarkedElement() {
        int n = this.GetPartnerElem();
        if (n >= 0) {
            for (int i = 0; i < this.Times; ++i) {
                this.ElementAt(this.ActiveElement, i).Div(this.ElementAt(n, i));
            }
        }
        this.InvalidateSlices();
    }

    public void DeleteActElement(Vector vector) {
        if (this.Elements <= 1) {
            return;
        }
        if (this.elemR == this.ActiveElement) {
            this.elemR = -1;
        } else if (this.elemR > this.ActiveElement) {
            --this.elemR;
        }
        if (this.elemG == this.ActiveElement) {
            this.elemG = -1;
        } else if (this.elemG > this.ActiveElement) {
            --this.elemG;
        }
        if (this.elemB == this.ActiveElement) {
            this.elemB = -1;
        } else if (this.elemB > this.ActiveElement) {
            --this.elemB;
        }
        if (this.GateElem == this.ActiveElement) {
            this.GateElem = 0;
        } else if (this.GateElem > this.ActiveElement) {
            --this.GateElem;
        }
        vector.removeElementAt(this.ActiveElement);
    }

    public void DeleteActElement() {
        if (this.Elements > 1) {
            for (int i = 0; i < this.Times; ++i) {
                this.DeleteActElement(this.ElementsAtTime(i));
            }
            this.MyBundle.removeElementAt(this.ActiveElement);
            this.MyProjections[0].removeElementAt(this.ActiveElement);
            this.MyProjections[1].removeElementAt(this.ActiveElement);
            this.MyProjections[2].removeElementAt(this.ActiveElement);
            --this.Elements;
            if (this.ActiveElement >= this.Elements) {
                this.ActiveElement = this.Elements - 1;
            }
            this.InvalidateSlices();
            this.InvalidateColor();
        }
    }

    public Color GetMarkerColor(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.GetBundleAt((int)n).cmapcHigh;
        if (n5 > 32768) {
            n5 = 32768;
        }
        n2 = this.GetBundleAt((int)n).cmapRed[n5 - 2];
        n3 = this.GetBundleAt((int)n).cmapGreen[n5 - 2];
        n4 = this.GetBundleAt((int)n).cmapBlue[n5 - 2];
        if (n2 < 0) {
            n2 += 256;
        }
        if (n3 < 0) {
            n3 += 256;
        }
        if (n4 < 0) {
            n4 += 256;
        }
        if (n2 < 50) {
            n2 = 50;
        }
        if (n3 < 50) {
            n3 = 50;
        }
        if (n4 < 50) {
            n4 = 50;
        }
        return new Color(n2, n3, n4);
    }

    public Color GetCMapColor(int n, int n2, int n3) {
        return this.GetBundleAt(n).GetCMapColor(n2, n3);
    }

    public double Normalize(double d, int n) {
        return (d - this.GetMinThresh(n)) / (this.GetMaxThresh(n) - this.GetMinThresh(n));
    }

    public double NormedValueAt(int n, int n2, int n3, int n4) {
        double d = this.ElementAt(n4).GetRawValueAt(n, n2, n3);
        double d2 = this.GetMinThresh(n4);
        double d3 = this.GetMaxThresh(n4);
        if (!this.GetBundleAt((int)n4).LogScale) {
            return (d - d2) / (d3 - d2);
        }
        if (d > 0.0) {
            double d4 = 0.1;
            double d5 = 1.0;
            if (d2 > 0.0) {
                d4 = d2;
            }
            if (d3 > 0.0) {
                d5 = d3;
            }
            return (Math.log(d) - Math.log(d4)) / (Math.log(d5) - Math.log(d4));
        }
        return -10.0;
    }

    public int GetIntValueAt(int n, int n2, int n3, int n4) {
        return this.ElementAt(n4).GetIntValueAt(n, n2, n3);
    }

    public Color GetColColor(int n, int n2, int n3, int n4) {
        int n5 = this.GetIntValueAt(n2, n3, n4, n);
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 > Short.MAX_VALUE) {
            n5 = Short.MAX_VALUE;
        }
        int n6 = this.GetBundleAt((int)n).cmapRed[n5] & 0xFF;
        int n7 = this.GetBundleAt((int)n).cmapGreen[n5] & 0xFF;
        int n8 = this.GetBundleAt((int)n).cmapBlue[n5] & 0xFF;
        return new Color(n6, n7, n8);
    }

    public double NormedProjValueAt(int n, int n2, int n3) {
        this.DoProject(n3, n);
        double d = this.ProjAt(n, n3).GetNormed1DProjValue(n2);
        if (!this.GetBundleAt((int)n3).LogScale) {
            return d;
        }
        if (d > 0.0) {
            return (Math.log(d) - Math.log(0.01)) / -Math.log(0.01);
        }
        return -10.0;
    }

    public double ProjValueAt(int n, int n2, int n3) {
        this.DoProject(n3, n);
        return this.ProjAt(n, n3).Get1DProjValue(n2);
    }

    public double ValueAt(int n, int n2, int n3, int n4) {
        return this.ElementAt(n4).GetValueAt(n, n2, n3);
    }

    public void ApplyHistSelection() {
        if (this.DataToHistogram == null) {
            System.out.println("Error: No data connected to this histogram");
        } else {
            this.DataToHistogram.GenerateNewElement(AnElement.IntegerType, 4, 32, this.DataToHistogram.GetScale(0), this.DataToHistogram.GetOffset(0), 1.0, 0.0, this.DataToHistogram.GetAxisNames(), this.DataToHistogram.GetAxisUnits());
            this.DataToHistogram.setElement(this.DataToHistogram.Elements - 1);
            AnElement anElement = this.DataToHistogram.ActElement();
            this.ActElement().ComputeHistMask(anElement, this.ActROI());
            this.DataToHistogram.BundleAt(this.DataToHistogram.Elements - 1).SetMaxcs(anElement.Max);
            this.DataToHistogram.BundleAt(this.DataToHistogram.Elements - 1).SetMincs(anElement.Min);
        }
    }

    public void CloneFloat() {
        int n = this.ActiveElement;
        int n2 = this.GenerateNewElement(AnElement.FloatType, 4, 32, this.GetScale(this.ActiveElement), this.GetOffset(this.ActiveElement), 1.0, 0.0, this.GetAxisNames(), this.GetAxisUnits());
        for (int i = 0; i < this.Times; ++i) {
            this.ElementAt(n2, i).CopyVal(this.ElementAt(n, i));
        }
    }

    public void CloneShort() {
        int n = this.ActiveElement;
        int n2 = this.GenerateNewElement(AnElement.IntegerType, 2, 16, this.GetScale(this.ActiveElement), this.GetOffset(this.ActiveElement), 1.0, 0.0, this.GetAxisNames(), this.GetAxisUnits());
        for (int i = 0; i < this.Times; ++i) {
            ((IntegerElement)this.ElementAt(n2, i)).CopyIntVal(this.ElementAt(n, i), this.Getmincs(n), this.Getmaxcs(n));
        }
    }

    public void GenerateMask(int n) {
        int n2 = this.ActiveElement;
        int n3 = 0;
        if (this.ProjMode[n]) {
            this.ActElement();
            n3 = this.GenerateNewElement(AnElement.DataType, this.ActElement().GetStdByteNum(), this.ActElement().GetStdBitNum(), this.GetScale(this.ActiveElement), this.GetOffset(this.ActiveElement), 1.0, 0.0, this.GetAxisNames(), this.GetAxisUnits());
            this.ElementAt(n3).GenerateMask(this.ROIAt(n2), this.GetGateElem(), this.ElementAt(n2), true);
        } else {
            n3 = this.GenerateNewElement(AnElement.ByteType, 1, 8, this.GetScale(this.ActiveElement), this.GetOffset(this.ActiveElement), 1.0, 0.0, this.GetAxisNames(), this.GetAxisUnits());
            this.ElementAt(n3).SetScales(1.0, 0.0, "inside ROI", "a.u.");
            this.ElementAt(n3).GenerateMask(this.ROIAt(n2), this.GetGateElem(), this.ElementAt(n2), false);
            this.BundleAt(n3).SetMaxcs(1.0);
            this.BundleAt(n3).SetMincs(0.0);
        }
        this.setElement(n3);
    }

    AnElement ElementAt(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            return (AnElement)this.ElementsAtTime(n2).elementAt(n);
        }
        return null;
    }

    AnElement ElementAt(int n) {
        if (n >= 0) {
            return (AnElement)this.MyElements.elementAt(n);
        }
        return null;
    }

    AnElement ActElement() {
        return this.ElementAt(this.ActiveElement);
    }

    ROI ROIAt(int n) {
        return this.BundleAt((int)n).ActiveROI;
    }

    ROI ActROI() {
        return this.ROIAt(this.ActiveElement);
    }

    public int GetPolyROISize(int n) {
        if (this.ROIPolygons[n] != null) {
            return this.ROIPolygons[n].npoints;
        }
        return 0;
    }

    public void GetPolyROICoords(int n, int n2, float[] fArray) {
        if (this.ROIPolygons[n] != null) {
            fArray[0] = this.ROIPolygons[n].xpoints[n2];
            fArray[1] = this.ROIPolygons[n].ypoints[n2];
        }
    }

    public void MovePolyROI(int n, int n2, int n3) {
        this.ROIPolygons[n3].translate(n, n2);
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).TakePolyROIs(this.ROIPolygons);
        }
        this.InvalidateProjs(-1);
    }

    public void MoveSqrROI(int n, int n2, int n3) {
        Rectangle rectangle = this.GetSqrROI(n3);
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).UpdateSqrROI(rectangle.x + n, rectangle.y + n2, rectangle.x + rectangle.width + n, rectangle.y + rectangle.height + n2, n3);
        }
        this.InvalidateProjs(-1);
    }

    public void MoveROI(int n, int n2, int n3) {
        if (this.SquareROIs()) {
            this.MoveSqrROI(n, n2, n3);
        } else {
            this.MovePolyROI(n, n2, n3);
        }
    }

    public void TakePolyROI(int n, int n2, int n3) {
        if (this.ROIPolygons[n3] == null) {
            this.ROIPolygons[n3] = new Polygon();
        }
        this.ROIPolygons[n3].addPoint(n, n2);
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).TakePolyROIs(this.ROIPolygons);
        }
        this.InvalidateProjs(-1);
    }

    public void ClearPolyROIs(int n) {
        this.ROIPolygons[n] = null;
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).TakePolyROIs(this.ROIPolygons);
        }
        this.InvalidateProjs(-1);
    }

    public void ClearPolyROIs() {
        this.ROIPolygons[0] = null;
        this.ROIPolygons[1] = null;
        this.ROIPolygons[2] = null;
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).TakePolyROIs(this.ROIPolygons);
        }
        this.InvalidateProjs(-1);
    }

    public void TakeLineROI(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n5 == 0) {
            d = 0.0;
            n8 = n;
            d2 = n3 - n;
            n7 = n2;
            d3 = -(n4 - n2);
        } else if (n5 == 1) {
            d2 = 0.0;
            n6 = n;
            d3 = n3 - n;
            n8 = n2;
            d = -(n4 - n2);
        } else {
            d3 = 0.0;
            n6 = n;
            d2 = n3 - n;
            n7 = n2;
            d = -(n4 - n2);
        }
        this.PlanesS[0].addElement(new Integer(n6));
        this.PlanesS[1].addElement(new Integer(n7));
        this.PlanesS[2].addElement(new Integer(n8));
        this.PlanesD[0].addElement(new Double(d));
        this.PlanesD[1].addElement(new Double(d2));
        this.PlanesD[2].addElement(new Double(d3));
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).TakePlaneROIs(this.PlanesS, this.PlanesD);
        }
        this.InvalidateProjs(-1);
    }

    public void ClearLineROIs() {
        this.PlanesS[0].removeAllElements();
        this.PlanesS[1].removeAllElements();
        this.PlanesS[2].removeAllElements();
        this.PlanesD[0].removeAllElements();
        this.PlanesD[1].removeAllElements();
        this.PlanesD[2].removeAllElements();
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).TakePlaneROIs(this.PlanesS, this.PlanesD);
        }
        this.InvalidateProjs(-1);
    }

    public Rectangle GetSqrROI(int n) {
        return this.BundleAt((int)this.ActiveElement).rectROI.GetSqrROI(n);
    }

    public void TakeROI(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 > n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        if (n5 == 0) {
            this.ProjMin[2] = n;
            this.ProjMax[2] = n3;
            this.ProjMin[1] = n2;
            this.ProjMax[1] = n4;
        } else if (n5 == 1) {
            this.ProjMin[0] = n;
            this.ProjMax[0] = n3;
            this.ProjMin[2] = n2;
            this.ProjMax[2] = n4;
        } else {
            this.ProjMin[0] = n;
            this.ProjMax[0] = n3;
            this.ProjMin[1] = n2;
            this.ProjMax[1] = n4;
        }
        for (int i = 0; i < this.Elements; ++i) {
            this.BundleAt(i).UpdateSqrROI(n, n2, n3, n4, n5);
        }
        this.InvalidateProjs(-1);
    }

    public void TakeDataToHistogram(My3DData my3DData) {
        this.ActElement().DataToHistogramX = my3DData.ElementAt(my3DData.HistoX);
        this.ActElement().DataToHistogramY = my3DData.ElementAt(my3DData.HistoY);
        this.ActElement().DataToHistogramZ = my3DData.ElementAt(my3DData.HistoZ);
        this.DataToHistogram = my3DData;
    }

    AnElement GetGateElem(int n) {
        AnElement anElement = null;
        anElement = this.GateElem >= 0 && this.GateActive ? this.ElementAt(this.GateElem, n) : new OneElement(this.SizeX, this.SizeY, this.SizeZ);
        return anElement;
    }

    AnElement GetGateElem() {
        return this.GetGateElem(this.ActiveTime);
    }

    void ComputeHistogram() {
        double d = this.ActElement().ComputeHistogram(this.DataToHistogram.GetGateElem(), this.DataToHistogram.ActROI());
        this.BundleAt(this.ActiveElement).SetMaxcs(this.ActElement().Max);
        this.BundleAt(this.ActiveElement).SetMincs(this.ActElement().Min);
        this.ToggleLog(1);
        this.ToggleOvUn(0);
    }

    void SetMinMaxCalib(ImagePlus imagePlus, int n) {
        double[] dArray = new double[]{this.GetValueOffset(this.ActiveElement), this.GetValueScale(this.ActiveElement)};
        if (!this.colormode) {
            if (n >= 0) {
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                this.BundleAt(this.ActiveElement);
                imageProcessor.setMinAndMax(0.0, 32768.0);
            } else {
                imagePlus.getProcessor().setMinAndMax((this.GetScaledMincs(this.ActiveElement) - dArray[0]) / dArray[1], (this.GetScaledMaxcs(this.ActiveElement) - dArray[0]) / dArray[1]);
            }
        }
        Calibration calibration = imagePlus.getCalibration();
        double d = this.GetScale(this.ActiveElement, 0);
        double d2 = this.GetScale(this.ActiveElement, 1);
        double d3 = this.GetScale(this.ActiveElement, 2);
        double d4 = this.GetOffset(this.ActiveElement, 0);
        double d5 = this.GetOffset(this.ActiveElement, 1);
        double d6 = this.GetOffset(this.ActiveElement, 2);
        calibration.pixelWidth = d;
        calibration.pixelHeight = d2;
        calibration.pixelDepth = d3;
        calibration.xOrigin = d4;
        calibration.yOrigin = d5;
        calibration.zOrigin = d6;
        calibration.setUnit(this.GetAxisUnits()[0]);
        if (n >= 0) {
            switch (n) {
                case 0: {
                    d = this.GetScale(this.ActiveElement, 2);
                    d4 = this.GetOffset(this.ActiveElement, 2);
                    d2 = this.GetScale(this.ActiveElement, 1);
                    d5 = this.GetOffset(this.ActiveElement, 1);
                    break;
                }
                case 1: {
                    d = this.GetScale(this.ActiveElement, 0);
                    d4 = this.GetOffset(this.ActiveElement, 0);
                    d2 = this.GetScale(this.ActiveElement, 2);
                    d5 = this.GetOffset(this.ActiveElement, 2);
                    break;
                }
                case 2: {
                    d = this.GetScale(this.ActiveElement, 0);
                    d4 = this.GetOffset(this.ActiveElement, 0);
                    d2 = this.GetScale(this.ActiveElement, 1);
                    d5 = this.GetOffset(this.ActiveElement, 1);
                }
            }
        } else {
            calibration.setFunction(0, dArray, this.GetValueUnit(this.ActiveElement));
        }
    }

    void Export(int n, int n2) {
        ImagePlus imagePlus = null;
        if (n >= 0) {
            imagePlus = this.colormode ? this.getDisplayedSlice(n, n2).ColorExport() : this.getDisplayedSlice(n, n2).Export();
        } else {
            if (this.ActElement() instanceof ByteElement) {
                imagePlus = NewImage.createByteImage("View5D Volume", this.SizeX, this.SizeY, this.SizeZ, 1);
            }
            if (this.ActElement() instanceof IntegerElement) {
                imagePlus = NewImage.createShortImage("View5D Volume", this.SizeX, this.SizeY, this.SizeZ, 1);
            }
            if (this.ActElement() instanceof FloatElement) {
                imagePlus = NewImage.createFloatImage("View5D Volume", this.SizeX, this.SizeY, this.SizeZ, 1);
            }
            if (this.ActElement() instanceof DoubleElement) {
                imagePlus = NewImage.createFloatImage("View5D Volume", this.SizeX, this.SizeY, this.SizeZ, 1);
            }
            for (int i = 0; i < this.SizeZ; ++i) {
                this.ActElement().CopySliceToSimilar(i, imagePlus.getStack().getPixels(i + 1));
            }
        }
        this.SetMinMaxCalib(imagePlus, n);
        imagePlus.show();
        imagePlus.updateAndDraw();
    }

    public void SetUp(int n, View5D_ view5D_, int n2, int n3, int n4) {
        if (this.SizeX * this.SizeY * this.SizeZ == 0) {
            view5D_.add("South", new Label("Error ! Image has zero sizes !\n"));
            ((Component)view5D_).setVisible(true);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        try {
            if (n4 == 4) {
                n2 /= 3;
            }
            for (int i = 0; i < n3; ++i) {
                n6 = 0;
                n5 = 0;
                for (n8 = 0; n8 < this.SizeZ * n2; ++n8) {
                    if (n4 == 4) {
                        int[] nArray = (int[])view5D_.GetImp().getStack().getPixels(n7 + 1);
                        this.ElementAt(this.Elements - 3 * n2 + n5, i).ConvertSliceFromRGB(n6, 0, nArray, 1, 0, 2);
                        this.ElementAt(this.Elements - 3 * n2 + n5 + 1, i).ConvertSliceFromRGB(n6, 0, nArray, 1, 0, 1);
                        this.ElementAt(this.Elements - 3 * n2 + n5 + 2, i).ConvertSliceFromRGB(n6, 0, nArray, 1, 0, 0);
                    } else {
                        this.ElementAt(this.Elements - n2 + n5, i).ConvertSliceFromSimilar(n6, 0, view5D_.GetImp().getStack().getPixels(n7 + 1), 1, 0);
                    }
                    ++n7;
                    if (++n6 != this.SizeZ) continue;
                    if (n5 < this.Elements - 1) {
                        n5 = n4 == 4 ? (n5 += 3) : ++n5;
                    }
                    n6 = 0;
                }
            }
        }
        catch (Exception exception) {
            view5D_.add("South", new Label("Memoryexception appeared during data setup ! (" + this.SizeX + ", " + this.SizeY + ", " + this.SizeZ + ") \n"));
            System.out.println("Exception appeared during data setup ! (" + this.SizeX + ", " + this.SizeY + ", " + this.SizeZ + ", slice# " + n6 + ", z: " + n8 + ", ijslice: " + n7 + ") \n");
            System.out.println("Exception was : " + exception);
            exception.printStackTrace();
            ((Component)view5D_).setVisible(true);
        }
    }

    public void SaveMarkers() {
        try {
            System.out.println("Saving marker file: " + this.markerOutfilename);
            FileOutputStream fileOutputStream = new FileOutputStream(this.markerOutfilename);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            bufferedWriter.write(this.GetMarkerPrintout(this));
            ((Writer)bufferedWriter).close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("saving markers, IOException:" + iOException);
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("saving markers, Memoryexception! " + exception + "\n");
            exception.printStackTrace();
        }
    }

    public void LoadMarkers() {
        URL uRL = null;
        try {
            uRL = this.applet instanceof View5D ? new URL(((View5D)this.applet).getDocumentBase(), this.markerInfilename) : (IJ.isWindows() ? new URL("file:////" + this.markerInfilename) : new URL("file://" + this.markerInfilename));
            System.out.println("Opening Markerfile " + uRL + "\n");
            InputStream inputStream = uRL.openStream();
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(inputStream)));
            streamTokenizer.commentChar(35);
            streamTokenizer.slashSlashComments(true);
            streamTokenizer.slashStarComments(true);
            streamTokenizer.parseNumbers();
            while (this.MyMarkers.readline(streamTokenizer, this)) {
            }
            inputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("In Markerfile " + uRL + "\n");
            System.out.println("reading markers, URLException:" + malformedURLException);
            this.applet.add("South", new Label("URLException:" + malformedURLException + "\n"));
            malformedURLException.printStackTrace();
            this.applet.setVisible(true);
        }
        catch (IOException iOException) {
            System.out.println("In Markerfile " + uRL + "\n");
            System.out.println("reading markers, URLException:" + iOException);
            this.applet.add("South", new Label("IOException:" + iOException + "\n"));
            this.applet.add("South", new Label("Error: Unable to load file  " + this.markerInfilename + "\n"));
            iOException.printStackTrace();
            this.applet.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("In Markerfile " + uRL + "\n");
            this.applet.add("South", new Label("Exception appeared during load!\n" + exception + "\n"));
            System.out.println("reading markers, Memoryexception! " + exception + "\n");
            exception.printStackTrace();
            this.applet.setVisible(true);
        }
    }

    public void Load(int n, int n2, int n3, String string, Applet applet) {
        try {
            URL uRL = new URL(applet.getDocumentBase(), string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            this.PrevType = n;
            this.PrevBytes = n2;
            this.PrevBits = n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            this.ActiveElement = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = this.SizeX * this.SizeY;
            byte[] byArray = null;
            System.out.println("Loading ... ");
            System.out.println("Type Nr (from # bytes, -1 = float): [0: byte, 1: int, 2: float, 3:double, 4:complex(float)]" + n);
            System.out.println("Number of Bytes :" + n2);
            System.out.println("Number of Bits :" + n3);
            byArray = new byte[n2 * this.SizeX * this.SizeY * this.SizeZ];
            System.out.println("SliceSize :" + (n9 *= n2));
            while (true) {
                if ((n4 += (n5 = bufferedInputStream.read(byArray, n4 + n6 * n9, n9 - n4))) < n9 && n5 != -1) {
                    continue;
                }
                n4 = 0;
                if (n5 != -1) {
                    System.out.println("bread :" + n5);
                    this.ElementAt(n7, n8).ConvertSliceFromByte(n6, n6, byArray, 1, 0);
                    if (++n6 == this.SizeZ) {
                        if (n8 < this.Times - 1) {
                            ++n8;
                        } else {
                            n8 = 0;
                            ++n7;
                        }
                        n6 = 0;
                    }
                } else {
                    System.out.println(".. ignored");
                }
                if (n5 == -1) break;
            }
            for (int i = 0; i < this.Elements; ++i) {
                AnElement anElement = this.ElementAt(i);
                anElement.SetMinMax();
                if (!(anElement instanceof FloatElement) && !(anElement instanceof DoubleElement)) continue;
                anElement.MaxValue = anElement.Max;
                anElement.shift = anElement.Min;
            }
            bufferedInputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("URLException:" + malformedURLException);
            this.applet.add("South", new Label("URLException:" + malformedURLException + "\n"));
            malformedURLException.printStackTrace();
            this.applet.setVisible(true);
        }
        catch (IOException iOException) {
            System.out.println("URLException:" + iOException);
            this.applet.add("South", new Label("IOException:" + iOException + "\n"));
            this.applet.add("South", new Label("Error: Unable to load file  " + string + "\n"));
            iOException.printStackTrace();
            this.applet.setVisible(true);
        }
        catch (Exception exception) {
            this.applet.add("South", new Label("Exception appeared during load!\n" + exception + "\n"));
            System.out.println("Memoryexception appeared during data setup ! Element: " + exception + "\n");
            exception.printStackTrace();
            this.applet.setVisible(true);
        }
    }

    public boolean GetProjectionMode(int n) {
        return this.ProjMode[n];
    }

    public boolean GetMIPMode(int n) {
        return this.BundleAt((int)this.ActiveElement).MIPMode;
    }

    public boolean GetLogMode() {
        return this.BundleAt((int)this.ActiveElement).LogScale;
    }

    ASlice ActProj(int n) {
        return (ASlice)this.MyProjections[n].elementAt(this.ActiveElement);
    }

    ASlice ProjAt(int n, int n2) {
        return (ASlice)this.MyProjections[n].elementAt(n2);
    }

    public void ToggleProj(int n, boolean bl) {
        if (bl != this.BundleAt((int)this.ActiveElement).MIPMode) {
            this.InvalidateProjs(-1);
        }
        this.BundleAt((int)this.ActiveElement).MIPMode = bl;
        this.ProjMode[n] = !this.ProjMode[n];
    }

    public My3DData(My3DData my3DData) {
        this.DataToHistogram = my3DData.DataToHistogram;
        this.applet = my3DData.applet;
        this.SizeX = my3DData.SizeX;
        this.sizes[0] = my3DData.sizes[0];
        this.SizeY = my3DData.SizeY;
        this.sizes[1] = my3DData.sizes[1];
        this.SizeZ = my3DData.SizeZ;
        this.sizes[2] = my3DData.sizes[2];
        if (IJ.isWindows()) {
            if (this.markerInfilename == null) {
                this.markerInfilename = "C:\\temp\\markers.txt";
            }
            if (this.markerOutfilename == null) {
                this.markerOutfilename = "C:\\temp\\markers.txt";
            }
        } else {
            if (this.markerInfilename == null) {
                this.markerInfilename = "/tmp/markers.txt";
            }
            if (this.markerOutfilename == null) {
                this.markerOutfilename = "/tmp/markers.txt";
            }
        }
        this.Elements = my3DData.Elements;
        this.sizes[3] = my3DData.sizes[3];
        this.Times = my3DData.Times;
        this.sizes[4] = my3DData.sizes[4];
        this.PrevBytes = my3DData.PrevBytes;
        this.PrevBits = my3DData.PrevBits;
        this.MyMarkers = my3DData.MyMarkers;
        this.HistoX = my3DData.HistoX;
        this.HistoY = my3DData.HistoY;
        this.HistoZ = my3DData.HistoZ;
        this.elemR = my3DData.elemR;
        this.elemG = my3DData.elemG;
        this.elemB = my3DData.elemB;
        this.GateElem = my3DData.GateElem;
        this.GateActive = my3DData.GateActive;
        this.PlanesS = new Vector[3];
        this.PlanesD = new Vector[3];
        this.PlanesS[0] = new Vector();
        this.PlanesS[1] = new Vector();
        this.PlanesS[2] = new Vector();
        this.PlanesD[0] = new Vector();
        this.PlanesD[1] = new Vector();
        this.PlanesD[2] = new Vector();
        this.ROIPolygons = new Polygon[3];
        this.ProjMin = new int[3];
        this.ProjMax = new int[3];
        this.ProjMin[0] = my3DData.ProjMin[0];
        this.ProjMin[1] = my3DData.ProjMin[1];
        this.ProjMin[2] = my3DData.ProjMin[2];
        this.ProjMax[0] = my3DData.ProjMax[0];
        this.ProjMax[1] = my3DData.ProjMax[1];
        this.ProjMax[2] = my3DData.ProjMax[2];
        this.ProjMode = new boolean[3];
        this.ProjMode[0] = my3DData.ProjMode[0];
        this.ProjMode[1] = my3DData.ProjMode[1];
        this.ProjMode[2] = my3DData.ProjMode[2];
        this.MySlice = new ASlice[3];
        this.MyColorSlice = new ASlice[3];
        try {
            int n;
            this.MyElements = my3DData.MyElements;
            this.Elements = my3DData.Elements;
            this.MyTimes = my3DData.MyTimes;
            this.Times = my3DData.Times;
            this.MyBundle = new Vector();
            this.MyTimeProj = new Vector();
            this.MyTimeColorProj = new Vector();
            for (n = 0; n < my3DData.Elements; ++n) {
                this.MyBundle.addElement(my3DData.BundleAt(n).clone());
            }
            for (n = 0; n < my3DData.Times; ++n) {
                this.MyProjections = new Vector[3];
                this.MyProjections[0] = new Vector();
                this.MyProjections[1] = new Vector();
                this.MyProjections[2] = new Vector();
                for (int i = 0; i < my3DData.Elements; ++i) {
                    this.MyProjections[0].addElement(new ASlice(0, my3DData.ElementAt(i)));
                    this.MyProjections[1].addElement(new ASlice(1, my3DData.ElementAt(i)));
                    this.MyProjections[2].addElement(new ASlice(2, my3DData.ElementAt(i)));
                }
                this.MyTimeProj.addElement(this.MyProjections);
            }
            this.MyElements = (Vector)this.MyTimes.elementAt(0);
            this.MyProjections = (Vector[])this.MyTimeProj.elementAt(0);
            this.MySlice[0] = new ASlice(0, (AnElement)this.MyElements.firstElement());
            this.MySlice[1] = new ASlice(1, (AnElement)this.MyElements.firstElement());
            this.MySlice[2] = new ASlice(2, (AnElement)this.MyElements.firstElement());
            this.MyColorSlice[0] = new ASlice(0, (AnElement)this.MyElements.firstElement());
            this.MyColorSlice[1] = new ASlice(1, (AnElement)this.MyElements.firstElement());
            this.MyColorSlice[2] = new ASlice(2, (AnElement)this.MyElements.firstElement());
            for (n = 0; n < my3DData.Times; ++n) {
                this.MyColorProjection = new ASlice[3];
                this.MyColorProjection[0] = new ASlice(0, (AnElement)this.ElementsAtTime(n).firstElement());
                this.MyColorProjection[1] = new ASlice(1, (AnElement)this.ElementsAtTime(n).firstElement());
                this.MyColorProjection[2] = new ASlice(2, (AnElement)this.ElementsAtTime(n).firstElement());
                this.MyTimeColorProj.addElement(this.MyColorProjection);
            }
            this.MyColorProjection = (ASlice[])this.MyTimeColorProj.elementAt(0);
            this.ActiveElement = my3DData.ActiveElement;
            this.ActiveTime = my3DData.ActiveTime;
        }
        catch (Exception exception) {
            System.out.println("Exception appeared during spawning viewer !\n");
            exception.printStackTrace();
            this.applet.add("South", new Label("Exception appeared during spawning viewer!\n"));
            this.applet.setVisible(true);
        }
        this.ClearPolyROIs();
        this.InvalidateProjs(-1);
        this.InvalidateColor();
        this.InvalidateSlices();
        this.colormode = my3DData.colormode;
        this.ShowAllLists = my3DData.ShowAllLists;
        this.ShowAllSlices = my3DData.ShowAllSlices;
        this.ShowAllTimes = my3DData.ShowAllTimes;
        this.ShowFullTrace = my3DData.ShowFullTrace;
        this.ShowSpectralTrack = my3DData.ShowSpectralTrack;
        this.TrackDirection = my3DData.TrackDirection;
    }

    public My3DData(Container container, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, double[] dArray, double[] dArray2, double d, double d2, String[] stringArray, String[] stringArray2) {
        this.applet = container;
        this.DataToHistogram = null;
        this.SizeX = n;
        this.sizes[0] = n;
        this.SizeY = n2;
        this.sizes[1] = n2;
        this.SizeZ = n3;
        this.sizes[2] = n3;
        this.sizes[3] = n4;
        this.sizes[4] = n5;
        if (IJ.isWindows()) {
            if (this.markerInfilename == null) {
                this.markerInfilename = "C:\\temp\\markers.txt";
            }
            if (this.markerOutfilename == null) {
                this.markerOutfilename = "C:\\temp\\markers.txt";
            }
        } else {
            if (this.markerInfilename == null) {
                this.markerInfilename = "/tmp/markers.txt";
            }
            if (this.markerOutfilename == null) {
                this.markerOutfilename = "/tmp/markers.txt";
            }
        }
        try {
            this.ProjMin = new int[3];
            this.ProjMax = new int[3];
            this.ProjMin[0] = 0;
            this.ProjMin[1] = 0;
            this.ProjMin[2] = 0;
            this.ProjMax[0] = this.SizeX - 1;
            this.ProjMax[1] = this.SizeY - 1;
            this.ProjMax[2] = this.SizeZ - 1;
            this.ProjMode = new boolean[3];
            this.ProjMode[0] = false;
            this.ProjMode[1] = false;
            this.ProjMode[2] = false;
            this.PlanesS = new Vector[3];
            this.PlanesD = new Vector[3];
            this.PlanesS[0] = new Vector();
            this.PlanesS[1] = new Vector();
            this.PlanesS[2] = new Vector();
            this.PlanesD[0] = new Vector();
            this.PlanesD[1] = new Vector();
            this.PlanesD[2] = new Vector();
            this.ROIPolygons = new Polygon[3];
            this.MySlice = new ASlice[3];
            this.MyColorSlice = new ASlice[3];
            this.MyMarkers = new MarkerLists();
            this.HistoX = n9;
            this.HistoY = n10;
            this.HistoZ = n11;
        }
        catch (Exception exception) {
            System.out.println("Initialization exception !\n");
            exception.printStackTrace();
            this.applet.add("South", new Label("Error initializing !\n"));
            this.applet.setVisible(true);
        }
        try {
            int n15;
            this.MyTimes = new Vector();
            this.MyTimeProj = new Vector();
            this.MyTimeColorProj = new Vector();
            this.MyBundle = new Vector();
            this.Elements = 0;
            this.Times = n5;
            for (int i = 0; i < n5; ++i) {
                this.MyElements = new Vector();
                this.MyTimes.addElement(this.MyElements);
                this.MyProjections = new Vector[3];
                this.MyProjections[0] = new Vector();
                this.MyProjections[1] = new Vector();
                this.MyProjections[2] = new Vector();
                this.MyTimeProj.addElement(this.MyProjections);
            }
            this.MyElements = (Vector)this.MyTimes.elementAt(0);
            this.MyProjections = (Vector[])this.MyTimeProj.elementAt(0);
            String[] stringArray3 = (String[])stringArray.clone();
            String[] stringArray4 = (String[])stringArray2.clone();
            for (n15 = 0; n15 < n4; ++n15) {
                this.GenerateNewElement(n12, n13, n14, dArray, dArray2, d, d2, stringArray3, stringArray4);
            }
            for (n15 = 0; n15 < n5; ++n15) {
                this.MyColorProjection = new ASlice[3];
                this.MyColorProjection[0] = new ASlice(0, (AnElement)this.ElementsAtTime(n15).firstElement());
                this.MyColorProjection[1] = new ASlice(1, (AnElement)this.ElementsAtTime(n15).firstElement());
                this.MyColorProjection[2] = new ASlice(2, (AnElement)this.ElementsAtTime(n15).firstElement());
                this.MyTimeColorProj.addElement(this.MyColorProjection);
            }
            this.MyColorProjection = (ASlice[])this.MyTimeColorProj.elementAt(0);
        }
        catch (Exception exception) {
            System.out.println("Memoryexception appeared ! Need more space for array !\n");
            exception.printStackTrace();
            this.applet.add("South", new Label("Memoryexception appeared ! Need more space for array !\n"));
            this.applet.setVisible(true);
        }
        if (this.Elements != n4) {
            System.out.println("Error initializing elements: Wrong count: Elements = " + this.Elements + ", elements = " + n4 + "\n");
        }
        this.MySlice[0] = new ASlice(0, (AnElement)this.MyElements.firstElement());
        this.MySlice[1] = new ASlice(1, (AnElement)this.MyElements.firstElement());
        this.MySlice[2] = new ASlice(2, (AnElement)this.MyElements.firstElement());
        this.MyColorSlice[0] = new ASlice(0, (AnElement)this.MyElements.firstElement());
        this.MyColorSlice[1] = new ASlice(1, (AnElement)this.MyElements.firstElement());
        this.MyColorSlice[2] = new ASlice(2, (AnElement)this.MyElements.firstElement());
        this.ClearPolyROIs();
        this.elemR = -1;
        this.elemG = -1;
        this.elemB = -1;
        if (n6 >= 0) {
            this.MarkChannel(n6, 0);
        }
        if (n7 >= 0) {
            this.MarkChannel(n7, 1);
        }
        if (n8 >= 0) {
            this.MarkChannel(n8, 2);
        }
    }

    private void DoProject(int n, int n2) {
        if (this.BundleAt((int)n).ProjValid[n2] && this.ProjAt((int)n2, (int)n).isValid) {
            return;
        }
        this.ActProj(n2).setMIPMode(this.BundleAt((int)n).MIPMode);
        this.ProjAt(n2, n).DoProject(n2, this.ElementAt(n), this.GetGateElem(), this.ActROI());
        this.BundleAt((int)n).ProjValid[n2] = true;
        this.MyColorProjection[n2].Invalidate();
    }

    boolean InOverlayDispl(int n) {
        return this.GetBundleAt(n).InOverlayDispl();
    }

    void ToggleOverlayDispl(int n) {
        this.GetBundleAt(this.ActiveElement).ToggleOverlayDispl(n);
    }

    void ToggleMulDispl(int n) {
        this.GetBundleAt(this.ActiveElement).ToggleMulDispl(n);
    }

    Image GiveSection(int n, int n2) {
        ASlice aSlice = this.getDisplayedSlice(n, n2);
        if (this.colormode) {
            if (!this.ProjMode[n]) {
                aSlice.ClearColor();
                for (int i = 0; i < this.Elements; ++i) {
                    if (this.GetBundleAt(i).MulOverlayDispl()) {
                        this.ElementAt(i).SetScaleShift(this.Getmincs(i), this.Getmaxcs(i));
                        aSlice.MulToColorSlice(n2, this.ElementAt(i), this.GetBundleAt((int)i).cmapRed, this.GetBundleAt((int)i).cmapGreen, this.GetBundleAt((int)i).cmapBlue, this.GetGateElem());
                    }
                    if (!this.GetBundleAt(i).InOverlayDispl()) continue;
                    this.ElementAt(i).SetScaleShift(this.Getmincs(i), this.Getmaxcs(i));
                    aSlice.SumToColorSlice(n2, this.ElementAt(i), this.GetBundleAt((int)i).cmapRed, this.GetBundleAt((int)i).cmapGreen, this.GetBundleAt((int)i).cmapBlue, this.GetGateElem());
                }
            } else {
                for (int i = 0; i < this.Elements; ++i) {
                    if (!this.GetBundleAt(i).InOverlayDispl()) continue;
                    this.DoProject(i, n);
                }
                if (!aSlice.isValid) {
                    this.ComputeColorProj(n);
                }
            }
            return aSlice.GenColorImage(this.applet);
        }
        aSlice.TakeModel(this.BundleAt((int)this.ActiveElement).ElementModel);
        return aSlice.GenImage(this.applet);
    }

    ASlice getDisplayedSlice(int n, int n2) {
        if (this.colormode) {
            if (this.ProjMode[n]) {
                return this.MyColorProjection[n];
            }
            return this.MyColorSlice[n];
        }
        AnElement anElement = this.ActElement();
        anElement.SetScaleShift(this.Getmincs(this.ActiveElement), this.Getmaxcs(this.ActiveElement));
        if (this.ProjMode[n]) {
            this.DoProject(this.ActiveElement, n);
            return this.ActProj(n);
        }
        this.MySlice[n].UpdateSlice(n2, anElement, this.GetGateElem());
        return this.MySlice[n];
    }

    void Clear(int n) {
        this.ElementAt(n).Clear();
    }
}

