/*
 * Decompiled with CFR 0.152.
 */
class IntegerElement
extends AnElement {
    int[] myData;
    int SizeXY;
    int NumBytes;

    IntegerElement(int n, int n2, int n3, int n4, double d) {
        super(n, n2, n3, d);
        this.NumBytes = n4;
        this.myData = new int[this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
        this.SizeXY = this.Sizes[0] * this.Sizes[1];
        AnElement.DataType = AnElement.IntegerType;
    }

    void Clear() {
        for (int i = 0; i < this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0;
        }
    }

    void DeleteData() {
        this.myData = null;
    }

    int GetStdByteNum() {
        return 4;
    }

    void SetValueAt(int n, int n2, int n3, double d) {
        this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] = (int)d;
    }

    int GetIntValueAt(int n, int n2, int n3) {
        return (int)(((double)this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] - this.shift) * this.scaleI);
    }

    int GetByteValueAt(int n, int n2, int n3) {
        return (int)(((double)this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] - this.shift) * this.scaleB);
    }

    double GetRawValueAt(int n, int n2, int n3) {
        return this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3];
    }

    double GetValueAt(int n, int n2, int n3) {
        return (double)this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] * this.ScaleV + this.OffsetV;
    }

    void ConvertSliceFromSimilar(int n, int n2, Object object, int n3, int n4) {
        short[] sArray = (short[])object;
        for (int i = 0; i < this.SizeXY; i += n3) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * n] = sArray[n2 * this.SizeXY + i + n4] & 0xFFFF;
        }
    }

    void ConvertSliceFromByte(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = this.NumBytes * this.SizeXY;
        for (int i = 0; i < this.SizeXY; i += n3) {
            int n6;
            this.myData[i + this.SizeXY * n] = n6 = byArray[n2 * n5 + this.NumBytes * (i + n4)] & 0xFF;
            for (int j = 1; j < this.NumBytes; ++j) {
                n6 = byArray[n2 * n5 + this.NumBytes * (i + n4) + j] & 0xFF;
                int n7 = i + this.SizeXY * n;
                this.myData[n7] = this.myData[n7] | n6 << 8 * j;
            }
            double d = this.myData[i + this.SizeXY * n];
        }
    }

    void ConvertSliceFromRGB(int n, int n2, int[] nArray, int n3, int n4, int n5) {
        for (int i = 0; i < this.SizeXY; i += n3) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * n] = nArray[n2 * this.SizeXY + i + n4];
        }
    }

    void CopySliceToSimilar(int n, Object object) {
        short[] sArray = (short[])object;
        for (int i = 0; i < this.SizeXY; ++i) {
            sArray[i] = (short)this.myData[i + this.Sizes[0] * this.Sizes[1] * n];
        }
    }

    void CopyIntVal(AnElement anElement, double d, double d2) {
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    double d3 = anElement.GetValueAt(k, j, i);
                    if ((d3 = (d3 - d) / (d2 - d)) < 0.0) {
                        d3 = 0.0;
                    }
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    this.SetValueAt(k, j, i, 32767.0 * d3);
                }
            }
        }
    }
}

