%OUT = CREATERAMP(SZ,DIM,ORIGIN)
%    Basis function for XX, YY, ZZ, RR and PHIPHI.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2001.
% 26 April 2001:   Added 'frequency' option.
% 8 November 2001: Removed 'frequency' option, and replaced it by
%                  'freq' and 'radfreq'. (MvG)
% 27 April 2002:   Added 'mleft', 'mright', etc... (MvG)
% 14 August 2008:  Fixed error message when sz(dim)==1.

function out = createramp(sz,dim,origin)

if nargin ~= 3
   error('Wrong input.')
end

if isempty(origin)
   origin = 2; % 'right', like DIPlib's FFT.
else
   originopts = {'left','right','true','corner','freq','radfreq',...
                 'mleft','mright','mtrue','mcorner','mfreq','mradfrq','math'};
   origin = find(strcmp(origin,originopts));
   if isempty(origin)
      error('Illegal ORIGIN option.')
   end
   if origin == 13    % 'math'
      origin = 8;     % 'mright'
   end
   if origin >= 7 & dim ~= 2   % >= 'mleft'->'left' etc, if not along Y-axis...
      origin = origin-6;
   end
end

if isempty(sz) | prod(sz) == 0
   out = dip_image([],'single');
else
   if length(sz)>=dim & sz(dim)>1
      x = sz(dim)-1;
      switch(origin)
         case 1 % To the left
            x = -floor(x/2):floor((x+1)/2);
         case 2 % To the right
            x = -floor((x+1)/2):floor(x/2);
         case 3 % Use floating point values
            x = -x/2:x/2;
         case 4 % First pixel
            x = 0:x;
         case 5 % Use true frequency domain coordinates
            q = floor((x+1)/2);
            x = -q:floor(x/2); % (zero to the right of the center)
            if q~=0
               x = x*(0.5/q);
            end
         case 6 % Use radial frequency domain coordinates
            q = floor((x+1)/2);
            x = -q:floor(x/2); % (zero to the right of the center)
            if q~=0
               x = x*(pi/q);
            end
         case 7 % To the left
            x = -(-floor(x/2):floor((x+1)/2));
         case 8 % To the right
            x = -(-floor((x+1)/2):floor(x/2));
         case 9 % Use floating point values
            x = -(-x/2:x/2);
         case 10 % First pixel
            x = x:-1:0;
         case 11 % Use true frequency domain coordinates
            q = floor((x+1)/2);
            x = -(-q:floor(x/2)); % (zero to the right of the center)
            if q~=0
               x = x*(0.5/q);
            end
         case 12 % Use radial frequency domain coordinates
            q = floor((x+1)/2);
            x = -(-q:floor(x/2)); % (zero to the right of the center)
            if q~=0
               x = x*(pi/q);
            end
      end
      sz(dim) = 1;
      xsz = ones(size(sz));
      xsz(dim) = length(x);
      x = dip_image(x,'single');
      x = reshape(x,xsz);
   else
      x = dip_image(0,'single');
   end
   out = repmat(x,sz);
end
