%MPOWER   Overloaded operator for a^b.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2000.
% April 2004, added support for complex images (BR)
% February 2008: Adding pixel dimensions and units to dip_image. (BR)

function out = mpower(in1,in2)
if ~isnumeric(in2) | prod(size(in2))~=1
   error('Power must be scalar.')
end
% in1 is always a dip_image.
if prod(imarsize(in1))~=1
   error('Matrix power not implemented for dip_image_array.')
end
   if strcmp(in1(1).dip_type,'dfloat')
      out_type = 'dfloat';
   elseif strcmp(in1(1).dip_type,'scomplex') | strcmp(in1(1).dip_type,'dcomplex')
      out_type = in1(1).dip_type;
   else
      out_type = 'sfloat';
   end
   if mod(in2,1) & any(in1(1)<0)
      out_type = [out_type(1),'complex'];
   end
   try
      out = compute2('power',in1(1).data,double(in2),in1(1).dims,out_type,in1.physDims);
   catch
      error(di_firsterr)
end

