/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.text.TextWindow;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;

public class MacroRunner
implements Runnable {
    private String macro;
    private Program pgm;
    private int address;
    private String name;
    private Thread thread;

    public MacroRunner(String string) {
        this.macro = string;
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(File file) {
        int n = (int)file.length();
        if (n <= 0) {
            return;
        }
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer(5000);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
            this.macro = new String(stringBuffer);
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return;
        }
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(Program program, int n, String string) {
        this.pgm = program;
        this.address = n;
        this.name = string;
        this.thread = new Thread((Runnable)this, string + "_Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        block7: {
            try {
                if (this.pgm == null) {
                    new Interpreter().run(this.macro);
                } else {
                    new Interpreter().runMacro(this.pgm, this.address, this.name);
                }
            }
            catch (Throwable throwable) {
                IJ.showStatus("");
                IJ.showProgress(1.0);
                ImagePlus imagePlus = WindowManager.getCurrentImage();
                if (imagePlus != null) {
                    imagePlus.unlock();
                }
                String string = throwable.getMessage();
                if (throwable instanceof RuntimeException && string != null && throwable.getMessage().equals("Macro canceled")) {
                    return;
                }
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                PrintWriter printWriter = new PrintWriter(charArrayWriter);
                throwable.printStackTrace(printWriter);
                String string2 = charArrayWriter.toString();
                if (IJ.isMacintosh()) {
                    string2 = Tools.fixNewLines(string2);
                }
                if (string2.indexOf("NullPointerException") >= 0 && string2.indexOf("ij.process") >= 0) break block7;
                new TextWindow("Exception", string2, 350, 250);
            }
        }
    }
}

