/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;

public class ImageCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
Cloneable {
    protected static Cursor defaultCursor = new Cursor(0);
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor moveCursor = new Cursor(13);
    protected static Cursor crosshairCursor = new Cursor(1);
    public static boolean usePointer = Prefs.usePointerCursor;
    protected ImagePlus imp;
    protected boolean imageUpdated;
    protected Rectangle srcRect;
    protected int imageWidth;
    protected int imageHeight;
    private ImageJ ij;
    private double magnification;
    private int dstWidth;
    private int dstHeight;
    private int xMouseStart;
    private int yMouseStart;
    private int xSrcStart;
    private int ySrcStart;
    private int xMouse;
    private int yMouse;
    private int flags;
    int count;
    private static final double[] zoomLevels = new double[]{0.03125, 0.041666666666666664, 0.0625, 0.08333333333333333, 0.125, 0.16666666666666666, 0.25, 0.3333333333333333, 0.5, 0.75, 1.0, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0, 16.0, 24.0, 32.0};

    public ImageCanvas(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.ij = IJ.getInstance();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        this.imageWidth = n;
        this.imageHeight = n2;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(n, n2);
        this.magnification = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this.ij);
    }

    public void setDrawingSize(int n, int n2) {
        this.dstWidth = n;
        this.dstHeight = n2;
        this.setSize(this.dstWidth, this.dstHeight);
    }

    public void setImageUpdated() {
        this.imageUpdated = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            roi.updatePaste();
        }
        try {
            Image image;
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            if (IJ.isJava2()) {
                if (this.magnification < 1.0) {
                    Java2.setBilinearInterpolation(graphics, true);
                } else if (IJ.isMacOSX()) {
                    Java2.setBilinearInterpolation(graphics, false);
                }
            }
            if ((image = this.imp.getImage()) != null) {
                graphics.drawImage(image, 0, 0, (int)((double)this.srcRect.width * this.magnification), (int)((double)this.srcRect.height * this.magnification), this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (roi != null) {
                roi.draw(graphics);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Paint");
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public Point getCursorLoc() {
        return new Point(this.xMouse, this.yMouse);
    }

    public int getModifiers() {
        return this.flags;
    }

    public void setCursor(int n, int n2, int n3, int n4) {
        this.xMouse = n3;
        this.yMouse = n4;
        Roi roi = this.imp.getRoi();
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow == null) {
            return;
        }
        if (IJ.spaceBarDown()) {
            this.setCursor(handCursor);
            return;
        }
        switch (Toolbar.getToolId()) {
            case 11: {
                if (IJ.isMacintosh()) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(moveCursor);
                break;
            }
            case 12: {
                this.setCursor(handCursor);
                break;
            }
            default: {
                if (roi != null && roi.getState() != 0 && roi.isHandle(n, n2) >= 0) {
                    this.setCursor(handCursor);
                    break;
                }
                if (usePointer || roi != null && roi.getState() != 0 && roi.contains(n3, n4)) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(crosshairCursor);
            }
        }
    }

    public int offScreenX(int n) {
        return this.srcRect.x + (int)((double)n / this.magnification);
    }

    public int offScreenY(int n) {
        return this.srcRect.y + (int)((double)n / this.magnification);
    }

    public int screenX(int n) {
        return (int)((double)(n - this.srcRect.x) * this.magnification);
    }

    public int screenY(int n) {
        return (int)((double)(n - this.srcRect.y) * this.magnification);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double d) {
        this.magnification = d;
        this.imp.setTitle(this.imp.getTitle());
    }

    public Rectangle getSrcRect() {
        return this.srcRect;
    }

    void resizeCanvas(int n, int n2) {
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
            if ((double)n > (double)this.imageWidth * this.magnification) {
                n = (int)((double)this.imageWidth * this.magnification);
            }
            if ((double)n2 > (double)this.imageHeight * this.magnification) {
                n2 = (int)((double)this.imageHeight * this.magnification);
            }
            this.setDrawingSize(n, n2);
            this.srcRect.width = (int)((double)this.dstWidth / this.magnification);
            this.srcRect.height = (int)((double)this.dstHeight / this.magnification);
            if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
                this.srcRect.x = this.imageWidth - this.srcRect.width;
            }
            if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
                this.srcRect.y = this.imageHeight - this.srcRect.height;
            }
            this.repaint();
        }
    }

    static double getLowerZoomLevel(double d) {
        double d2 = zoomLevels[0];
        int n = 0;
        while (n < zoomLevels.length) {
            if (!(zoomLevels[n] < d)) break;
            d2 = zoomLevels[n];
            ++n;
        }
        return d2;
    }

    static double getHigherZoomLevel(double d) {
        double d2 = 32.0;
        int n = zoomLevels.length - 1;
        while (n >= 0) {
            if (!(zoomLevels[n] > d)) break;
            d2 = zoomLevels[n];
            --n;
        }
        return d2;
    }

    public void zoomIn(int n, int n2) {
        int n3;
        if (this.magnification >= 32.0) {
            return;
        }
        double d = ImageCanvas.getHigherZoomLevel(this.magnification);
        int n4 = (int)((double)this.imageWidth * d);
        if (this.canEnlarge(n4, n3 = (int)((double)this.imageHeight * d))) {
            this.setDrawingSize(n4, n3);
            this.imp.getWindow().pack();
        } else {
            int n5;
            int n6 = (int)Math.round((double)this.dstWidth / d);
            if ((double)n6 * d < (double)this.dstWidth) {
                ++n6;
            }
            if ((double)(n5 = (int)Math.round((double)this.dstHeight / d)) * d < (double)this.dstHeight) {
                ++n5;
            }
            n = this.offScreenX(n);
            n2 = this.offScreenY(n2);
            Rectangle rectangle = new Rectangle(n - n6 / 2, n2 - n5 / 2, n6, n5);
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            if (rectangle.x + n6 > this.imageWidth) {
                rectangle.x = this.imageWidth - n6;
            }
            if (rectangle.y + n5 > this.imageHeight) {
                rectangle.y = this.imageHeight - n5;
            }
            this.srcRect = rectangle;
        }
        this.setMagnification(d);
        this.repaint();
    }

    boolean canEnlarge(int n, int n2) {
        if ((this.flags & 1) != 0) {
            return false;
        }
        Rectangle rectangle = this.imp.getWindow().getBounds();
        rectangle.width = n + 20;
        rectangle.height = n2 + 50;
        if (this.imp.getStackSize() > 1) {
            rectangle.height += 20;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl = rectangle.x + rectangle.width < dimension.width && rectangle.y + rectangle.height + 30 < dimension.height;
        return bl;
    }

    public void zoomOut(int n, int n2) {
        if (this.magnification <= 0.03125) {
            return;
        }
        double d = ImageCanvas.getLowerZoomLevel(this.magnification);
        if ((double)this.imageWidth * d > (double)this.dstWidth) {
            int n3;
            int n4 = (int)Math.round((double)this.dstWidth / d);
            if ((double)n4 * d < (double)this.dstWidth) {
                ++n4;
            }
            if ((double)(n3 = (int)Math.round((double)this.dstHeight / d)) * d < (double)this.dstHeight) {
                ++n3;
            }
            n = this.offScreenX(n);
            n2 = this.offScreenY(n2);
            Rectangle rectangle = new Rectangle(n - n4 / 2, n2 - n3 / 2, n4, n3);
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            if (rectangle.x + n4 > this.imageWidth) {
                rectangle.x = this.imageWidth - n4;
            }
            if (rectangle.y + n3 > this.imageHeight) {
                rectangle.y = this.imageHeight - n3;
            }
            this.srcRect = rectangle;
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
            this.setDrawingSize((int)((double)this.imageWidth * d), (int)((double)this.imageHeight * d));
            this.imp.getWindow().pack();
        }
        this.setMagnification(d);
        this.repaint();
    }

    void unzoom() {
        double d = this.imp.getWindow().getInitialMagnification();
        if (this.magnification == d) {
            return;
        }
        this.setMagnification(d);
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        ImageWindow imageWindow = this.imp.getWindow();
        this.setDrawingSize((int)((double)this.imageWidth * d), (int)((double)this.imageHeight * d));
        imageWindow.pack();
        this.repaint();
    }

    void scroll(int n, int n2) {
        int n3 = this.xSrcStart + (int)((double)n / this.magnification);
        int n4 = this.ySrcStart + (int)((double)n2 / this.magnification);
        int n5 = this.xSrcStart + (this.xMouseStart - n3);
        int n6 = this.ySrcStart + (this.yMouseStart - n4);
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 + this.srcRect.width > this.imageWidth) {
            n5 = this.imageWidth - this.srcRect.width;
        }
        if (n6 + this.srcRect.height > this.imageHeight) {
            n6 = this.imageHeight - this.srcRect.height;
        }
        this.srcRect.x = n5;
        this.srcRect.y = n6;
        this.imp.draw();
        Thread.yield();
    }

    Color getColor(int n) {
        IndexColorModel indexColorModel = (IndexColorModel)this.imp.getProcessor().getColorModel();
        return new Color(indexColorModel.getRGB(n));
    }

    protected void setDrawingColor(int n, int n2, boolean bl) {
        Color color;
        int n3 = this.imp.getType();
        int[] nArray = this.imp.getPixel(n, n2);
        switch (n3) {
            case 0: {
                if (bl) {
                    this.setBackgroundColor(this.getColor(nArray[0]));
                    break;
                }
                this.setForegroundColor(this.getColor(nArray[0]));
                break;
            }
            case 1: 
            case 2: {
                double d = this.imp.getProcessor().getMin();
                double d2 = this.imp.getProcessor().getMax();
                double d3 = n3 == 2 ? (double)Float.intBitsToFloat(nArray[0]) : (double)nArray[0];
                int n4 = (int)(255.0 * ((d3 - d) / (d2 - d)));
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                if (bl) {
                    this.setBackgroundColor(this.getColor(n4));
                    break;
                }
                this.setForegroundColor(this.getColor(n4));
                break;
            }
            case 3: 
            case 4: {
                Color color2 = new Color(nArray[0], nArray[1], nArray[2]);
                if (bl) {
                    this.setBackgroundColor(color2);
                    break;
                }
                this.setForegroundColor(color2);
            }
        }
        if (bl) {
            color = Toolbar.getBackgroundColor();
        } else {
            color = Toolbar.getForegroundColor();
            this.imp.setColor(color);
        }
        IJ.showStatus("(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")");
    }

    private void setForegroundColor(Color color) {
        Toolbar.setForegroundColor(color);
        if (Recorder.record) {
            Recorder.record("setForegroundColor", color.getRed(), color.getGreen(), color.getBlue());
        }
    }

    private void setBackgroundColor(Color color) {
        Toolbar.setBackgroundColor(color);
        if (Recorder.record) {
            Recorder.record("setBackgroundColor", color.getRed(), color.getGreen(), color.getBlue());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.ij == null) {
            return;
        }
        int n = Toolbar.getToolId();
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow != null && imageWindow.running && n != 11) {
            imageWindow.running = false;
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.flags = mouseEvent.getModifiers();
        if (IJ.debugMode) {
            IJ.log("Mouse pressed: (" + n2 + "," + n3 + ")" + ImageJ.modifiers(this.flags));
        }
        if (n != 11 && (mouseEvent.isPopupTrigger() || (this.flags & 4) != 0)) {
            this.handlePopupMenu(mouseEvent);
            return;
        }
        int n4 = this.offScreenX(n2);
        int n5 = this.offScreenY(n3);
        this.xMouse = n4;
        this.yMouse = n5;
        if (IJ.spaceBarDown()) {
            this.xMouseStart = n4;
            this.yMouseStart = n5;
            this.xSrcStart = this.srcRect.x;
            this.ySrcStart = this.srcRect.y;
            return;
        }
        if ((this.flags & 8) != 0 && n != 11 && n != 13) {
            this.setDrawingColor(n4, n5, false);
            return;
        }
        switch (n) {
            case 11: {
                if ((this.flags & 0xE) != 0) {
                    this.zoomOut(n2, n3);
                    break;
                }
                this.zoomIn(n2, n3);
                break;
            }
            case 12: {
                this.xMouseStart = n4;
                this.yMouseStart = n5;
                this.xSrcStart = this.srcRect.x;
                this.ySrcStart = this.srcRect.y;
                break;
            }
            case 13: {
                this.setDrawingColor(n4, n5, IJ.altKeyDown());
                break;
            }
            case 7: {
                IJ.doCommand("Measure");
                break;
            }
            case 8: {
                int n6;
                Roi roi = this.imp.getRoi();
                if (roi != null && roi.contains(n4, n5)) {
                    Rectangle rectangle = roi.getBoundingRect();
                    if (rectangle.width == this.imageWidth && rectangle.height == this.imageHeight) {
                        this.imp.killRoi();
                    } else {
                        this.handleRoiMouseDown(n2, n3);
                        return;
                    }
                }
                if (roi != null && (n6 = roi.isHandle(n2, n3)) >= 0) {
                    roi.mouseDownInHandle(n6, n2, n3);
                    return;
                }
                int n7 = IJ.doWand(n4, n5);
                if (!Recorder.record || n7 <= 0) break;
                Recorder.record("doWand", n4, n5);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                Toolbar.getInstance().runMacroTool(n);
                break;
            }
            default: {
                this.handleRoiMouseDown(n2, n3);
            }
        }
    }

    protected void handlePopupMenu(MouseEvent mouseEvent) {
        if (IJ.debugMode) {
            IJ.log("show popup: " + (mouseEvent.isPopupTrigger() ? "true" : "false"));
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8) && roi.getState() == 0) {
            roi.handleMouseUp(n, n2);
            roi.handleMouseUp(n, n2);
            return;
        }
        PopupMenu popupMenu = Menus.getPopupMenu();
        if (popupMenu != null) {
            this.add(popupMenu);
            popupMenu.show(this, n, n2);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow != null) {
            this.setCursor(defaultCursor);
        }
        IJ.showStatus("");
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.xMouse = this.offScreenX(n);
        this.yMouse = this.offScreenY(n2);
        this.flags = mouseEvent.getModifiers();
        if (this.flags == 0) {
            this.flags = 16;
        }
        if (Toolbar.getToolId() == 12 || IJ.spaceBarDown()) {
            this.scroll(n, n2);
        } else {
            Roi roi = this.imp.getRoi();
            if (roi != null) {
                roi.handleMouseDrag(n, n2, (this.flags & 1) != 0);
            }
        }
    }

    void handleRoiMouseDown(int n, int n2) {
        int n3 = this.offScreenX(n);
        int n4 = this.offScreenY(n2);
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle rectangle = roi.getBoundingRect();
            int n5 = roi.getType();
            if (n5 == 0 && rectangle.width == this.imp.getWidth() && rectangle.height == this.imp.getHeight() && roi.getPasteMode() == -1) {
                this.imp.killRoi();
                return;
            }
            int n6 = roi.isHandle(n, n2);
            if (n6 >= 0) {
                roi.mouseDownInHandle(n6, n, n2);
                return;
            }
            if (roi.contains(n3, n4)) {
                roi.handleMouseDown(n, n2);
                return;
            }
            if ((n5 == 2 || n5 == 6 || n5 == 8) && roi.getState() == 0) {
                return;
            }
        }
        this.imp.createNewRoi(n3, n4);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.flags = mouseEvent.getModifiers();
        this.flags &= 0xFFFFFFEF;
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle rectangle = roi.getBoundingRect();
            if (!(rectangle.width != 0 && rectangle.height != 0 || roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8 || roi instanceof TextRoi || roi.getState() != 0)) {
                this.imp.killRoi();
            } else {
                roi.handleMouseUp(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.ij == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.offScreenX(n);
        int n4 = this.offScreenY(n2);
        this.flags = mouseEvent.getModifiers();
        this.setCursor(n, n2, n3, n4);
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8) && roi.getState() == 0) {
            PolygonRoi polygonRoi = (PolygonRoi)roi;
            polygonRoi.handleMouseMove(n3, n4);
        } else if (n3 < this.imageWidth && n4 < this.imageHeight) {
            ImageWindow imageWindow = this.imp.getWindow();
            if (imageWindow != null) {
                imageWindow.mouseMoved(n3, n4);
            }
        } else {
            IJ.showStatus("");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

